/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.base.AbstractBarcodeBase;
import java.awt.image.BufferedImage;
import java.util.Map;
import javax.inject.Inject;
import org.krysalis.barcode4j.impl.upcean.EAN13Bean;
import org.krysalis.barcode4j.impl.upcean.EAN8Bean;
import org.krysalis.barcode4j.impl.upcean.UPCEANBean;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Scanned
public class EANCodeMacro
extends AbstractBarcodeBase
implements Macro {
    private static final Logger log = LoggerFactory.getLogger(EANCodeMacro.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;
    public static final String INPUT_DATA_TOO_LONG = "<div class=\"aui-message aui-message-error\">Input data too long</div>";
    public static final String PLEASE_PROVIDE_CONTENT_INFO = "<div class=\"aui-message aui-message-error\">Please provide content</div>";
    public static final String EAN_CODE_MUST_CONTAIN_NUMBERS_WARNING = "<div class=\"aui-message aui-message-error\">Invalid input. EAN-Code must only contain numbers</div>";

    @Inject
    public EANCodeMacro(PluginLicenseManager pluginLicenseManager) {
        super(pluginLicenseManager);
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public String execute(Map<String, String> map, String body, ConversionContext conversionContext) throws MacroExecutionException {
        UPCEANBean upceanBean;
        String height = map.get("height");
        String type = map.get("type");
        if (body == null || body.equals("")) {
            return PLEASE_PROVIDE_CONTENT_INFO;
        }
        if (!body.matches("\\d+")) {
            return EAN_CODE_MUST_CONTAIN_NUMBERS_WARNING;
        }
        if ("EAN13".equals(type)) {
            upceanBean = new EAN13Bean();
            log.debug("Setting mode to EAN13");
        } else {
            upceanBean = new EAN8Bean();
            log.debug("Setting mode to EAN8");
        }
        if (upceanBean instanceof EAN8Bean && body.length() > 7) {
            if (body.length() == 8) {
                body = body.substring(0, 7);
            } else {
                log.debug("Input length of {}", (Object)body.length());
                return INPUT_DATA_TOO_LONG;
            }
        }
        if (upceanBean instanceof EAN13Bean && body.length() > 12) {
            if (body.length() == 13) {
                body = body.substring(0, 12);
            } else {
                log.debug("Input length of {}", (Object)body.length());
                return INPUT_DATA_TOO_LONG;
            }
        }
        int barcodeHeight = 100;
        try {
            barcodeHeight = Integer.valueOf(height);
        }
        catch (NumberFormatException e) {
            log.debug("Invalid height {} using default height 100", (Object)barcodeHeight);
        }
        BitmapCanvasProvider canvas = new BitmapCanvasProvider(barcodeHeight * 3, 12, false, 0);
        upceanBean.generateBarcode(canvas, body);
        BufferedImage image = canvas.getBufferedImage();
        return this.getRenderedImage(body, barcodeHeight, image);
    }
}

