/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.base.AbstractBarcodeBase;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.Code93;
import uk.org.okapibarcode.backend.OkapiException;

@Scanned
public class Code93Macro
extends AbstractBarcodeBase {
    private static final Logger log = LoggerFactory.getLogger(Code93Macro.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public Code93Macro(PluginLicenseManager pluginLicenseManager) {
        super(pluginLicenseManager);
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public String execute(Map<String, String> map, String s, ConversionContext conversionContext) throws MacroExecutionException {
        String showText = map.get("showtext");
        Boolean checkDigit = Boolean.valueOf(map.get("checkdigit"));
        String startStopDelimiter = map.get("startstopdelimiter");
        String height = map.get("height");
        if (s == null || s.length() == 0) {
            return "<div class=\"aui-message error shadowed\">Please provide a value to encode in the body</div>";
        }
        Code93 code = new Code93();
        if (Boolean.TRUE.equals(checkDigit)) {
            code.setShowCheckDigits(true);
            log.debug("Showing Checkdigits");
        } else {
            code.setShowCheckDigits(false);
            log.debug("NOT showing Checkdigits");
        }
        if (startStopDelimiter != null && startStopDelimiter.length() > 0) {
            code.setStartStopDelimiter(Character.valueOf(startStopDelimiter.toCharArray()[0]));
        }
        this.checkAndSetHumanReadableLocation(code, showText);
        try {
            code.setContent(s);
        }
        catch (OkapiException e) {
            return this.displayErrorMessage(e.getMessage());
        }
        return this.getRenderedImage(code, height);
    }
}

