/*
 * Decompiled with CFR 0.152.
 */
package com.rocketdev.confluence.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.rocketdev.confluence.base.AbstractBarcodeBase;
import java.util.Map;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import uk.org.okapibarcode.backend.Code3Of9;
import uk.org.okapibarcode.backend.OkapiException;

@Scanned
public class Code3of9Macro
extends AbstractBarcodeBase {
    private static final Logger log = LoggerFactory.getLogger(Code3of9Macro.class);
    @ComponentImport
    private final PluginLicenseManager pluginLicenseManager;

    @Inject
    public Code3of9Macro(PluginLicenseManager pluginLicenseManager) {
        super(pluginLicenseManager);
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public String execute(Map<String, String> map, String s, ConversionContext conversionContext) throws MacroExecutionException {
        String showText = map.get("showtext");
        Boolean checkDigit = Boolean.valueOf(map.get("checkdigit"));
        String height = map.get("height");
        if (s == null || s.length() == 0) {
            return "<div class=\"aui-message error shadowed\">Please provide a value to encode in the body</div>";
        }
        Code3Of9 code = new Code3Of9();
        if (Boolean.TRUE.equals(checkDigit)) {
            code.setCheckDigit(Code3Of9.CheckDigit.MOD43);
            log.debug("Setting Checkdigit");
        } else {
            code.setCheckDigit(Code3Of9.CheckDigit.NONE);
            log.debug("Not setting Checkdigit");
        }
        this.checkAndSetHumanReadableLocation(code, showText);
        try {
            code.setContent(s);
        }
        catch (OkapiException e) {
            return this.displayErrorMessage(e.getMessage());
        }
        return this.getRenderedImage(code, height);
    }
}

