/*
 * Decompiled with CFR 0.152.
 */
package com.mindville.confluence.plugins.insight.api;

import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.confluence.core.ContentEntityObject;
import com.atlassian.confluence.core.ContentPropertyManager;
import com.atlassian.confluence.pages.PageManager;
import com.mindville.confluence.plugins.insight.api.ApplicationLinkRestEntry;
import com.mindville.confluence.plugins.insight.api.StoreMacroViewHtmlRestInModel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Path(value="/utils")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\b\u0010\t\u001a\u00020\nH\u0007J\u0010\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\rH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/mindville/confluence/plugins/insight/api/UtilsResource;", "", "applicationLinkService", "Lcom/atlassian/applinks/api/ApplicationLinkService;", "contentPropertyManager", "Lcom/atlassian/confluence/core/ContentPropertyManager;", "pageManager", "Lcom/atlassian/confluence/pages/PageManager;", "(Lcom/atlassian/applinks/api/ApplicationLinkService;Lcom/atlassian/confluence/core/ContentPropertyManager;Lcom/atlassian/confluence/pages/PageManager;)V", "jiraApplicationLinks", "Ljavax/ws/rs/core/Response;", "storeMacroViewHtml", "payload", "Lcom/mindville/confluence/plugins/insight/api/StoreMacroViewHtmlRestInModel;", "insight-confluence"})
public final class UtilsResource {
    @NotNull
    private final ApplicationLinkService applicationLinkService;
    @NotNull
    private final ContentPropertyManager contentPropertyManager;
    @NotNull
    private final PageManager pageManager;

    @Inject
    public UtilsResource(@NotNull ApplicationLinkService applicationLinkService, @NotNull ContentPropertyManager contentPropertyManager, @NotNull PageManager pageManager) {
        Intrinsics.checkNotNullParameter(applicationLinkService, "applicationLinkService");
        Intrinsics.checkNotNullParameter(contentPropertyManager, "contentPropertyManager");
        Intrinsics.checkNotNullParameter(pageManager, "pageManager");
        this.applicationLinkService = applicationLinkService;
        this.contentPropertyManager = contentPropertyManager;
        this.pageManager = pageManager;
    }

    @POST
    @Path(value="/store-macro-view-html")
    @Produces(value={"application/json"})
    @NotNull
    public final Response storeMacroViewHtml(@NotNull StoreMacroViewHtmlRestInModel payload) {
        Intrinsics.checkNotNullParameter(payload, "payload");
        String propertyId = "rlabs-ifc-macro-static-content-" + payload.getMacroInstanceId();
        ContentEntityObject contentEntityObject = this.pageManager.getById(Long.parseLong(payload.getContentEntityObjectId()));
        this.contentPropertyManager.setTextProperty(contentEntityObject, propertyId, payload.getMacroViewHtml());
        Response response = Response.ok().build();
        Intrinsics.checkNotNullExpressionValue(response, "ok().build()");
        return response;
    }

    @GET
    @Path(value="/jira-application-links")
    @Produces(value={"application/json"})
    @NotNull
    public final Response jiraApplicationLinks() {
        Iterable jiraApplicationLinks = this.applicationLinkService.getApplicationLinks(JiraApplicationType.class);
        List applicationLinkRestEntries = new ArrayList();
        Iterator iterator2 = jiraApplicationLinks.iterator();
        while (iterator2.hasNext()) {
            ApplicationLink jiraApplicationLink;
            ApplicationLink $this$jiraApplicationLinks_u24lambda_u240 = jiraApplicationLink = (ApplicationLink)iterator2.next();
            boolean bl = false;
            String string = $this$jiraApplicationLinks_u24lambda_u240.getId().get();
            String string2 = $this$jiraApplicationLinks_u24lambda_u240.getName();
            boolean bl2 = $this$jiraApplicationLinks_u24lambda_u240.isPrimary();
            String string3 = $this$jiraApplicationLinks_u24lambda_u240.getRpcUrl().toString();
            String string4 = $this$jiraApplicationLinks_u24lambda_u240.getDisplayUrl().toString();
            Intrinsics.checkNotNullExpressionValue(string, "get()");
            Intrinsics.checkNotNullExpressionValue(string2, "name");
            Intrinsics.checkNotNullExpressionValue(string4, "toString()");
            Intrinsics.checkNotNullExpressionValue(string3, "toString()");
            ApplicationLinkRestEntry applicationLinkRestEntry = new ApplicationLinkRestEntry(string, string2, bl2, string4, string3);
            applicationLinkRestEntries.add(applicationLinkRestEntry);
        }
        Response response = Response.ok((Object)applicationLinkRestEntries).build();
        Intrinsics.checkNotNullExpressionValue(response, "ok(applicationLinkRestEntries).build()");
        return response;
    }
}

