/*
 * Decompiled with CFR 0.152.
 */
package com.mindville.confluence.plugins.insight.api;

import com.atlassian.sal.api.net.ResponseException;
import com.google.common.collect.ImmutableMap;
import com.mindville.confluence.plugins.insight.jira.ApplicationLinkRequestClient;
import com.mindville.confluence.plugins.insight.jira.BadCredentialsException;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Path(value="/jira-proxy")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u000f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0012\u0010\u0005\u001a\u00020\u00062\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007J\u001a\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\b2\b\b\u0001\u0010\u0007\u001a\u00020\bH\u0007R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000b"}, d2={"Lcom/mindville/confluence/plugins/insight/api/JiraProxyResource;", "", "applicationLinkRequestClient", "Lcom/mindville/confluence/plugins/insight/jira/ApplicationLinkRequestClient;", "(Lcom/mindville/confluence/plugins/insight/jira/ApplicationLinkRequestClient;)V", "jiraProxyGET", "Ljavax/ws/rs/core/Response;", "url", "", "jiraProxyPOST", "payload", "insight-confluence"})
public final class JiraProxyResource {
    @NotNull
    private final ApplicationLinkRequestClient applicationLinkRequestClient;

    @Inject
    public JiraProxyResource(@NotNull ApplicationLinkRequestClient applicationLinkRequestClient) {
        Intrinsics.checkNotNullParameter(applicationLinkRequestClient, "applicationLinkRequestClient");
        this.applicationLinkRequestClient = applicationLinkRequestClient;
    }

    @POST
    @Path(value="/")
    @NotNull
    public final Response jiraProxyPOST(@NotNull String payload, @QueryParam(value="url") @NotNull String url) throws ResponseException {
        Intrinsics.checkNotNullParameter(payload, "payload");
        Intrinsics.checkNotNullParameter(url, "url");
        ImmutableMap immutableMap = ImmutableMap.of((Object)"Content-Type", (Object)"application/json");
        Intrinsics.checkNotNullExpressionValue(immutableMap, "of(\"Content-Type\", \"application/json\")");
        com.atlassian.sal.api.net.Response $this$jiraProxyPOST_u24lambda_u240 = this.applicationLinkRequestClient.post(url, payload, (Map)immutableMap);
        boolean bl = false;
        Response response = Response.status((int)$this$jiraProxyPOST_u24lambda_u240.getStatusCode()).entity((Object)$this$jiraProxyPOST_u24lambda_u240.getResponseBodyAsString()).build();
        Intrinsics.checkNotNullExpressionValue(response, "with(applicationLinkRequ\u2026String).build()\n        }");
        return response;
    }

    @GET
    @Path(value="/")
    @NotNull
    public final Response jiraProxyGET(@QueryParam(value="url") @NotNull String url) throws ResponseException {
        Response response;
        Intrinsics.checkNotNullParameter(url, "url");
        try {
            ImmutableMap immutableMap = ImmutableMap.of((Object)"Content-Type", (Object)"application/json");
            Intrinsics.checkNotNullExpressionValue(immutableMap, "of(\"Content-Type\", \"application/json\")");
            com.atlassian.sal.api.net.Response $this$jiraProxyGET_u24lambda_u241 = this.applicationLinkRequestClient.get(url, (Map)immutableMap);
            boolean bl = false;
            Response.ResponseBuilder responseBuilder = Response.status((int)$this$jiraProxyGET_u24lambda_u241.getStatusCode());
            String string = $this$jiraProxyGET_u24lambda_u241.getHeader("Content-Type");
            Intrinsics.checkNotNullExpressionValue(string, "getHeader(\"Content-Type\")");
            if (StringsKt.contains$default((CharSequence)string, "image", false, 2, null)) {
                responseBuilder.entity((Object)$this$jiraProxyGET_u24lambda_u241.getResponseBodyAsStream());
            } else {
                responseBuilder.entity((Object)$this$jiraProxyGET_u24lambda_u241.getResponseBodyAsString());
            }
            responseBuilder.header("Content-Type", (Object)$this$jiraProxyGET_u24lambda_u241.getHeader("Content-Type"));
            responseBuilder.header("Cache-Control", (Object)$this$jiraProxyGET_u24lambda_u241.getHeader("Cache-Control"));
            response = responseBuilder.build();
            Intrinsics.checkNotNullExpressionValue(response, "{\n            with (appl\u2026)\n            }\n        }");
        }
        catch (BadCredentialsException e) {
            Map response2 = new HashMap();
            response2.put("errorMsg", "The application must be authorized.");
            response2.put("authorizationUrl", e.getAuthorisationURI());
            Response response3 = Response.status((int)401).entity((Object)response2).build();
            Intrinsics.checkNotNullExpressionValue(response3, "{\n            val respon\u2026sponse).build()\n        }");
            response = response3;
        }
        return response;
    }
}

