/*
 * Decompiled with CFR 0.152.
 */
package com.mindville.confluence.plugins.insight.jira;

import com.atlassian.applinks.api.ApplicationId;
import com.atlassian.applinks.api.ApplicationLink;
import com.atlassian.applinks.api.ApplicationLinkRequest;
import com.atlassian.applinks.api.ApplicationLinkResponseHandler;
import com.atlassian.applinks.api.ApplicationLinkService;
import com.atlassian.applinks.api.CredentialsRequiredException;
import com.atlassian.applinks.api.TypeNotInstalledException;
import com.atlassian.applinks.api.application.jira.JiraApplicationType;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.Response;
import com.atlassian.sal.api.net.ResponseException;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.mindville.confluence.plugins.insight.jira.ApplicationLinkRequestClient;
import com.mindville.confluence.plugins.insight.jira.BadCredentialsException;
import com.mindville.confluence.plugins.insight.jira.BadResponseException;
import com.mindville.confluence.plugins.insight.jira.EndpointFactory;
import com.mindville.confluence.plugins.insight.jira.NoApplicationLinkException;
import java.net.URI;
import java.util.Iterator;
import java.util.Map;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Named
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00162\u00020\u0001:\u0001\u0016B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J6\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0010H\u0002J$\u0010\u0014\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0012H\u0016J,\u0010\u0015\u001a\u00020\f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0013\u001a\u00020\u00102\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u0012H\u0016R\u0016\u0010\u0007\u001a\u0004\u0018\u00010\b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"Lcom/mindville/confluence/plugins/insight/jira/ApplicationLinkRequestClientImpl;", "Lcom/mindville/confluence/plugins/insight/jira/ApplicationLinkRequestClient;", "pluginSettingsFactory", "Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;", "applicationLinkService", "Lcom/atlassian/applinks/api/ApplicationLinkService;", "(Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;Lcom/atlassian/applinks/api/ApplicationLinkService;)V", "applicationLink", "Lcom/atlassian/applinks/api/ApplicationLink;", "getApplicationLink", "()Lcom/atlassian/applinks/api/ApplicationLink;", "execute", "Lcom/atlassian/sal/api/net/Response;", "methodType", "Lcom/atlassian/sal/api/net/Request$MethodType;", "url", "", "headers", "", "payload", "get", "post", "Companion", "insight-confluence"})
@SourceDebugExtension(value={"SMAP\nApplicationLinkRequestClientImpl.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ApplicationLinkRequestClientImpl.kt\ncom/mindville/confluence/plugins/insight/jira/ApplicationLinkRequestClientImpl\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,95:1\n215#2,2:96\n*S KotlinDebug\n*F\n+ 1 ApplicationLinkRequestClientImpl.kt\ncom/mindville/confluence/plugins/insight/jira/ApplicationLinkRequestClientImpl\n*L\n42#1:96,2\n*E\n"})
public final class ApplicationLinkRequestClientImpl
implements ApplicationLinkRequestClient {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final PluginSettingsFactory pluginSettingsFactory;
    @NotNull
    private final ApplicationLinkService applicationLinkService;
    private static final Log log = LogFactory.getLog(ApplicationLinkRequestClientImpl.class);
    @NotNull
    private static final String SETTING_NAMESPACE = "com.mindville.confluence.plugins.insight:";
    private static final int CONNECTION_TIMEOUT_MS = 30000;

    public ApplicationLinkRequestClientImpl(@NotNull PluginSettingsFactory pluginSettingsFactory, @NotNull ApplicationLinkService applicationLinkService) {
        Intrinsics.checkNotNullParameter(pluginSettingsFactory, "pluginSettingsFactory");
        Intrinsics.checkNotNullParameter(applicationLinkService, "applicationLinkService");
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.applicationLinkService = applicationLinkService;
    }

    @Override
    @NotNull
    public Response get(@NotNull String url, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(headers, "headers");
        return ApplicationLinkRequestClientImpl.execute$default(this, Request.MethodType.GET, url, headers, null, 8, null);
    }

    @Override
    @NotNull
    public Response post(@NotNull String url, @NotNull String payload, @NotNull Map<String, String> headers) {
        Intrinsics.checkNotNullParameter(url, "url");
        Intrinsics.checkNotNullParameter(payload, "payload");
        Intrinsics.checkNotNullParameter(headers, "headers");
        return this.execute(Request.MethodType.POST, url, headers, payload);
    }

    private final Response execute(Request.MethodType methodType, String url, Map<String, String> headers, String payload) {
        Response response;
        ApplicationLink applicationLink = this.getApplicationLink();
        if (applicationLink != null) {
            URI uRI = applicationLink.getRpcUrl();
            Intrinsics.checkNotNullExpressionValue(uRI, "applicationLink.rpcUrl");
            String endpoint = EndpointFactory.Companion.create(uRI, url);
            try {
                ApplicationLinkRequest $this$execute_u24lambda_u241 = applicationLink.createAuthenticatedRequestFactory().createRequest(methodType, endpoint);
                boolean bl = false;
                $this$execute_u24lambda_u241.setConnectionTimeout(30000);
                if (Request.MethodType.POST == methodType) {
                    $this$execute_u24lambda_u241.setRequestBody(payload);
                }
                Map<String, String> $this$forEach$iv = headers;
                boolean $i$f$forEach = false;
                Iterator<Map.Entry<String, String>> iterator2 = $this$forEach$iv.entrySet().iterator();
                while (iterator2.hasNext()) {
                    Map.Entry<String, String> element$iv;
                    Map.Entry<String, String> entry = element$iv = iterator2.next();
                    boolean bl2 = false;
                    String key = entry.getKey();
                    String value = entry.getValue();
                    $this$execute_u24lambda_u241.addHeader(key, value);
                }
                response = (Response)$this$execute_u24lambda_u241.execute((ApplicationLinkResponseHandler)new ApplicationLinkResponseHandler<Response>(){

                    @NotNull
                    public Response handle(@NotNull Response response) throws ResponseException {
                        Intrinsics.checkNotNullParameter(response, "response");
                        return response;
                    }

                    @Nullable
                    public Response credentialsRequired(@NotNull Response response) throws ResponseException {
                        Intrinsics.checkNotNullParameter(response, "response");
                        return null;
                    }
                });
            }
            catch (CredentialsRequiredException e) {
                throw new BadCredentialsException(e);
            }
            catch (ResponseException e) {
                throw new BadResponseException(e);
            }
        } else {
            throw new NoApplicationLinkException();
        }
        Response response2 = response;
        Intrinsics.checkNotNullExpressionValue(response2, "{\n            val endpoi\u2026)\n            }\n        }");
        return response2;
    }

    static /* synthetic */ Response execute$default(ApplicationLinkRequestClientImpl applicationLinkRequestClientImpl, Request.MethodType methodType, String string, Map map2, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "";
        }
        return applicationLinkRequestClientImpl.execute(methodType, string, map2, string2);
    }

    private final ApplicationLink getApplicationLink() {
        ApplicationLink applicationLink;
        PluginSettings pluginSettings = this.pluginSettingsFactory.createSettingsForKey(SETTING_NAMESPACE);
        Object jiraApplicationLinkId = pluginSettings.get("jiraApplicationLinkId");
        if (jiraApplicationLinkId != null) {
            ApplicationLink applicationLink2;
            try {
                applicationLink2 = this.applicationLinkService.getApplicationLink(new ApplicationId((String)jiraApplicationLinkId));
            }
            catch (TypeNotInstalledException e) {
                log.error((Object)e);
                applicationLink2 = this.applicationLinkService.getPrimaryApplicationLink(JiraApplicationType.class);
            }
            applicationLink = applicationLink2;
        } else {
            applicationLink = this.applicationLinkService.getPrimaryApplicationLink(JiraApplicationType.class);
        }
        return applicationLink;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082T\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0007\u001a\n \t*\u0004\u0018\u00010\b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lcom/mindville/confluence/plugins/insight/jira/ApplicationLinkRequestClientImpl$Companion;", "", "()V", "CONNECTION_TIMEOUT_MS", "", "SETTING_NAMESPACE", "", "log", "Lorg/apache/commons/logging/Log;", "kotlin.jvm.PlatformType", "insight-confluence"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

