/*
 * Decompiled with CFR 0.152.
 */
package com.mindville.confluence.plugins.insight.export;

import com.atlassian.confluence.core.FormatSettingsManager;
import com.atlassian.plugin.util.ClassLoaderUtils;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import com.mindville.confluence.plugins.insight.jira.ApplicationLinkRequestClient;
import com.mindville.confluence.plugins.insight.model.ObjectAttributeEntry;
import com.mindville.confluence.plugins.insight.model.ObjectAttributeValueEntry;
import com.mindville.confluence.plugins.insight.model.ObjectEntry;
import com.mindville.confluence.plugins.insight.model.ObjectListResultEntry;
import com.mindville.confluence.plugins.insight.model.ObjectTypeAttributeEntry;
import java.lang.reflect.Type;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import javax.inject.Named;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.apache.log4j.Logger;
import org.jetbrains.annotations.NotNull;

@Named
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000r\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0005\b\u0007\u0018\u0000 12\u00020\u0001:\u00011B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ,\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000f0\u00120\u00112\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0010\u0010\u0015\u001a\u00020\u000f2\u0006\u0010\u0016\u001a\u00020\u000fH\u0002J$\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00180\u00122\u0006\u0010\u0019\u001a\u00020\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0002J.\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0019\u001a\u00020\u000f2\u0006\u0010\u001e\u001a\u00020\u000f2\u0006\u0010\u001f\u001a\u00020\u000f2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001bH\u0002J\u0016\u0010 \u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010!\u001a\u00020\"H\u0002J\u0010\u0010#\u001a\u00020\"2\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0016\u0010$\u001a\b\u0012\u0004\u0012\u00020\u000f0\u001b2\u0006\u0010\u001a\u001a\u00020\u000fH\u0002J\u001a\u0010%\u001a\u00020\u000f2\u0012\u0010&\u001a\u000e\u0012\u0004\u0012\u00020\u000f\u0012\u0004\u0012\u00020\u000f0'J\u001e\u0010(\u001a\u00020\u000f2\u0006\u0010\u0013\u001a\u00020\u00142\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0\u0011H\u0002J.\u0010*\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u001d2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002J.\u0010/\u001a\u00020\u000f2\u0006\u0010+\u001a\u00020\u001d2\f\u00100\u001a\b\u0012\u0004\u0012\u00020\u000f0\u00112\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\t\u001a\n \u000b*\u0004\u0018\u00010\n0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00062"}, d2={"Lcom/mindville/confluence/plugins/insight/export/ExportRenderer;", "", "applicationLinkRequestClient", "Lcom/mindville/confluence/plugins/insight/jira/ApplicationLinkRequestClient;", "formatSettingsManager", "Lcom/atlassian/confluence/core/FormatSettingsManager;", "soyTemplateRenderer", "Lcom/atlassian/soy/renderer/SoyTemplateRenderer;", "(Lcom/mindville/confluence/plugins/insight/jira/ApplicationLinkRequestClient;Lcom/atlassian/confluence/core/FormatSettingsManager;Lcom/atlassian/soy/renderer/SoyTemplateRenderer;)V", "logger", "Lorg/apache/log4j/Logger;", "kotlin.jvm.PlatformType", "addAttributeToList", "", "attributeName", "", "targetList", "", "", "objectEntry", "Lcom/mindville/confluence/plugins/insight/model/ObjectEntry;", "fetch", "url", "fetchAssetsAttributes", "Lcom/mindville/confluence/plugins/insight/model/ObjectTypeAttributeEntry;", "objectSchemaId", "attributesToDisplay", "", "fetchAssetsObjects", "Lcom/mindville/confluence/plugins/insight/model/ObjectListResultEntry;", "iql", "page", "getCellValuesList", "attributeValueEntry", "Lcom/mindville/confluence/plugins/insight/model/ObjectAttributeEntry;", "getLabelAttributeValue", "mapAttributesToDisplay", "render", "theParams", "", "renderSingleView", "tableHeaders", "renderTableView", "objectResults", "columnBorders", "", "fullWidth", "renderVerticalTableView", "attributeHeaders", "Companion", "insight-confluence"})
@SourceDebugExtension(value={"SMAP\nExportRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExportRenderer.kt\ncom/mindville/confluence/plugins/insight/export/ExportRenderer\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,344:1\n288#2,2:345\n288#2,2:347\n288#2,2:349\n223#2,2:351\n766#2:353\n857#2,2:354\n766#2:356\n857#2,2:357\n1855#2:359\n766#2:360\n857#2,2:361\n1856#2:363\n1549#2:364\n1620#2,3:365\n*S KotlinDebug\n*F\n+ 1 ExportRenderer.kt\ncom/mindville/confluence/plugins/insight/export/ExportRenderer\n*L\n84#1:345,2\n200#1:347,2\n226#1:349,2\n243#1:351,2\n308#1:353\n308#1:354,2\n328#1:356\n328#1:357,2\n331#1:359\n332#1:360\n332#1:361,2\n331#1:363\n341#1:364\n341#1:365,3\n*E\n"})
public final class ExportRenderer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ApplicationLinkRequestClient applicationLinkRequestClient;
    @NotNull
    private final FormatSettingsManager formatSettingsManager;
    @NotNull
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final Logger logger;
    @NotNull
    public static final String NAME_ATTRIBUTE = "Name";
    @NotNull
    private static final Gson gson;
    @NotNull
    private static final String styles;

    public ExportRenderer(@NotNull ApplicationLinkRequestClient applicationLinkRequestClient, @NotNull FormatSettingsManager formatSettingsManager, @NotNull SoyTemplateRenderer soyTemplateRenderer) {
        Intrinsics.checkNotNullParameter(applicationLinkRequestClient, "applicationLinkRequestClient");
        Intrinsics.checkNotNullParameter(formatSettingsManager, "formatSettingsManager");
        Intrinsics.checkNotNullParameter(soyTemplateRenderer, "soyTemplateRenderer");
        this.applicationLinkRequestClient = applicationLinkRequestClient;
        this.formatSettingsManager = formatSettingsManager;
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.logger = Logger.getLogger(ExportRenderer.class);
    }

    @NotNull
    public final String render(@NotNull Map<String, String> theParams) {
        String string;
        Intrinsics.checkNotNullParameter(theParams, "theParams");
        String objectSchemaId = null;
        Set<String> attributesToDisplay = null;
        String loadMoreLimit = null;
        try {
            String string2 = theParams.get("objectSchemaId");
            if (string2 == null) {
                throw new IllegalStateException("Missing object schema id parameter".toString());
            }
            objectSchemaId = string2;
            String string3 = theParams.get("attributesToDisplay");
            if (string3 == null) {
                throw new IllegalStateException("Missing list of attributes to display parameter".toString());
            }
            attributesToDisplay = this.mapAttributesToDisplay(string3);
            String string4 = theParams.get("loadMoreLimit");
            if (string4 == null) {
                throw new IllegalStateException("Missing load more limit parameter".toString());
            }
            loadMoreLimit = string4;
        }
        catch (Throwable t) {
            this.logger.error((Object)"Export fail!", t);
            return "Something went wrong: " + t.getMessage();
        }
        try {
            boolean columnBorders = Boolean.parseBoolean(theParams.get("tableColumnBorders"));
            boolean fullWidth = Boolean.parseBoolean(theParams.get("fullWidthTable"));
            boolean singleView = Intrinsics.areEqual(theParams.get("displayAs"), "single");
            boolean verticalView = Intrinsics.areEqual(theParams.get("displayAs"), "vertical_table");
            String string5 = theParams.get("iql");
            if (string5 == null) {
                string5 = "";
            }
            String iql = string5;
            List<ObjectTypeAttributeEntry> attributeData = this.fetchAssetsAttributes(objectSchemaId, attributesToDisplay);
            List attributeHeaders = new ArrayList();
            for (String attributeName : attributesToDisplay) {
                ObjectTypeAttributeEntry attributeEntry;
                Object v4;
                block17: {
                    if (Intrinsics.areEqual(attributeName, "Label") || Intrinsics.areEqual(attributeName, "ObjectType")) {
                        attributeHeaders.add(attributeName);
                        continue;
                    }
                    Iterable $this$firstOrNull$iv = attributeData;
                    boolean $i$f$firstOrNull = false;
                    for (Object element$iv : $this$firstOrNull$iv) {
                        ObjectTypeAttributeEntry it = (ObjectTypeAttributeEntry)element$iv;
                        boolean bl = false;
                        if (!(Intrinsics.areEqual(it.getName(), attributeName) || Intrinsics.areEqual(String.valueOf(it.getId()), attributeName))) continue;
                        v4 = element$iv;
                        break block17;
                    }
                    v4 = null;
                }
                if ((attributeEntry = (ObjectTypeAttributeEntry)v4) == null || attributeHeaders.contains(attributeEntry.getName())) continue;
                attributeHeaders.add(attributeEntry.getName());
            }
            StringBuilder macroViewHtml = new StringBuilder();
            int pageIndex = 1;
            int pageAmount = Integer.parseInt(loadMoreLimit) / 100;
            int n = pageAmount + 1;
            if (pageIndex <= n) {
                while (true) {
                    String string6;
                    ObjectListResultEntry objectResults = this.fetchAssetsObjects(objectSchemaId, iql, String.valueOf(pageIndex), attributesToDisplay);
                    if (verticalView) {
                        string6 = this.renderVerticalTableView(objectResults, attributeHeaders, columnBorders, fullWidth);
                    } else if (singleView) {
                        ObjectEntry objectEntry = CollectionsKt.first(objectResults.getObjectEntries());
                        string6 = this.renderSingleView(objectEntry, attributeHeaders);
                    } else {
                        string6 = this.renderTableView(objectResults, attributeHeaders, columnBorders, fullWidth);
                    }
                    macroViewHtml.append(string6);
                    if (pageIndex == n) break;
                    ++pageIndex;
                }
            }
            macroViewHtml.append("<style>" + styles + "</style>");
            string = macroViewHtml.toString();
            Intrinsics.checkNotNullExpressionValue(string, "{\n            val column\u2026Html.toString()\n        }");
        }
        catch (Throwable t) {
            this.logger.error((Object)"Export fail!", t);
            string = "Could not export data. See logs for details.";
        }
        return string;
    }

    private final String renderVerticalTableView(ObjectListResultEntry objectResults, List<String> attributeHeaders, boolean columnBorders, boolean fullWidth) {
        Map perAttributeTable = new LinkedHashMap();
        for (String attributeName : attributeHeaders) {
            List attributeValues = new ArrayList();
            for (ObjectEntry objectEntry : objectResults.getObjectEntries()) {
                this.addAttributeToList(attributeName, attributeValues, objectEntry);
            }
            perAttributeTable.put(attributeName, attributeValues);
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to("attributes", perAttributeTable), TuplesKt.to("columnBorders", columnBorders), TuplesKt.to("fullWidth", fullWidth)};
        String string = this.soyTemplateRenderer.render("com.riadalabs.confluence.plugins.insight-confluence:export-soy", "confluence.plugins.insight.export.verticalTable", MapsKt.mapOf(pairArray));
        Intrinsics.checkNotNullExpressionValue(string, "soyTemplateRenderer.rend\u2026h\n            )\n        )");
        return string;
    }

    private final String renderTableView(ObjectListResultEntry objectResults, List<String> tableHeaders, boolean columnBorders, boolean fullWidth) {
        List objectAttributesTable = new ArrayList();
        for (ObjectEntry objectEntry : objectResults.getObjectEntries()) {
            List attributeValues = new ArrayList();
            for (String attribute : tableHeaders) {
                this.addAttributeToList(attribute, attributeValues, objectEntry);
            }
            objectAttributesTable.add(attributeValues);
        }
        Pair[] pairArray = new Pair[]{TuplesKt.to("tableHeaders", tableHeaders), TuplesKt.to("objects", objectAttributesTable), TuplesKt.to("columnBorders", columnBorders), TuplesKt.to("fullWidth", fullWidth)};
        String string = this.soyTemplateRenderer.render("com.riadalabs.confluence.plugins.insight-confluence:export-soy", "confluence.plugins.insight.export.standardTable", MapsKt.mapOf(pairArray));
        Intrinsics.checkNotNullExpressionValue(string, "soyTemplateRenderer.rend\u2026h\n            )\n        )");
        return string;
    }

    private final void addAttributeToList(String attributeName, List<List<String>> targetList, ObjectEntry objectEntry) {
        if (Intrinsics.areEqual(attributeName, "Label")) {
            ObjectAttributeEntry attributeValueEntry = this.getLabelAttributeValue(objectEntry);
            targetList.add(this.getCellValuesList(attributeValueEntry));
        } else if (Intrinsics.areEqual(attributeName, "ObjectType")) {
            targetList.add(CollectionsKt.listOf(objectEntry.getObjectType().getName()));
        } else {
            Object v1;
            block7: {
                Iterable $this$firstOrNull$iv = objectEntry.getAttributes();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ObjectAttributeEntry it = (ObjectAttributeEntry)element$iv;
                    boolean bl = false;
                    boolean bl2 = Intrinsics.areEqual(it.getObjectTypeAttribute().getName(), attributeName) || Intrinsics.areEqual(String.valueOf(it.getObjectTypeAttributeId()), attributeName);
                    if (!bl2) continue;
                    v1 = element$iv;
                    break block7;
                }
                v1 = null;
            }
            ObjectAttributeEntry attributeValueEntry = v1;
            if (attributeValueEntry != null) {
                targetList.add(this.getCellValuesList(attributeValueEntry));
            } else {
                targetList.add(CollectionsKt.emptyList());
            }
        }
    }

    private final String renderSingleView(ObjectEntry objectEntry, List<String> tableHeaders) {
        Map objectData = new LinkedHashMap();
        for (String attribute : tableHeaders) {
            Object v0;
            ObjectAttributeEntry attributeValueEntry;
            block5: {
                if (Intrinsics.areEqual(attribute, "Label")) {
                    attributeValueEntry = this.getLabelAttributeValue(objectEntry);
                    objectData.put(attribute, this.getCellValuesList(attributeValueEntry));
                    continue;
                }
                if (Intrinsics.areEqual(attribute, "ObjectType")) {
                    objectData.put(attribute, CollectionsKt.listOf(objectEntry.getObjectType().getName()));
                    continue;
                }
                Iterable $this$firstOrNull$iv = objectEntry.getAttributes();
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    ObjectAttributeEntry it = (ObjectAttributeEntry)element$iv;
                    boolean bl = false;
                    if (!(Intrinsics.areEqual(it.getObjectTypeAttribute().getName(), attribute) || Intrinsics.areEqual(String.valueOf(it.getObjectTypeAttributeId()), attribute))) continue;
                    v0 = element$iv;
                    break block5;
                }
                v0 = null;
            }
            attributeValueEntry = v0;
            if (attributeValueEntry != null) {
                objectData.put(attribute, this.getCellValuesList(attributeValueEntry));
                continue;
            }
            objectData.put(attribute, CollectionsKt.emptyList());
        }
        String string = this.soyTemplateRenderer.render("com.riadalabs.confluence.plugins.insight-confluence:export-soy", "confluence.plugins.insight.export.singleView", MapsKt.mapOf(TuplesKt.to("objectData", objectData)));
        Intrinsics.checkNotNullExpressionValue(string, "soyTemplateRenderer.rend\u2026 to objectData)\n        )");
        return string;
    }

    private final ObjectAttributeEntry getLabelAttributeValue(ObjectEntry objectEntry) {
        Object element$iv2;
        block1: {
            Iterable $this$first$iv = objectEntry.getAttributes();
            boolean $i$f$first = false;
            for (Object element$iv2 : $this$first$iv) {
                ObjectAttributeEntry it = (ObjectAttributeEntry)element$iv2;
                boolean bl = false;
                if (!it.getObjectTypeAttribute().getLabel()) continue;
                break block1;
            }
            throw new NoSuchElementException("Collection contains no element matching the predicate.");
        }
        return (ObjectAttributeEntry)element$iv2;
    }

    private final List<String> getCellValuesList(ObjectAttributeEntry attributeValueEntry) {
        List cellValues = new ArrayList();
        SimpleDateFormat dateTimeFormatter = new SimpleDateFormat(this.formatSettingsManager.getDateTimeFormat());
        SimpleDateFormat dateFormatter = new SimpleDateFormat(this.formatSettingsManager.getDateFormat());
        for (ObjectAttributeValueEntry value : attributeValueEntry.getObjectAttributeValues()) {
            try {
                String formattedDate;
                if (value.getUser() != null) {
                    cellValues.add(value.getUser().getDisplayName());
                    continue;
                }
                if (value.getReferencedObject() != null) {
                    cellValues.add(value.getReferencedObject().getName());
                    continue;
                }
                if (value.getGroup() != null) {
                    cellValues.add(value.getGroup().getName());
                    continue;
                }
                if (value.getConfluencePage() != null) {
                    cellValues.add(value.getConfluencePage().getTitle());
                    continue;
                }
                if (value.getVersion() != null) {
                    cellValues.add(value.getVersion().getName());
                    continue;
                }
                if (value.getProject() != null) {
                    cellValues.add(value.getProject().getName());
                    continue;
                }
                if (value.getStatus() != null) {
                    cellValues.add(value.getStatus().getName());
                    continue;
                }
                if (value.getAdditionalValue() != null) {
                    cellValues.add(value.getAdditionalValue());
                    continue;
                }
                String string = attributeValueEntry.getObjectTypeAttribute().getDefaultType().getName();
                if (Intrinsics.areEqual(string, "DateTime")) {
                    formattedDate = dateTimeFormatter.format(Date.from(Instant.parse(value.getValue().toString())));
                    Intrinsics.checkNotNullExpressionValue(formattedDate, "formattedDate");
                    cellValues.add(formattedDate);
                    continue;
                }
                if (Intrinsics.areEqual(string, "Date")) {
                    formattedDate = dateFormatter.format(new SimpleDateFormat("yyyy-MM-dd").parse(value.getValue().toString()));
                    Intrinsics.checkNotNullExpressionValue(formattedDate, "formattedDate");
                    cellValues.add(formattedDate);
                    continue;
                }
                cellValues.add(value.getValue().toString());
            }
            catch (Throwable t) {
                this.logger.error((Object)("Could not populate attributeValueEntry id " + attributeValueEntry.getId()), t);
                cellValues.add("Error");
            }
        }
        return cellValues;
    }

    private final String fetch(String url) {
        String string = this.applicationLinkRequestClient.get(url, MapsKt.mapOf(TuplesKt.to("Content-Type", "application/json"))).getResponseBodyAsString();
        Intrinsics.checkNotNullExpressionValue(string, "applicationLinkRequestCl\u2026   ).responseBodyAsString");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final List<ObjectTypeAttributeEntry> fetchAssetsAttributes(String objectSchemaId, Set<String> attributesToDisplay) {
        void $this$filterTo$iv$iv;
        Type type2 = new TypeToken<List<? extends ObjectTypeAttributeEntry>>(){}.getType();
        String data = this.fetch("/rest/insight/1.0/objectschema/" + objectSchemaId + "/attributes");
        List attributes2 = (List)gson.fromJson(data, type2);
        Intrinsics.checkNotNullExpressionValue(attributes2, "attributes");
        Iterable $this$filter$iv = attributes2;
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ObjectTypeAttributeEntry it = (ObjectTypeAttributeEntry)element$iv$iv;
            boolean bl = false;
            if (!(attributesToDisplay.contains(String.valueOf(it.getId())) || attributesToDisplay.contains(it.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return (List)destination$iv$iv;
    }

    /*
     * WARNING - void declaration
     */
    private final ObjectListResultEntry fetchAssetsObjects(String objectSchemaId, String iql, String page, Set<String> attributesToDisplay) {
        void $this$filterTo$iv$iv;
        void $this$filter$iv;
        String data = this.fetch("/rest/insight/1.0/iql/objects?objectSchemaId=" + objectSchemaId + "&iql=" + URLEncoder.encode(iql, "UTF-8") + "&resultPerPage=100&page=" + page + "&extended=true&includeAttributesDeep=3");
        ObjectListResultEntry objects = (ObjectListResultEntry)gson.fromJson(data, ObjectListResultEntry.class);
        Iterable iterable = objects.getObjectTypeAttributes();
        ObjectListResultEntry objectListResultEntry = objects;
        boolean $i$f$filter = false;
        Iterator iterator2 = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            ObjectTypeAttributeEntry it = (ObjectTypeAttributeEntry)element$iv$iv;
            boolean bl = false;
            if (!(attributesToDisplay.contains(String.valueOf(it.getId())) || attributesToDisplay.contains(it.getName()))) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        objectListResultEntry.setObjectTypeAttributes((List)destination$iv$iv);
        Iterable $this$forEach$iv = objects.getObjectEntries();
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            void $this$filterTo$iv$iv2;
            void $this$filter$iv2;
            Object element$iv$iv;
            ObjectEntry objectEntry = (ObjectEntry)element$iv;
            boolean bl = false;
            element$iv$iv = objectEntry.getAttributes();
            ObjectEntry objectEntry2 = objectEntry;
            boolean $i$f$filter2 = false;
            void var16_19 = $this$filter$iv2;
            Collection destination$iv$iv2 = new ArrayList();
            boolean $i$f$filterTo2 = false;
            for (Object element$iv$iv2 : $this$filterTo$iv$iv2) {
                ObjectAttributeEntry it = (ObjectAttributeEntry)element$iv$iv2;
                boolean bl2 = false;
                boolean bl3 = attributesToDisplay.contains(String.valueOf(it.getObjectTypeAttributeId())) || attributesToDisplay.contains(it.getObjectTypeAttribute().getName());
                if (!bl3) continue;
                destination$iv$iv2.add(element$iv$iv2);
            }
            objectEntry2.setAttributes((List)destination$iv$iv2);
        }
        Intrinsics.checkNotNullExpressionValue(objects, "objects");
        return objects;
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> mapAttributesToDisplay(String attributesToDisplay) {
        void $this$mapTo$iv$iv;
        String[] stringArray = new String[]{","};
        Iterable $this$map$iv = StringsKt.split$default((CharSequence)attributesToDisplay, stringArray, false, 0, 6, null);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            String string = (String)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            String[] stringArray2 = new String[]{"-"};
            collection.add((String)CollectionsKt.first(StringsKt.split$default((CharSequence)it, stringArray2, false, 0, 6, null)));
        }
        return CollectionsKt.toSet((Iterable)CollectionsKt.plus((Collection)((List)destination$iv$iv), NAME_ATTRIBUTE));
    }

    static {
        Gson gson = new GsonBuilder().disableHtmlEscaping().create();
        Intrinsics.checkNotNull(gson);
        ExportRenderer.gson = gson;
        StringBuilder stringBuilder = new StringBuilder();
        URL uRL = ClassLoaderUtils.getResource((String)"css/common.css", ExportRenderer.class);
        Intrinsics.checkNotNullExpressionValue(uRL, "getResource(\"css/common.\u2026portRenderer::class.java)");
        URL uRL2 = uRL;
        Charset charset = Charsets.UTF_8;
        byte[] byArray = TextStreamsKt.readBytes(uRL2);
        StringBuilder stringBuilder2 = stringBuilder.append(new String(byArray, charset));
        URL uRL3 = ClassLoaderUtils.getResource((String)"css/macro-view.css", ExportRenderer.class);
        Intrinsics.checkNotNullExpressionValue(uRL3, "getResource(\"css/macro-v\u2026portRenderer::class.java)");
        uRL2 = uRL3;
        charset = Charsets.UTF_8;
        byArray = TextStreamsKt.readBytes(uRL2);
        StringBuilder stringBuilder3 = stringBuilder2.append(new String(byArray, charset));
        URL uRL4 = ClassLoaderUtils.getResource((String)"css/export.css", ExportRenderer.class);
        Intrinsics.checkNotNullExpressionValue(uRL4, "getResource(\"css/export.\u2026portRenderer::class.java)");
        uRL2 = uRL4;
        charset = Charsets.UTF_8;
        byArray = TextStreamsKt.readBytes(uRL2);
        styles = stringBuilder3.append(new String(byArray, charset)).toString();
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\t\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/mindville/confluence/plugins/insight/export/ExportRenderer$Companion;", "", "()V", "NAME_ATTRIBUTE", "", "gson", "Lcom/google/gson/Gson;", "getGson", "()Lcom/google/gson/Gson;", "styles", "getStyles", "()Ljava/lang/String;", "insight-confluence"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Gson getGson() {
            return gson;
        }

        @NotNull
        public final String getStyles() {
            return styles;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

