/*
 * Decompiled with CFR 0.152.
 */
package com.mindville.confluence.plugins.insight.api;

import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import javax.inject.Inject;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Path(value="/configuration")
@Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u0000 \u00102\u00020\u0001:\u0002\u0010\u0011B\u001f\b\u0007\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\u0013\u0010\t\u001a\u00020\n2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0087\u0002J\u001a\u0010\r\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\u000f2\b\b\u0001\u0010\u000b\u001a\u00020\fH\u0007R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/mindville/confluence/plugins/insight/api/ConfigurationResource;", "", "userManager", "Lcom/atlassian/sal/api/user/UserManager;", "pluginSettingsFactory", "Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;", "transactionTemplate", "Lcom/atlassian/sal/api/transaction/TransactionTemplate;", "(Lcom/atlassian/sal/api/user/UserManager;Lcom/atlassian/sal/api/pluginsettings/PluginSettingsFactory;Lcom/atlassian/sal/api/transaction/TransactionTemplate;)V", "get", "Ljavax/ws/rs/core/Response;", "request", "Ljavax/servlet/http/HttpServletRequest;", "put", "config", "Lcom/mindville/confluence/plugins/insight/api/ConfigurationResource$Config;", "Companion", "Config", "insight-confluence"})
public final class ConfigurationResource {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final UserManager userManager;
    @NotNull
    private final PluginSettingsFactory pluginSettingsFactory;
    @NotNull
    private final TransactionTemplate transactionTemplate;
    @NotNull
    private static final String SETTING_NAMESPACE = "com.mindville.confluence.plugins.insight:";

    @Inject
    public ConfigurationResource(@NotNull UserManager userManager, @NotNull PluginSettingsFactory pluginSettingsFactory, @NotNull TransactionTemplate transactionTemplate) {
        Intrinsics.checkNotNullParameter(userManager, "userManager");
        Intrinsics.checkNotNullParameter(pluginSettingsFactory, "pluginSettingsFactory");
        Intrinsics.checkNotNullParameter(transactionTemplate, "transactionTemplate");
        this.userManager = userManager;
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.transactionTemplate = transactionTemplate;
    }

    @GET
    @Produces(value={"application/json"})
    @NotNull
    public final Response get(@Context @NotNull HttpServletRequest request) {
        Response response;
        Intrinsics.checkNotNullParameter(request, "request");
        UserProfile userProfile = this.userManager.getRemoteUser(request);
        Intrinsics.checkNotNull(userProfile);
        UserKey userKey = userProfile.getUserKey();
        if (userKey == null || !this.userManager.isSystemAdmin(userKey)) {
            Response response2 = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            response = response2;
            Intrinsics.checkNotNullExpressionValue(response2, "{\n            Response.s\u2026ORIZED).build()\n        }");
        } else {
            Response response3 = Response.ok((Object)this.transactionTemplate.execute(() -> ConfigurationResource.get$lambda$0(this))).build();
            response = response3;
            Intrinsics.checkNotNullExpressionValue(response3, "ok(transactionTemplate.e\u2026config\n        }).build()");
        }
        return response;
    }

    @PUT
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @NotNull
    public final Response put(@NotNull Config config, @Context @NotNull HttpServletRequest request) {
        Intrinsics.checkNotNullParameter(config, "config");
        Intrinsics.checkNotNullParameter(request, "request");
        UserProfile userProfile = this.userManager.getRemoteUser(request);
        Intrinsics.checkNotNull(userProfile);
        UserKey userKey = userProfile.getUserKey();
        if (userKey == null || !this.userManager.isSystemAdmin(userKey)) {
            Response response = Response.status((Response.Status)Response.Status.UNAUTHORIZED).build();
            Intrinsics.checkNotNullExpressionValue(response, "status(Response.Status.UNAUTHORIZED).build()");
            return response;
        }
        this.transactionTemplate.execute(() -> ConfigurationResource.put$lambda$1(this, config));
        Response response = Response.noContent().build();
        Intrinsics.checkNotNullExpressionValue(response, "noContent().build()");
        return response;
    }

    private static final Config get$lambda$0(ConfigurationResource this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        PluginSettings pluginSettings = this$0.pluginSettingsFactory.createSettingsForKey(SETTING_NAMESPACE);
        Config config = new Config();
        config.setJiraApplicationLinkId((String)pluginSettings.get("jiraApplicationLinkId"));
        return config;
    }

    private static final Object put$lambda$1(ConfigurationResource this$0, Config $config) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter($config, "$config");
        PluginSettings pluginSettings = this$0.pluginSettingsFactory.createSettingsForKey(SETTING_NAMESPACE);
        pluginSettings.put("jiraApplicationLinkId", (Object)$config.getJiraApplicationLinkId());
        return null;
    }

    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Lcom/mindville/confluence/plugins/insight/api/ConfigurationResource$Companion;", "", "()V", "SETTING_NAMESPACE", "", "insight-confluence"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @XmlRootElement
    @XmlAccessorType(value=XmlAccessType.FIELD)
    @Metadata(mv={1, 8, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002R \u0010\u0003\u001a\u0004\u0018\u00010\u00048\u0006@\u0006X\u0087\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0005\u0010\u0006\"\u0004\b\u0007\u0010\b\u00a8\u0006\t"}, d2={"Lcom/mindville/confluence/plugins/insight/api/ConfigurationResource$Config;", "", "()V", "jiraApplicationLinkId", "", "getJiraApplicationLinkId", "()Ljava/lang/String;", "setJiraApplicationLinkId", "(Ljava/lang/String;)V", "insight-confluence"})
    public static final class Config {
        @XmlElement
        @Nullable
        private String jiraApplicationLinkId;

        @Nullable
        public final String getJiraApplicationLinkId() {
            return this.jiraApplicationLinkId;
        }

        public final void setJiraApplicationLinkId(@Nullable String string) {
            this.jiraApplicationLinkId = string;
        }
    }
}

