/*
 * Decompiled with CFR 0.152.
 */
package com.releaseteam.plugins.confluence.macros.impl;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.nodes.Node;
import org.jsoup.nodes.TextNode;
import org.jsoup.select.Elements;

public class AdvancedTableFormatMacroUtilities {
    public String getMapValue(String key, String defaultValue, Map<String, String> map) {
        String value = defaultValue;
        if (map.get(key) != null && !map.get(key).trim().equals("")) {
            value = map.get(key);
        }
        return value;
    }

    public String formatTable(String body, String backgroundColor, String formatAsCurrency, String dateFormatStr) {
        boolean styleIt;
        String result = "";
        boolean startsWithParagraph = body.startsWith("<p") || body.startsWith("<P");
        boolean bl = styleIt = backgroundColor != null && !"".equals(backgroundColor.trim());
        if (styleIt) {
            if (startsWithParagraph) {
                result = result + "<div";
                if (!"".equals(backgroundColor)) {
                    String backgroundColorStyle = " background: " + backgroundColor + "; ";
                    result = result + " style=\"" + backgroundColorStyle + "\" ";
                }
            } else {
                result = result + "<div style=\"";
                if (!"".equals(backgroundColor)) {
                    result = result + " background: " + backgroundColor + "; ";
                }
                result = result + "\"";
            }
            result = result + ">" + body + "</div>";
        } else {
            result = body;
        }
        String html = result;
        Document doc = Jsoup.parse((String)html);
        Elements elems = doc.getAllElements();
        for (Element elem : elems) {
            this.getFormattedCell(elem, formatAsCurrency, dateFormatStr);
        }
        Elements elems2 = doc.getAllElements();
        Element styleElement = null;
        for (Element elem2 : elems2) {
            String tagName2 = elem2.tagName();
            if (!"style".equalsIgnoreCase(tagName2)) continue;
            styleElement = elem2;
        }
        elems2 = doc.getAllElements();
        boolean foundBody = false;
        Element theNewElement = null;
        for (Element elem2 : elems2) {
            if (foundBody) {
                theNewElement = elem2;
                break;
            }
            String tagName2 = elem2.tagName();
            if (!"body".equalsIgnoreCase(tagName2)) continue;
            foundBody = true;
        }
        String styleGeneratedHtml = styleElement != null ? styleElement.toString() : "";
        String theNewElementGeneratedHtml = theNewElement != null ? theNewElement.toString() : html;
        result = styleGeneratedHtml + theNewElementGeneratedHtml;
        return result;
    }

    public String formatCell(String body, String backgroundColor, String formatAsCurrency, String dateFormatStr) {
        boolean startsWithParagraph = body.startsWith("<p") || body.startsWith("<P");
        String result = this.setBackgroundCell(backgroundColor, startsWithParagraph, body);
        Document doc = Jsoup.parse((String)result);
        Elements elems = doc.getAllElements();
        for (Element elem : elems) {
            this.getFormattedCell(elem, formatAsCurrency, dateFormatStr);
        }
        Elements elems2 = doc.getAllElements();
        boolean foundBody = false;
        Element theNewElement = null;
        String holdText = null;
        for (Element elem2 : elems2) {
            if (foundBody) {
                theNewElement = elem2;
                break;
            }
            String tagName2 = elem2.tagName();
            String text2 = elem2.text();
            if (!"body".equalsIgnoreCase(tagName2)) continue;
            foundBody = true;
            holdText = text2;
        }
        String string = result = theNewElement == null ? holdText : theNewElement.toString();
        if (result == null) {
            result = body;
        }
        result = this.setBackgroundCell(backgroundColor, startsWithParagraph, result);
        return result;
    }

    private String setBackgroundCell(String backgroundColor, boolean startsWithParagraph, String text) {
        boolean styleIt;
        boolean bl = styleIt = backgroundColor != null && !"".equals(backgroundColor.trim());
        if (!styleIt) {
            return text;
        }
        String result = "";
        if (startsWithParagraph) {
            result = result + "<div";
            if (!"".equals(backgroundColor)) {
                String backgroundColorStyle = " background: " + backgroundColor + "; ";
                result = result + " style=\"" + backgroundColorStyle + "\" ";
            }
        } else {
            result = result + "<div style=\"";
            if (!"".equals(backgroundColor)) {
                result = result + " background: " + backgroundColor + "; ";
            }
            result = result + "\"";
        }
        result = result + ">" + text + "</div>";
        return result;
    }

    private void getFormattedCell(Element elem, String formatAsCurrency, String dateFormatStr) {
        String tagName = elem.tagName().toLowerCase();
        List<String> allowTags = Arrays.asList("td", "p");
        if (!allowTags.contains(tagName)) {
            return;
        }
        Stack stackChildNodes = new Stack();
        stackChildNodes.addAll(elem.childNodes());
        while (!stackChildNodes.isEmpty()) {
            Node node = (Node)stackChildNodes.pop();
            String nodeName = node.nodeName();
            if (!nodeName.equals("#text")) {
                stackChildNodes.addAll(node.childNodes());
                continue;
            }
            TextNode textNode = (TextNode)node;
            String text = textNode.outerHtml();
            String textFormatted = this.getFormattedAll(text, formatAsCurrency, dateFormatStr);
            textNode.text(textFormatted);
        }
    }

    private String getFormattedAll(String text, String formatAsCurrency, String dateFormatStr) {
        String textFormatted = text;
        textFormatted = textFormatted.replaceAll("&nbsp;", " ");
        if ("true".equalsIgnoreCase(formatAsCurrency)) {
            textFormatted = this.getFormattedAsCurrency(textFormatted);
        }
        if (!"".equalsIgnoreCase(dateFormatStr.trim())) {
            textFormatted = this.getFormattedAsDate(textFormatted, dateFormatStr);
        }
        return textFormatted;
    }

    public String getFormattedAsCurrency(String s) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return s;
        }
        String[] arr = s.split(" ", -1);
        if (arr.length == 0) {
            return s;
        }
        List results = Arrays.stream(arr).map(item -> {
            try {
                double number = Double.parseDouble(item);
                NumberFormat formatter = NumberFormat.getCurrencyInstance();
                String moneyString = formatter.format(number);
                moneyString = moneyString.replace("USD ", "$");
                return moneyString;
            }
            catch (Throwable t) {
                return item;
            }
        }).collect(Collectors.toList());
        return String.join((CharSequence)" ", results);
    }

    public String getFormattedAsDate(String s, String outgoingDateFormatStr) {
        if (StringUtils.isBlank((CharSequence)s)) {
            return s;
        }
        String[] arr = s.split(" ", -1);
        if (arr.length == 0) {
            return s;
        }
        List results = Arrays.stream(arr).map(item -> {
            try {
                String incomingDateFormatStr = "MM/dd/yyyy";
                Date date = new SimpleDateFormat(incomingDateFormatStr).parse((String)item);
                SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(outgoingDateFormatStr);
                return DATE_FORMAT.format(date);
            }
            catch (Throwable t) {
                return item;
            }
        }).collect(Collectors.toList());
        return String.join((CharSequence)" ", results);
    }
}

