/*
 * Decompiled with CFR 0.152.
 */
package com.releaseteam.plugins.confluence.macros.impl;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.releaseteam.plugins.confluence.macros.impl.AdvancedTableFormatMacroUtilities;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class AdvancedTableFormatMacro
implements Macro {
    private PageBuilderService pageBuilderService;
    private AdvancedTableFormatMacroUtilities utils = new AdvancedTableFormatMacroUtilities();
    private String styleTemplate = "\n#$id table { \n  border-collapse: collapse; \n  width: $tableWidth; \n}\n\n#$id th { \n  height: $headerHeight; \n  padding: $headerPadding; \n  border: $headerBorderThickness solid $headerBorderColor;\n}\n\n#$id td { \n  height: $cellHeight; \n  padding: $cellPadding; \n  vertical-align: bottom; \n  border: $cellBorderThickness solid $cellBorderColor;\n}\n\n#$id tr:nth-child(even){background-color: $rowBackgroundColorEven;}\n#$id tr:nth-child(odd){background-color: $rowBackgroundColorOdd;}\n#$id tr:hover {background-color: $rowBackgroundColorHover;}\n#$id div {width: 100%; height: 100%;}\n\n";

    @Autowired
    public AdvancedTableFormatMacro(@ComponentImport PageBuilderService pageBuilderService) {
        this.pageBuilderService = pageBuilderService;
    }

    public String execute(Map<String, String> map, String body, ConversionContext conversionContext) throws MacroExecutionException {
        String str = "com.releaseteam.plugins.confluence.macros:macros-resources";
        this.pageBuilderService.assembler().resources().requireWebResource(str);
        String id = this.utils.getMapValue("ID", "advTblFmtID0001", map);
        String tableWidth = this.utils.getMapValue("TableWidth", "100%", map);
        String formatAsCurrency = this.utils.getMapValue("FormatAsCurrency", "false", map);
        String dateFormatStr = this.utils.getMapValue("DateFormatStr", "dd-MM-yyyy", map);
        String headerHeight = this.utils.getMapValue("HeaderHeight", "1px", map);
        String headerPadding = this.utils.getMapValue("HeaderPadding", "1px", map);
        String headerBorderThickness = this.utils.getMapValue("HeaderBorderThickness", "1px", map);
        String headerBorderColor = this.utils.getMapValue("HeaderBorderColor", "Black", map);
        String cellHeight = this.utils.getMapValue("CellHeight", "1px", map);
        String cellPadding = this.utils.getMapValue("CellPadding", "1px", map);
        String cellBorderThickness = this.utils.getMapValue("CellBorderThickness", "1px", map);
        String cellBorderColor = this.utils.getMapValue("CellBorderColor", "Black", map);
        String rowBackgroundColorEven = this.utils.getMapValue("RowBackgroundColorEven", "Khaki", map);
        String rowBackgroundColorOdd = this.utils.getMapValue("RowBackgroundColorOdd", "SkyBlue", map);
        String rowBackgroundColorHover = this.utils.getMapValue("RowBackgroundColorHover", "Grey", map);
        String template = "<style>\n" + this.styleTemplate + "</style>\n\n<div id=\"$id\">\n$body\n</div>";
        String result = template.replaceAll("\\$id", id);
        result = result.replaceAll("\\$tableWidth", tableWidth);
        result = result.replaceAll("\\$headerHeight", headerHeight);
        result = result.replaceAll("\\$headerPadding", headerPadding);
        result = result.replaceAll("\\$headerBorderThickness", headerBorderThickness);
        result = result.replaceAll("\\$headerBorderColor", headerBorderColor);
        result = result.replaceAll("\\$cellHeight", cellHeight);
        result = result.replaceAll("\\$cellPadding", cellPadding);
        result = result.replaceAll("\\$cellBorderThickness", cellBorderThickness);
        result = result.replaceAll("\\$cellBorderColor", cellBorderColor);
        result = result.replaceAll("\\$rowBackgroundColorEven", rowBackgroundColorEven);
        result = result.replaceAll("\\$rowBackgroundColorOdd", rowBackgroundColorOdd);
        result = result.replaceAll("\\$rowBackgroundColorHover", rowBackgroundColorHover);
        body = body.replaceAll("\\$", "__DOLLARSIGN__");
        result = result.replaceAll("\\$body", body);
        result = result.replaceAll("__DOLLARSIGN__", "\\$");
        result = this.utils.formatTable(result, null, formatAsCurrency, dateFormatStr);
        return result;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

