/*
 * Decompiled with CFR 0.152.
 */
package com.releaseteam.plugins.confluence.macros.impl;

import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.Currency;
import java.util.Date;
import java.util.Locale;
import java.util.Map;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.parser.Tag;
import org.jsoup.select.Elements;

public class AdvancedTableFormatMacroUtilities {
    public String getMapValue(String key, String defaultValue, Map<String, String> map) {
        String value = defaultValue;
        if (map.get(key) != null && !map.get(key).trim().equals("")) {
            value = map.get(key);
        }
        return value;
    }

    public String formatTable(String body, String backgroundColor, String formatAsCurrency, String dateFormatStr) {
        boolean styleIt;
        String result = "";
        boolean startsWithParagraph = body.startsWith("<p") || body.startsWith("<P");
        boolean bl = styleIt = backgroundColor != null && !"".equals(backgroundColor.trim());
        if (styleIt) {
            if (startsWithParagraph) {
                result = result + "<div";
                String backgroundColorStyle = "";
                if (backgroundColor != null && !"".equals(backgroundColor)) {
                    backgroundColorStyle = " background: " + backgroundColor + "; ";
                    result = result + " style=\"" + backgroundColorStyle + "\" ";
                }
                result = result + ">" + body + "</div>";
            } else {
                result = result + "<div style=\"";
                if (backgroundColor != null && !"".equals(backgroundColor)) {
                    result = result + " background: " + backgroundColor + "; ";
                }
                result = result + "\"";
                result = result + ">" + body + "</div>";
            }
        } else {
            result = body;
        }
        String html = result;
        Document doc = Jsoup.parse((String)html);
        String htmlFromJsoupDoc = doc.toString();
        Elements elems = doc.getAllElements();
        for (Element elem : elems) {
            String elemText2;
            String elemText;
            String val = elem.val();
            Tag tag = elem.tag();
            String tagName = elem.tagName();
            String text = elem.text();
            boolean ignoreTag = "#root".equalsIgnoreCase(tagName) || "html".equalsIgnoreCase(tagName) || "head".equalsIgnoreCase(tagName) || "style".equalsIgnoreCase(tagName) || "body".equalsIgnoreCase(tagName);
            if (ignoreTag || elem.select(tagName + " > *") == null || elem.select(tagName + " > *").size() != 0) continue;
            if ("true".equalsIgnoreCase(formatAsCurrency)) {
                elemText = elem.text();
                elemText2 = this.getFormattedAsCurrency(elemText);
                elem.text(elemText2);
            }
            if ("".equalsIgnoreCase(dateFormatStr.trim())) continue;
            elemText = elem.text();
            elemText2 = this.getFormattedAsDate(elemText, dateFormatStr);
            elem.text(elemText2);
        }
        Elements elems2 = doc.getAllElements();
        boolean foundStyle = false;
        Element styleElement = null;
        for (Element elem2 : elems2) {
            String val2 = elem2.val();
            Tag tag2 = elem2.tag();
            String tagName2 = elem2.tagName();
            String text2 = elem2.text();
            if (!"style".equalsIgnoreCase(tagName2)) continue;
            foundStyle = true;
            styleElement = elem2;
        }
        elems2 = doc.getAllElements();
        boolean foundBody = false;
        Element theNewElement = null;
        for (Element elem2 : elems2) {
            if (foundBody) {
                theNewElement = elem2;
                break;
            }
            String val2 = elem2.val();
            Tag tag2 = elem2.tag();
            String tagName2 = elem2.tagName();
            String text2 = elem2.text();
            if (!"body".equalsIgnoreCase(tagName2)) continue;
            foundBody = true;
        }
        String styleGeneratedHtml = styleElement != null ? styleElement.toString() : "";
        String theNewElementGeneratedHtml = theNewElement != null ? theNewElement.toString() : html;
        result = styleGeneratedHtml + theNewElementGeneratedHtml;
        return result;
    }

    public String formatCell(String body, String backgroundColor, String formatAsCurrency, String dateFormatStr) {
        boolean styleIt;
        String result = "";
        boolean startsWithParagraph = body.startsWith("<p") || body.startsWith("<P");
        boolean bl = styleIt = backgroundColor != null && !"".equals(backgroundColor.trim());
        if (styleIt) {
            if (startsWithParagraph) {
                result = result + "<div";
                String backgroundColorStyle = "";
                if (backgroundColor != null && !"".equals(backgroundColor)) {
                    backgroundColorStyle = " background: " + backgroundColor + "; ";
                    result = result + " style=\"" + backgroundColorStyle + "\" ";
                }
                result = result + ">" + body + "</div>";
            } else {
                result = result + "<div style=\"";
                if (backgroundColor != null && !"".equals(backgroundColor)) {
                    result = result + " background: " + backgroundColor + "; ";
                }
                result = result + "\"";
                result = result + ">" + body + "</div>";
            }
        } else {
            result = body;
        }
        Document doc = Jsoup.parse((String)result);
        String htmlFromJsoupDoc = doc.toString();
        Elements elems = doc.getAllElements();
        for (Element elem : elems) {
            String elemText2;
            String elemText;
            String val = elem.val();
            Tag tag = elem.tag();
            String tagName = elem.tagName();
            String text = elem.text();
            if (!"body".equalsIgnoreCase(tagName) && !"div".equalsIgnoreCase(tagName) && !"p".equalsIgnoreCase(tagName) && !"td".equalsIgnoreCase(tagName) || !elem.hasText()) continue;
            if ("true".equalsIgnoreCase(formatAsCurrency)) {
                elemText = elem.text();
                elemText2 = this.getFormattedAsCurrency(elemText);
                elem.text(elemText2);
            }
            if ("".equalsIgnoreCase(dateFormatStr.trim()) || "none".equalsIgnoreCase(dateFormatStr.trim())) continue;
            elemText = elem.text();
            elemText2 = this.getFormattedAsDate(elemText, dateFormatStr);
            elem.text(elemText2);
        }
        Elements elems2 = doc.getAllElements();
        boolean foundBody = false;
        Element theNewElement = null;
        String holdText = null;
        for (Element elem2 : elems2) {
            if (foundBody) {
                theNewElement = elem2;
                break;
            }
            String val2 = elem2.val();
            Tag tag2 = elem2.tag();
            String tagName2 = elem2.tagName();
            String text2 = elem2.text();
            if (!"body".equalsIgnoreCase(tagName2)) continue;
            foundBody = true;
            holdText = text2;
        }
        String string = result = theNewElement == null ? holdText : theNewElement.toString();
        if (result == null) {
            result = body;
        }
        return result;
    }

    public String getFormattedAsCurrency(String s) {
        String[] arr;
        String result = "";
        if (s != null && !"".equals(s.trim()) && (arr = s.split(" ")) != null && arr.length > 0) {
            for (int i = 0; i < arr.length; ++i) {
                try {
                    double number = Double.parseDouble(arr[i]);
                    NumberFormat formatter = NumberFormat.getCurrencyInstance();
                    Currency usd = Currency.getInstance(Locale.US);
                    String moneyString = formatter.format(number);
                    moneyString = moneyString.replace("USD ", "$");
                    if (result.length() > 0) {
                        result = result + " ";
                    }
                    result = result + moneyString;
                    continue;
                }
                catch (Throwable t) {
                    if (result.length() > 0) {
                        result = result + " ";
                    }
                    result = result + arr[i];
                }
            }
        }
        return result;
    }

    public String getFormattedAsDate(String s, String outgoingDateFormatStr) {
        String[] arr;
        String result = "";
        if (s != null && !"".equals(s.trim()) && (arr = s.split(" ")) != null && arr.length > 0) {
            for (int i = 0; i < arr.length; ++i) {
                try {
                    String incomingDateStr = arr[i];
                    String incomingDateFormatStr = "MM/dd/yyyy";
                    Date date = new SimpleDateFormat(incomingDateFormatStr).parse(incomingDateStr);
                    SimpleDateFormat DATE_FORMAT = new SimpleDateFormat(outgoingDateFormatStr);
                    String outgoingDateStr = DATE_FORMAT.format(date);
                    if (result.length() > 0) {
                        result = result + " ";
                    }
                    result = result + outgoingDateStr;
                    continue;
                }
                catch (Throwable t) {
                    if (result.length() > 0) {
                        result = result + " ";
                    }
                    result = result + arr[i];
                }
            }
        }
        return result;
    }
}

