/*
 * Decompiled with CFR 0.152.
 */
package com.releaseteam.plugins.confluence.macros.impl;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.releaseteam.plugins.confluence.macros.impl.AdvancedTableFormatMacroUtilities;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class AdvancedTableFormatCellMacro
implements Macro {
    private PageBuilderService pageBuilderService;
    private AdvancedTableFormatMacroUtilities utils = new AdvancedTableFormatMacroUtilities();

    @Autowired
    public AdvancedTableFormatCellMacro(@ComponentImport PageBuilderService pageBuilderService) {
        this.pageBuilderService = pageBuilderService;
    }

    public String execute(Map<String, String> map, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (body == null || "".equals(body)) {
            return body;
        }
        if (body.startsWith("<") && !body.startsWith("<p") && !body.startsWith("<P")) {
            System.err.println("Macro can only accept simple string or paragraph tag. Body: [" + body + "]");
            throw new MacroExecutionException("Macro can only accept simple string or paragraph tag.");
        }
        this.pageBuilderService.assembler().resources().requireWebResource("com.releaseteam.plugins.confluence.macros:macros-resources");
        String backgroundColor = this.utils.getMapValue("BackgroundColor", "", map);
        String formatAsCurrency = this.utils.getMapValue("FormatAsCurrency", "false", map);
        String dateFormatStr = this.utils.getMapValue("DateFormatStr", "dd-MM-yyyy", map);
        String result = this.utils.formatCell(body, backgroundColor, formatAsCurrency, dateFormatStr);
        return result;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.RICH_TEXT;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.INLINE;
    }
}

