AJS.$(document).ready(function() {
    AJS.$(document).ajaxComplete(function() {
      var head = AJS.$(document).find('head');
      var styleCSSPath = AJS.contextPath() + '/download/resources/com.practiproject.confluenceLanguageHebrew:confluenceLanguageHebrew-resources/common.css';
      head.append('<link id="style-css" type="text/css" href=' + styleCSSPath + ' rel="stylesheet" />');
        doRightAlign();
        var sideBar = AJS.$('.ia-fixed-sidebar');
        if (sideBar[0] && !sideBar.hasClass('collapsed')) {
          AJS.$('#main').addClass('active');
        }

        var macroStatus = AJS.$('.status-macro');
        if (macroStatus.length) {
          var macroStatusParent = macroStatus.parent();
          if (!macroStatusParent.hasClass('macro-alignment')) macroStatusParent.attr('dir', 'ltr');
        }

        var macroToc = AJS.$('.toc-macro');
        if (macroToc.length) {
          var macroTocParent = macroToc.parent();
          if (!macroTocParent.hasClass('macro-alignment')) macroTocParent.attr('dir', 'ltr');
          var macroTocPrev = macroToc[0].previousSibling;
          var $macroTocPrev = AJS.$(macroTocPrev);
          if ($macroTocPrev.hasClass('macro-alignment')) {
            macroToc.addClass('macro-alignment');
            macroToc.attr('dir', 'rtl');
          } else {
            macroToc.attr('dir', 'ltr');
          }
        }
    });

    subscribeDOMNodeEvents();
});

AJS.$(document).on('keydown', 'textarea, input', function(event) {
    if (event.keyCode === 0 || event.keyCode === 32 || event.keyCode === 8 || event.ctrlKey || event.altKey || event.shiftKey) {
        return;
    }
    var character = event.key;
    if (AJS.$(this).val() === "" || !containsLetterCharacter(AJS.$(this).val())) {
        if (isHebrewCharacter(character))
            makeRTL(AJS.$(this));
        else
            makeLTR(AJS.$(this));
    }
});
AJS.$(document).on('click', function (e) {
  var taskId = e.target.hasAttribute('data-inline-task-id') ? e.target.getAttribute('data-inline-task-id') : null;
  if (taskId && e.target.getAttribute('dir') === 'rtl') {
    e.preventDefault();
    var task = AJS.$(e.target);
    var tasksContentId = task.parent().attr('data-inline-tasks-content-id');

    if (tasksContentId) {
      var postUrl = AJS.contextPath() + '/rest/inlinetasks/1/task/' + tasksContentId + '/' + taskId + '/';
      var status = task.hasClass('checked') ? 'UNCHECKED' : 'CHECKED';
      AJS.$.ajax({
        type: 'POST',
        url: postUrl,
        data: JSON.stringify({
          status: status,
          trigger: 'VIEW_PAGE'
        }),
        dataType : "json",
        contentType: "application/json; charset=utf-8",
        timeout: 30000,
        success: function() {
          task.toggleClass('checked');
        }
      });
    }
  }
});

AJS.$(document).on('click', '#description-val>.aui-iconfont-edit', function() {
    var text = AJS.$(this).closest('div').contents()[1].innerText;
    AJS.$('#descriptionmodule_heading').append('<div id="desc-dir" style="display: none"></div>');
    AJS.$('#desc-dir').text(text);
});

AJS.$(document).on('click', '.expand-collapse-trigger', function() {
    setTimeout(function () {
      AJS.$('#main').toggleClass('active');
    }, 100);
});

AJS.$(document).on('click', '#space-tools-menu-trigger', function() {
  setTimeout(function () {
    AJS.$('#space-tools-menu').addClass('active');
  }, 100);
});

AJS.$(document).on("focus", 'textarea, input', function() {
    var direction = AJS.$(this).attr('data-direction');
    if (direction === undefined) {
        var character =  AJS.$('#desc-dir').text().substring(0,1);
        for (var i = 0; i < AJS.$('#desc-dir').text().length; i++) {
            if (!isHebrewCharacter(character) && !isEnglishCharacter(character))
                character = AJS.$('#desc-dir').text().substring(i++, 1);
            else
                break;
        }
        if (isHebrewCharacter(character)){
            makeRTL(AJS.$(this));
        } else if (isEnglishCharacter(character)){
            makeLTR(AJS.$(this));
        }
    } else {
        if (direction === "right")
            makeRTL(AJS.$(this));
        else if (direction === "left")
            makeLTR(AJS.$(this));
    }
});

var containsLetterCharacter = function(text) {
    if (/[\u0590-\u05FF]/i.test(text) || /[a-zA-Z]/i.test(text))
        return true;
    else
        return false;
};

var isHebrewCharacter = function(character) {
    if (character.match(/[\u0590-\u05FF]/)) {
        return true;
    } else {
        return false;
    }
};

var isEnglishCharacter = function(character) {
    if (character.match(/^[a-zA-Z]*$/)) {
        return true;
    } else {
        return false;
    }
};

var makeRTL = function(element) {
    element.attr('dir', "rtl");
    element.attr('data-direction', 'right');
    element.css({
        "direction": 'rtl !important',
        "text-align" : "right"
    });
};

var makeLTR = function(element) {
    element.attr('dir', "ltr");
    element.attr('data-direction', 'left');
    element.css({
        "direction": 'ltr !important',
        "text-align" : "left !important"
    });
};

function getIsRTL(isRTL, text) {
  text = text.replace("\xEF\xBB\xBF", '');
  text = getFormattedText(text);
  if (text.charAt(0) && text !== '') {
    isRTL = isRTLLetter(text.charAt(0));
  }

  return isRTL;
}

function isRTLLetter(letter) {
  return letter.match(/[\u0590-\u05FF]/) !== null;
}

function getFormattedText(text) {
  return text.replace(/[^\u0591-\u07FF\uFB1D-\uFDFD\uFE70-\uFEFCA-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02B8\u0300-\u0590\u0800-\u1FFF'\u2C00-\uFB1C\uFDFE-\uFE6F\uFEFD-\uFFFF]+/g, '');
}

function getParagraph(node) {
  if (node.nodeName !== 'P' || node.nodeName !== 'LI' || node.nodeName !== 'TD' || node.nodeName !== 'TH') {
    node = node.parentNode;
    if (node.nodeName !== 'P' && node.nodeName !== 'LI' && node.nodeName !== 'TD' && node.nodeName !== 'TH') {
      while (node !== null && (node.nodeName !== 'P' && node.nodeName !== 'LI' && node.nodeName !== 'TD' && node.nodeName !== 'TH')) {
        node = node.parentNode;
      }
    }
  }

  return node;
}

var getAllTextElements = function() {
    var elements = AJS.$('body *').contents().filter(function() {
        return (this.nodeType == 3) && this.nodeValue.match(/\S/);
    });

    var text = [];
    var notHebrewText = [];
    AJS.$.each(elements, function() {
        var node = AJS.$(this)[0];
        var character =  AJS.$(this).text().substring(0,1);
        for (var i = 0; i < AJS.$(this).text().length; i++) {
            if (!(isHebrewCharacter(character) || isEnglishCharacter(character)))
                character = AJS.$(this).text().substring(i+1, 1);
            else
                break;
        }
        if (isHebrewCharacter(character)){
            text.push(AJS.$(this).parent());
        } else {
            // notHebrewText.push(AJS.$(this).parent());

          node = getParagraph(node);
          if (node && node.nodeName !== 'LI') {
            // isRTL = getIsRTL(isRTL, text);
            var txt = AJS.$(this).text();
            if (getIsRTL(null, txt)) {
              text.push(AJS.$(this).parent());
            } else {
              notHebrewText.push(AJS.$(this).parent());
            }
          } else {
            notHebrewText.push(AJS.$(this).parent());
          }
        }
    });

    AJS.$.each(notHebrewText, function() {
        var el = AJS.$(this);
        if (el.hasClass('confluence-userlink')) {
            el.parent().css({
                'direction': "ltr",
                'text-align': 'left !important'
            });
        }

        if (el.parent().hasClass('wiki-content')) {
            el.css({
              'direction': "ltr",
              'text-align': 'left !important'
            });
        }

        if (el[0].nodeName === 'LI') {
            var prevEl = el[0].previousSibling;
            var tmpDir = 'ltr';
            if (prevEl && prevEl.nodeName === 'LI') {
                tmpDir = prevEl.getAttribute('dir');
            }
            el.attr('dir', tmpDir);

            var ulEl = el.parent();
            if (ulEl[0].getAttribute('dir') === null) {
                ulEl.attr('dir', tmpDir);
                ulEl.css('text-align', tmpDir === 'ltr' ? 'left' : 'right');
            }
        } else if (el[0].nodeName === 'SPAN') {
          changeCheckboxesListAlignment(el, 'ltr');
        } else if (el[0].nodeName === 'P') {
          el.css({
            'direction': "ltr",
            'text-align': 'left !important'
          });
          el[0].style.direction = 'ltr';
          el[0].style.textAlign = 'left !important';
          el[0].style.cssText = 'text-align: right; direction: ltr;'
          el.addClass('text-left');
        } else if(el[0].nodeName === 'TH' || el[0].nodeName === 'TD') {
          el[0].style.direction = 'ltr';
          el[0].style.textAlign = 'left !important';
          el[0].style.cssText = 'text-align: right; direction: ltr;'
          el.addClass('text-left');
        }
    });

    text.reverse();
    return text;
};

var doRightAlign = function() {
    var elementsWithHebrew = getAllTextElements();
    AJS.$.each(elementsWithHebrew, function() {
        var element = AJS.$(this);

      if (element[0].nodeName === 'LI') {
        var prevEl = element[0].previousSibling;
        var tmpDir = 'rtl';
        if (prevEl && prevEl.nodeName === 'LI') {
          tmpDir = prevEl.getAttribute('dir');
        }
        element.attr('dir', tmpDir);

        var ulEl = element.parent();
        if (ulEl[0].getAttribute('dir') === null) {
          ulEl.attr('dir', tmpDir);
          ulEl.css('text-align', tmpDir === 'ltr' ? 'left' : 'right');
        }
      } else if (element[0].nodeName === 'SPAN') {
        changeCheckboxesListAlignment(element, 'rtl');
        var pNode = getParagraph(element[0]);
        var $pNode = AJS.$(pNode);
        if($pNode[0] && $pNode[0].nodeName === 'LI') {
          var prevEll = element[0].previousSibling;
          var tDir = 'rtl';
          if (prevEll && prevEll.nodeName === 'LI') {
            tDir = prevEll.getAttribute('dir');
          }
          element.attr('dir', tDir);

          var ulElement = element.parent();
          if (ulElement[0].getAttribute('dir') === null) {
            ulElement.attr('dir', tDir);
            ulElement.css('text-align', tDir === 'ltr' ? 'left' : 'right');
          }
        } else {
          $pNode.attr('dir', 'rtl');
          $pNode.css({
            'text-align': "right !important",
            'direction': "rtl !important"
          });
        }
      } else {
        element.attr('dir', 'rtl');
        element.css({
          'text-align': "right",
          'direction': "rtl"
        });
      }

        var parent = AJS.$(this).closest('div');
        if (parent.hasClass('action-body flooded')) {
            parent.css({
                'text-align': "right",
                'direction': "rtl"
            });
        }
        if (parent.hasClass('line')) {
          parent.css({
            'text-align': "right"
          });
        }
        var description = AJS.$(this).closest('div').parent();
        if (description.attr('id') === "description-val"){
            description.css({
                'float' : "right",
                'width' : "100%",
                'text-align': "right"
            });
        }
    });
};

var changeCheckboxesListAlignment = function (element, tmpDir) {
  var parentEl = element.parent();

  if (parentEl.attr('data-inline-task-id') !== undefined) {
    var prevEl = parentEl[0].previousSibling;

    if (prevEl && prevEl.nodeName === 'LI') {
      tmpDir = prevEl.getAttribute('dir');
    }

    parentEl.attr('dir', tmpDir);
    var ulEl = element.parent();

    if (ulEl[0].getAttribute('dir') === null) {
      var alignment = tmpDir === 'ltr' ? 'left' : 'right';

      ulEl.attr('dir', tmpDir);
      ulEl.css('text-align', alignment);
    }
  }
};

var subscribeDOMNodeEvents = function () {
  var el = null;

  AJS.$(document).bind("DOMNodeInserted",function(event){
    if (event.target.id == "property-panel") {
      setTimeout(function () {
        el = AJS.$(event.target)[0].outerHTML;
      }, 0);
    }
  });

  AJS.$(document).bind("DOMNodeRemoved",function(event){
    if (event.target.id == "property-panel" && el) {
      setTimeout(function() {
        AJS.$('#property-panel').remove();
      }, 0);

      setTimeout(function() {
        AJS.$('body').append(AJS.$(el));
        el = null;
      }, 10);
    }
  });
};