window.addEventListener("load", function () {
    var $fixedSidebar = $(".ia-splitter-left .ia-fixed-sidebar");
    var $splitterPanes = $(".ia-splitter").children();
    var $splitterHandle = $("div.ia-splitter-handle.tipsy-enabled");
    var $footer = $("#footer, #studio-footer");
    var $body = $("body");
    var $expandCollapseTrigger = $('.expand-collapse-trigger');

    var dragging = false;
    var moved = false;
    var minWidth = 50;
    var collapseWidth = 150;
    var minConfigureWidth = 285;
    var defaultWidth = minWidth;

    $.ajax({
        url: AJS.contextPath() + "/plugins/servlet/textDirectionServlet",
        async: false,
        cashed: false,
        type: "GET",
        dataType: "JSON",
        data: {
            action: "getUserLanguage"
        },
        success: function (resp) {
            if (resp.locale === "iw") {
                if (localStorage.sidebarWidth > collapseWidth) {
                    setPanesWidth(localStorage.sidebarWidth);
                } else {
                    setPanesWidth(minWidth);
                }

                initCollapse();
            }

            $(".ia-secondary-header-title.page-tree").on("click", pageTree);
            $("#space-tools-menu-trigger").on("click", spaceToolMenu);
        }
    });

    function spaceToolMenu(e) {
        if ($fixedSidebar.hasClass("collapsed")) {
            setTimeout(function () {
                $("#space-tools-menu").css({"right": "10px", "left": "auto"});
            }, 0);
        } else {
            setTimeout(function () {
                $("#space-tools-menu").css({"right": "7px"});
            }, 0);
        }
    }

    function pageTree(e) {
        setTimeout(function () {
            $("#inline-dialog-sidebar-page-tree-flyout").css({"right": (40) + "px", "left": "auto"});
        }, 100);
    }

    function initCollapse(e) {
        $splitterHandle.off("mousedown.ia-splitter");
        $splitterHandle.off("click");
        $expandCollapseTrigger.off("click");

        $splitterHandle.on("mousedown.ia-splitter", sidebarDrag);
        $splitterHandle.on("click", function () {
            if (!moved)
                toggle();
            else {
                moved = false;
            }
        });

        $("#space-tools-menu-trigger > span:nth-child(3)").remove();

        $splitterHandle.off("mouseover.ia-splitter", initCollapse);
    }

    function toggle() {
        var currentWidth = $fixedSidebar.width();

        if (currentWidth > minWidth) {
            if (currentWidth <= collapseWidth) {
                defaultWidth = minConfigureWidth;
                setPanesWidth(defaultWidth);
            } else {
                defaultWidth = currentWidth;
                setPanesWidth(minWidth);
            }
        } else {
            if (!localStorage.sidebarWidth || localStorage.sidebarWidth < minConfigureWidth) {
                localStorage.sidebarWidth = document.body.scrollWidth / 3;
            }

            setPanesWidth(localStorage.sidebarWidth);
        }
    }

    function sidebarDrag(e) {
        dragging = true;

        e.preventDefault();

        $splitterPanes.one("selectstart", function (e) {
            e.preventDefault();
        });

        var mouseupHandler = function () {
            if ($fixedSidebar.width() <= collapseWidth) {
                setPanesWidth(minWidth);
            } else {
                defaultWidth = $fixedSidebar.width();
            }

            dragging = false;

            $body.off("mousemove.ia-splitter");
        };

        moved = false;

        $body.on("mousemove.ia-splitter", function (e) {
            var x = document.body.scrollWidth - e.pageX;

            setPanesWidth(x);

            moved = true;
        });

        $body.one("mouseup mouseleave", mouseupHandler);
    }

    function setPanesWidth(width) {
        width = Math.max(width, minWidth);
        width = Math.min(width, document.body.scrollWidth / 2);

        try {
            localStorage.sidebarWidth = width;
        } catch (e) {
            // Local storage error, default is used
        }

        if (width <= collapseWidth) {
            $fixedSidebar.addClass('collapsed');
            $expandCollapseTrigger.removeClass('aui-iconfont-chevron-double-left').addClass('aui-iconfont-chevron-double-right');
            $splitterHandle.attr('data-tooltip', Confluence.Sidebar.expandTooltip);
            AJS.trigger('sidebar.collapsed');
        } else {
            if ($fixedSidebar.hasClass('collapsed')) {
                $fixedSidebar.removeClass('collapsed');
                $splitterHandle.attr('data-tooltip', Confluence.Sidebar.collapseTooltip);
                $expandCollapseTrigger.removeClass('aui-iconfont-chevron-double-right').addClass('aui-iconfont-chevron-double-left');
                AJS.trigger('sidebar.expanded');
            }
        }

        $fixedSidebar.width(width);
        $splitterPanes.eq(1).css("margin-right", width + "px");

        fixFooter();
    }

    function fixFooter() {
        $footer.css("margin-right", $fixedSidebar.outerWidth() + "px");
    }

    $expandCollapseTrigger.click(function (e) {
        e.preventDefault();

        toggle();
    });
});