AJS.Editor.Adapter.addTinyMcePluginInit(function (settings) {
    settings.plugins += ",directionality";
});

AJS.bind("init.rte", function () {
    AJS.$(document).ready(function () {

      $.ajax({
        url: AJS.contextPath() + '/plugins/servlet/textDirectionServlet',
        async: false,
        cashed: false,
        type: 'GET',
        dataType: 'JSON',
        data: {
          action: 'getUserLanguage'
        },
        success: function(resp){
          var iframeContents = AJS.$('iframe').contents();
          var body = iframeContents.find("body");
          var head = iframeContents.find("head");
          var editor = tinymce.activeEditor;

          var rtlCSSPath = AJS.contextPath() + '/download/resources/com.practiproject.confluenceLanguageHebrew:confluenceLanguageHebrew-resources/rtl.css';
          var styleCSSPath = AJS.contextPath() + '/download/resources/com.practiproject.confluenceLanguageHebrew:confluenceLanguageHebrew-resources/style.css';

          if (resp.locale === 'iw'){
            body.css("text-align", "right");
            body.attr("dir", "rtl");
          }
          body.attr("dir", "rtl");

          head.append('<link id="rtl-css" type="text/css" href='+ rtlCSSPath + ' rel="stylesheet" />');
          head.append('<link id="style-css" type="text/css" href=' + styleCSSPath + ' rel="stylesheet" />');

          AJS.$('.aui-toolbar2-primary').append('<ul class="aui-buttons"><li class="toolbar-item aui-button" id="macro-alignment"></li></ul>');

          if (body.attr('loaded') !== 'true') {
            subscribeEvents(editor, body, iframeContents);
          }
        }
      });
    });
});


tinymce.PluginManager.add('directionality', function (editor) {
    AJS.$(document).ready(function () {
        var iframeContents = AJS.$('iframe').contents();
        var body = iframeContents.find("body");
        body.attr('loaded', 'true');

        subscribeEvents(editor, body, iframeContents);
    });
});

var debounce = function (func, threshold, execAsap) {
  var timeout;
  return function debounced() {
    var obj = this, args = arguments;
    function delayed() {
      if (!execAsap)
        func.apply(obj, args);
      timeout = null;
    }
    if (timeout) {clearTimeout(timeout);
    } else if (execAsap) {func.apply(obj, args);}
    timeout = setTimeout(delayed, threshold || 100);
  };
};

var outdentClicked = false;
function subscribeEvents(editor, body, iframeDocument) {
    if (body.length) {
        changeConfUserLinksDirections();

        iframeDocument.ready(function () {
          setTimeout(function () {
            var nodes = body[0].children;
            for (var i = 0; i < nodes.length; i++) {
              var el = nodes[i];
              var $$el = AJS.$(el);
              var text = $$el.text();
              var isRTL = getIsRTL(isRTL, text);

              if (!isRTL) {
                $$el.attr('dir', "ltr");
              } else {
                $$el.attr('dir', "rtl");
              }

              if (el.nodeName === 'UL') {
                el.setAttribute('dir', isRTL ? 'rtl' : 'ltr');
                el.childNodes.forEach(function (liEl) {
                  liEl.setAttribute('dir', isRTL ? 'rtl' : 'ltr');
                })
              }
            }

            AJS.$('#macro-alignment').on('click', function (e) {
              var bodyEditor = AJS.$(editor.dom.doc.body);
              var isMacroAlignmentActive = false;

              var hiddenAlignmentStatusEl = bodyEditor.find('.alignment-macro-status');
              if (hiddenAlignmentStatusEl.length) {
                hiddenAlignmentStatusEl.toggleClass('active');
                isMacroAlignmentActive = hiddenAlignmentStatusEl.hasClass('active');
              } else {
                var hiddenAlignmentStatus = AJS.$('<span class="alignment-macro-status active" style="display: none">alignment-macro-status</span>');
                isMacroAlignmentActive = true;
                bodyEditor.append(hiddenAlignmentStatus)
              }

              var macroStatus = bodyEditor.find('[data-macro-name="status"]');
              if (macroStatus.length) {
                var macroStatusParent = macroStatus.parent();
                if (isMacroAlignmentActive) {
                  macroStatusParent.addClass('macro-alignment');
                  macroStatusParent.removeClass('macro-alignment-inactive');
                } else {
                  macroStatusParent.removeClass('macro-alignment');
                  macroStatusParent.addClass('macro-alignment-inactive');
                }
              }

              var macroToc = bodyEditor.find('[data-macro-name="toc"]');
              if (macroToc.length) {
                var macroTocParent = macroToc.parent();
                if (isMacroAlignmentActive) {
                  macroTocParent.addClass('macro-alignment');
                  macroTocParent.removeClass('macro-alignment-inactive');
                } else {
                  macroTocParent.removeClass('macro-alignment');
                  macroTocParent.addClass('macro-alignment-inactive');
                }
              }
            });

            doRightAlign(iframeDocument);
          }, 100);
        });

      AJS.$(iframeDocument).on("DOMNodeInserted",debounce(function(event){
        var targetEl = AJS.$(event.target);
        if (targetEl.hasClass('p1')) {
          setTimeout(function () {
            doRightAlign(iframeDocument);
          }, 0);
        }
      }));

        body.on('keypress', keyPressHandler);

        body.on('keyup', keyUpHandler);

        body.on('click', clickHandler);

        body.keydown(function(e) {
          if (e.keyCode === 86 && (e.ctrlKey === true || e.metaKey === true)) {
            keyPressHandler(e);
          }
        });

        var $outdentBtn = AJS.$('#rte-button-outdent');
        var $indentBtn = AJS.$('#rte-button-indent');

        $outdentBtn.on('click', function () {
          var blocks = editor.selection.getSelectedBlocks();
          if (blocks[0].getAttribute('dir') === 'rtl') {
            if (!outdentClicked ) {
              outdentClicked = true;
              $outdentBtn.trigger('click');
            } else {
              outdentClicked = false;

              setTimeout(function () {
                editor.selection.getSelectedBlocks().forEach(function (block) {
                  var marginRightPX = block.style.marginRight.replace('px', '');
                  var value = parseInt(marginRightPX);
                  if (value) {
                    var rightValue = (value - 30) > 0 ? value - 30 : 0;
                    block.style.marginRight = rightValue + 'px';
                  }
                  block.style.textAlign = 'right';
                });
                editor.nodeChanged();
              }, 0);
            }
          }
        });

        $indentBtn.on('click', function () {
          var blocks = editor.selection.getSelectedBlocks();
          if (blocks[0].getAttribute('dir') === 'rtl') {
            setTimeout(function () {
              editor.selection.getSelectedBlocks().forEach(function (block) {
                var rightPX = block.style.marginLeft;
                block.style.marginRight = rightPX;
                // block.style.marginLeft = '0 px';
              });
              editor.nodeChanged();
            }, 0);
          }
        });

      var doRightAlign = function(iframeDocument) {
        var elementsWithHebrew = getAllTextElements(iframeDocument);
        AJS.$.each(elementsWithHebrew, function() {
          var element = AJS.$(this);

          if (element[0].nodeName === 'LI') {
            var prevEl = element[0].previousSibling;
            var tmpDir = 'rtl';
            if (prevEl && prevEl.nodeName === 'LI') {
              tmpDir = prevEl.getAttribute('dir');
            }
            element.attr('dir', tmpDir);

            var ulEl = element.parent();
            if (ulEl[0].getAttribute('dir') === null) {
              ulEl.attr('dir', tmpDir);
              ulEl.css('text-align', tmpDir === 'ltr' ? 'left' : 'right');
            }
          } else if (element[0].nodeName === 'SPAN') {
            var pNode = getParagraph(element[0]);
            changeCheckboxesListAlignment(element, 'rtl');
            AJS.$(pNode).attr('dir', 'rtl');
            AJS.$(pNode).css({
              'text-align': "right !important",
              'direction': "rtl !important"
            });
          } else {
            element.attr('dir', 'rtl');
            element.css({
              'text-align': "right !important",
              'direction': "rtl !important"
            });
          }

          var parent = AJS.$(this).closest('div');
          if (parent.hasClass('action-body flooded')) {
            parent.css({
              'text-align': "right",
              'direction': "rtl"
            });
          }
          if (parent.hasClass('line')) {
            parent.css({
              'text-align': "right"
            });
          }
          var description = AJS.$(this).closest('div').parent();
          if (description.attr('id') === "description-val"){
            description.css({
              'float' : "right",
              'width' : "100%",
              'text-align': "right"
            });
          }
        });
      };

      var isHebrewCharacter = function(character) {
        if (character.match(/[\u0590-\u05FF]/)) {
          return true;
        } else {
          return false;
        }
      };

      var isEnglishCharacter = function(character) {
        if (character.match(/^[a-zA-Z]*$/)) {
          return true;
        } else {
          return false;
        }
      };

      var changeCheckboxesListAlignment = function (element, tmpDir) {
        var parentEl = element.parent();

        if (parentEl.attr('data-inline-task-id') !== undefined) {
          var prevEl = parentEl[0].previousSibling;

          if (prevEl && prevEl.nodeName === 'LI') {
            tmpDir = prevEl.getAttribute('dir');
          }

          parentEl.attr('dir', tmpDir);
          var ulEl = element.parent();

          if (ulEl[0].getAttribute('dir') === null) {
            var alignment = tmpDir === 'ltr' ? 'left' : 'right';

            ulEl.attr('dir', tmpDir);
            ulEl.css('text-align', alignment);
          }
        }
      };

      var getAllTextElements = function(iframeDocument) {
        var elements = iframeDocument.find('body *').contents().filter(function() {
          return (this.nodeType == 3) && this.nodeValue.match(/\S/);
        });

        var text = [];
        var notHebrewText = [];
        AJS.$.each(elements, function() {
          var node = AJS.$(this)[0];
          var character =  AJS.$(this).text().substring(0,1);
          for (var i = 0; i < AJS.$(this).text().length; i++) {
            if (!(isHebrewCharacter(character) || isEnglishCharacter(character)))
              character = AJS.$(this).text().substring(i+1, 1);
            else
              break;
          }
          if (isHebrewCharacter(character)){
            text.push(AJS.$(this).parent());
          } else {
            // notHebrewText.push(AJS.$(this).parent());

            node = getParagraph(node);
            if (node && node.nodeName !== 'LI') {
              // isRTL = getIsRTL(isRTL, text);
              var txt = AJS.$(this).text();
              if (getIsRTL(null, txt)) {
                text.push(AJS.$(this).parent());
              } else {
                notHebrewText.push(AJS.$(this).parent());
              }
            } else {
              notHebrewText.push(AJS.$(this).parent());
            }
          }
        });

        AJS.$.each(notHebrewText, function() {
          var el = AJS.$(this);
          if (el.hasClass('confluence-userlink')) {
            el.parent().css({
              'direction': "ltr",
              'text-align': 'left !important'
            });
          }

          if (el.parent().hasClass('wiki-content')) {
            el.css({
              'direction': "ltr",
              'text-align': 'left !important'
            });
          }

          if (el[0].nodeName === 'LI') {
            var prevEl = el[0].previousSibling;
            var tmpDir = 'ltr';
            if (prevEl && prevEl.nodeName === 'LI') {
              tmpDir = prevEl.getAttribute('dir');
            }
            el.attr('dir', tmpDir);

            var ulEl = el.parent();
            if (ulEl[0].getAttribute('dir') === null) {
              ulEl.attr('dir', tmpDir);
              ulEl.css('text-align', tmpDir === 'ltr' ? 'left' : 'right');
            }
          } else if (el[0].nodeName === 'SPAN') {
            changeCheckboxesListAlignment(el, 'ltr');
          } else if (el[0].nodeName === 'P') {
            el.css({
              'direction': "ltr",
              'text-align': 'left !important'
            });
            el[0].style.direction = 'ltr';
            el[0].style.textAlign = 'left !important';
            el[0].style.cssText = 'text-align: right; direction: ltr;';
            el.addClass('text-left');
          } else if(el[0].nodeName === 'TH' || el[0].nodeName === 'TD') {
            el[0].style.direction = 'ltr';
            el[0].style.textAlign = 'left !important';
            el[0].style.cssText = 'text-align: right; direction: ltr;';
            el.addClass('text-left');
          }
        });

        text.reverse();
        return text;
      };

        function setDir(dir) {
            var dom = editor.dom, curDir, blocks = editor.selection.getSelectedBlocks();

            if (blocks.length) {
                curDir = dom.getAttrib(blocks[0], "dir");
                tinymce.each(blocks, function (block) {
                    // if (!dom.getParent(block.parentNode, "*[dir='" + dir + "']", dom.getRoot())) {
                        if (curDir != dir) {
                            dom.setAttrib(block, "dir", dir);
                        }
                        if (dir === 'rtl')
                            dom.setStyle(block, "text-align", "right");
                        else if (dir === 'ltr') {
                                dom.setStyle(block, "text-align", "left !important");
                                dom.setAttrib(block, "dir", dir);
                            }
                    // }
                });
                editor.nodeChanged();
            }
        }

        function getParagraph(node) {
            if (node.nodeName !== 'P' || node.nodeName !== 'LI' || node.nodeName !== 'TD' || node.nodeName !== 'TH') {
                node = node.parentNode;
                if (node.nodeName !== 'P' && node.nodeName !== 'LI' && node.nodeName !== 'TD' && node.nodeName !== 'TH') {
                    while (node !== null && (node.nodeName !== 'P' && node.nodeName !== 'LI' && node.nodeName !== 'TD' && node.nodeName !== 'TH')) {
                        node = node.parentNode;
                    }
                }
            }

            return node;
        }

        function getParagraphText(node) {
            return node.innerText;
        }

        function checkRTL(s) {
            var ltrChars = 'A-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02B8\u0300-\u0590\u0800-\u1FFF' + '\u2C00-\uFB1C\uFDFE-\uFE6F\uFEFD-\uFFFF',
                rtlChars = '\u0591-\u07FF\uFB1D-\uFDFD\uFE70-\uFEFC',
                rtlDirCheck = new RegExp('^[^' + ltrChars + ']*[' + rtlChars + ']');

            return rtlDirCheck.test(s);
        }

        function isRTLLetter(letter) {
            return letter.match(/[\u0590-\u05FF]/) !== null;
        }

        function getFormattedText(text) {
            return text.replace(/[^\u0591-\u07FF\uFB1D-\uFDFD\uFE70-\uFEFCA-Za-z\u00C0-\u00D6\u00D8-\u00F6\u00F8-\u02B8\u0300-\u0590\u0800-\u1FFF'\u2C00-\uFB1C\uFDFE-\uFE6F\uFEFD-\uFFFF]+/g, '');
        }

        function getIsRTL(isRTL, text) {
            text = text.replace("\xEF\xBB\xBF", '');
            text = getFormattedText(text);
            if (text.charAt(0) && text !== '') {
                isRTL = isRTLLetter(text.charAt(0));
            }

            return isRTL;
        }

        function changeConfUserLinksDirections() {
            setTimeout(function () {
                var aTags = AJS.$('iframe').contents()[0].getElementsByTagName('A');
                AJS.$.each(aTags, function () {
                    var $this = AJS.$(this);
                    var parent;
                    if ($this.hasClass('confluence-userlink')) {
                        parent = AJS.$(this).parent();
                        parent.attr('dir', 'ltr');
                        parent.css({
                            'direction': "ltr"
                        });
                    }
                });
            }, 100);
        }

        function keyPressHandler(e) {
                var isRTL = body[0].dir === 'rtl';
                var text, node;
                if (e.charCode !== 32 && e.charCode !== 13) {
                  setTimeout(function () {
                    node = AJS.$('iframe')[0].contentWindow.getSelection().anchorNode;

                    text = node.data;
                    if (text === undefined) {

                        if (node.nodeName !== 'P' || node.nodeName !== 'LI') {
                            node = node.parentNode;
                            if (node.nodeName !== 'P' && node.nodeName !== 'LI') {
                                while (node !== null && (node.nodeName !== 'P' && node.nodeName !== 'LI')) {
                                    node = node.parentNode;
                                }
                            }
                        }

                        if (node !== null) {
                          node = node.previousSibling;
                          text = node.innerText;
                        }

                        if (text === undefined) {
                            isRTL = node && node.nodeType === 1 ? true : checkRTL(String.fromCharCode(e.charCode));
                        } else {
                            isRTL = getIsRTL(isRTL, text);
                        }
                    } else {
                      var nodeParagraph = getParagraph(node);
                      if (nodeParagraph) {
                        if (nodeParagraph.nodeName === 'LI') {

                          if (nodeParagraph.getAttribute('enter')) {
                            nodeParagraph.removeAttribute('enter');
                          }

                          var prev = nodeParagraph.previousSibling;
                          if (prev === null) {
                            if (nodeParagraph.parentNode.nodeName === 'UL') {
                              isRTL = body[0].dir === 'rtl';

                              text = getParagraphText(nodeParagraph);
                              isRTL = getIsRTL(isRTL, text);

                              if (isRTL) {
                                nodeParagraph.parentNode.setAttribute('dir', 'rtl');
                                nodeParagraph.parentNode.style.textAlign = 'right';
                              } else {
                                nodeParagraph.parentNode.style.textAlign = 'left !important';
                              }

                            } else {
                              text = getParagraphText(nodeParagraph);
                              isRTL = getIsRTL(isRTL, text);
                            }
                          } else {
                            isRTL = prev.getAttribute('dir') === 'rtl';
                          }
                        } else {
                          text = getParagraphText(nodeParagraph);
                          isRTL = getIsRTL(isRTL, text);
                        }
                      } else {
                        isRTL = false;
                      }
                    }

                    if (isRTL) {
                        setDir('rtl');
                    } else {
                        setDir('ltr');
                    }
                  }, 100);
                }
        }

        function keyUpHandler(event) {
          var code = event.which || event.keyCode;
          if (code === 13) {
            var selectedBlocks = editor.selection.getSelectedBlocks();
            var currentBlock = selectedBlocks[0];
            var $currentBlock = AJS.$(currentBlock);
            var $parentEl = $currentBlock.parent();
            if (currentBlock && currentBlock.nodeName === 'LI' && currentBlock.dataset.hasOwnProperty('inlineTaskId')) {
              if (currentBlock.getAttribute('enter')) {
                var nextEl = currentBlock.nextSibling;

                if (!nextEl) {
                  appendNewElement(currentBlock, $currentBlock, $parentEl)
                } else {
                  var children = $parentEl.children();
                  var index = children.index(currentBlock);

                  if (index !== -1) {

                    var sublist;
                    while((sublist = $parentEl.find('li:gt('+(index)+')').remove()).length){
                      appendNewElement(currentBlock, $currentBlock, $parentEl, sublist);
                    }
                  }
                }
              } else {
                if (!$currentBlock.text().length) {
                  currentBlock.setAttribute('enter', true);
                }
              }
            }

            if ($currentBlock.hasClass('macro-alignment')) {
              $currentBlock.removeClass('macro-alignment');
            }

            if ($currentBlock.hasClass('macro-alignment-inactive')) {
              $currentBlock.removeClass('macro-alignment-inactive');
            }

              editor.nodeChanged();
          }
        }

        function appendNewElement(currentBlock, $currentBlock, $parentEl, sublist) {
          var $newEl = AJS.$('<p dir="rtl"><input><br></p>');
          var $txt = $newEl.find('input');

          currentBlock.removeAttribute('enter');
          $parentEl.after($newEl);
          $txt.focus();
          $txt.remove();

          if (sublist) {
            $newEl.after($('<ul class="inline-task-list"><ul/>').append(sublist));
          }

          $currentBlock.remove();
        }

        function clickHandler(event) {
          if (event.target.nodeName === 'LI' && event.target.dataset.hasOwnProperty('inlineTaskId') && event.target.getAttribute('dir') === 'rtl') {
            event.preventDefault();
            event.stopPropagation();

            var elm = AJS.$(this);
            var xPos = event.pageX - elm.offset().left;
            if (event.target.clientWidth - xPos < 18) {
              event.target.classList.toggle('checked');
            }
          }
        }
    }
}