/*
 * Decompiled with CFR 0.152.
 */
package com.practiproject.confluenceLanguageHebrew.servlet;

import com.atlassian.confluence.json.json.JsonObject;
import com.atlassian.confluence.languages.LocaleManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.atlassian.user.EntityException;
import com.atlassian.user.User;
import com.atlassian.user.UserManager;
import com.practiproject.confluenceLanguageHebrew.utils.LicenseUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Locale;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class TextDirectionServlet
extends HttpServlet {
    private static final String ACTION = "action";
    private static final String GET_USER_LANGUAGE = "getUserLanguage";
    private final PluginLicenseManager pluginLicenseManager;

    public TextDirectionServlet(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        if (LicenseUtils.isLicenseValid((Option<PluginLicense>)this.pluginLicenseManager.getLicense())) {
            String action = req.getParameter(ACTION);
            if (StringUtils.isBlank((String)action)) {
                res.sendError(400);
                return;
            }
            if (action.equalsIgnoreCase(GET_USER_LANGUAGE)) {
                JsonObject jsonObject = new JsonObject();
                LocaleManager localeManager = (LocaleManager)ContainerManager.getComponent((String)"localeManager");
                UserManager userManager = (UserManager)ContainerManager.getComponent((String)"userManager");
                ConfluenceUser confluenceUser = AuthenticatedUserThreadLocal.get();
                String userName = confluenceUser.getName();
                User user = null;
                try {
                    user = userManager.getUser(userName);
                }
                catch (EntityException e) {
                    e.printStackTrace();
                }
                String language = null;
                if (user != null) {
                    Locale locale = localeManager.getLocale(user);
                    language = locale.getLanguage();
                }
                try {
                    jsonObject.setProperty("locale", language);
                }
                catch (Throwable e) {
                    e.printStackTrace();
                }
                PrintWriter out = res.getWriter();
                res.setContentType("application/json; charset=\"utf-8\"");
                res.setStatus(200);
                out.print(jsonObject.serialize());
                out.flush();
            }
        }
    }
}

