/*
 * Decompiled with CFR 0.152.
 */
package com.practiproject.confluenceLanguageHebrew.listener;

import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.PluginEventListener;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.plugin.event.events.PluginModuleEnabledEvent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.practiproject.confluenceLanguageHebrew.condition.LicenseManager;
import com.practiproject.confluenceLanguageHebrew.service.LanguageModuleService;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class PluginModuleEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginModuleEventListener.class);
    private final EventPublisher eventPublisher;
    private final LicenseManager licenseManager;
    private final LanguageModuleService languageModuleService;

    @Inject
    public PluginModuleEventListener(@ComponentImport EventPublisher eventPublisher, LicenseManager licenseManager, LanguageModuleService languageModuleService) {
        this.eventPublisher = eventPublisher;
        this.licenseManager = licenseManager;
        this.languageModuleService = languageModuleService;
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
    }

    @PluginEventListener
    public void onPluginModuleEnabled(PluginModuleEnabledEvent event) {
        if (!"com.practiproject.confluenceLanguageHebrew".equals(event.getModule().getPluginKey()) || this.licenseManager.isLicenseValid()) {
            return;
        }
        this.languageModuleService.disableLanguageModule();
        LOGGER.warn("Plugin license is invalid. Language module was disabled.");
    }

    @PluginEventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        if (!"com.practiproject.confluenceLanguageHebrew".equals(event.getPlugin().getKey())) {
            return;
        }
        if (this.licenseManager.isLicenseValid()) {
            this.languageModuleService.enableLanguageModule();
        } else {
            this.languageModuleService.disableLanguageModule();
            LOGGER.warn("Plugin license is invalid. Language module was disabled.");
        }
    }
}

