/*
 * Decompiled with CFR 0.152.
 */
package com.practiproject.confluenceLanguageHebrew.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.upm.api.license.PluginLicenseEventRegistry;
import com.atlassian.upm.api.license.event.PluginLicenseEvent;
import com.practiproject.confluenceLanguageHebrew.condition.LicenseManager;
import com.practiproject.confluenceLanguageHebrew.service.LanguageModuleService;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class PluginLicenseEventListener
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginLicenseEventListener.class);
    private final PluginLicenseEventRegistry pluginLicenseEventRegistry;
    private final LicenseManager licenseManager;
    private final LanguageModuleService languageModuleService;

    @Inject
    public PluginLicenseEventListener(@ComponentImport PluginLicenseEventRegistry pluginLicenseEventRegistry, LicenseManager licenseManager, LanguageModuleService languageModuleService) {
        this.pluginLicenseEventRegistry = pluginLicenseEventRegistry;
        this.licenseManager = licenseManager;
        this.languageModuleService = languageModuleService;
    }

    public void destroy() throws Exception {
        this.pluginLicenseEventRegistry.register((Object)this);
    }

    public void afterPropertiesSet() throws Exception {
        this.pluginLicenseEventRegistry.register((Object)this);
    }

    @EventListener
    public void onPluginLicenseEvent(PluginLicenseEvent event) {
        if (!"com.practiproject.confluenceLanguageHebrew".equals(event.getPluginKey())) {
            return;
        }
        if (this.licenseManager.isLicenseValid()) {
            this.languageModuleService.enableLanguageModule();
        } else {
            this.languageModuleService.disableLanguageModule();
            LOGGER.warn("Plugin license is invalid. Language module was disabled.");
        }
    }
}

