/*
 * Decompiled with CFR 0.152.
 */
package com.practiproject.confluenceLanguageHebrew.job;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.practiproject.confluenceLanguageHebrew.condition.LicenseManager;
import com.practiproject.confluenceLanguageHebrew.service.LanguageModuleService;
import javax.annotation.Nullable;
import javax.inject.Inject;
import javax.inject.Named;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

@Named
public class LicenseValidationJob
implements JobRunner,
InitializingBean,
DisposableBean {
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)LicenseValidationJob.class.getName());
    private static final JobId JOB_ID = JobId.of((String)LicenseValidationJob.class.getName());
    private static final Logger LOGGER = LoggerFactory.getLogger(LicenseValidationJob.class);
    private final LanguageModuleService languageModuleService;
    private final LicenseManager licenseManager;
    private final SchedulerService schedulerService;

    @Inject
    public LicenseValidationJob(LanguageModuleService languageModuleService, LicenseManager licenseManager, @ComponentImport SchedulerService schedulerService) {
        this.languageModuleService = languageModuleService;
        this.licenseManager = licenseManager;
        this.schedulerService = schedulerService;
    }

    @Nullable
    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        if (!this.licenseManager.isLicenseValid()) {
            this.languageModuleService.disableLanguageModule();
            LOGGER.warn("Plugin license is invalid. Language module was disabled.");
        }
        return JobRunnerResponse.success();
    }

    public void destroy() throws Exception {
        this.schedulerService.unscheduleJob(JOB_ID);
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    public void afterPropertiesSet() throws Exception {
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)this);
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forCronExpression((String)"0 0 12 * * ?"));
        this.schedulerService.scheduleJob(JOB_ID, jobConfig);
    }
}

