/*
 * Decompiled with CFR 0.152.
 */
package com.porzelt.confluence.darktheme.servlet;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.porzelt.confluence.darktheme.entity.Settings;
import com.porzelt.confluence.darktheme.utils.AoUtils;
import com.porzelt.confluence.darktheme.utils.LicenseUtils;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class DarkThemeAdmin
extends HttpServlet {
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final PluginLicenseManager pluginLicenseManager;
    private final PermissionManager permissionManager;
    private final ActiveObjects ao;

    @Autowired
    public DarkThemeAdmin(@ComponentImport TemplateRenderer templateRenderer, @ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport PermissionManager permissionManager, @ComponentImport ActiveObjects activeObject) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.pluginLicenseManager = pluginLicenseManager;
        this.permissionManager = permissionManager;
        this.ao = activeObject;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String username = this.userManager.getRemoteUsername(req);
        if (username == null) {
            this.redirectToLogin(req, resp);
            return;
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        boolean isAdmin = this.permissionManager.isConfluenceAdministrator(currentUser);
        boolean isSysAdmin = this.permissionManager.isSystemAdministrator(currentUser);
        if (!(this.userManager.isSystemAdmin(username) || isAdmin || isSysAdmin)) {
            this.redirectToDashboard(req, resp);
            return;
        }
        AoUtils aoUtils = new AoUtils(this.ao);
        Settings selectedSetting = aoUtils.getDefaultSetting();
        paramMap.put("dynamicdisable", selectedSetting.getDisableDynamicAdjustment());
        paramMap.put("location", selectedSetting.getLocation());
        paramMap.put("fullimagecolor", selectedSetting.getFullImageColor());
        paramMap.put("storedcss", selectedSetting.getStoredCss());
        paramMap.put("linkcolor", selectedSetting.getLinkColor());
        paramMap.put("navcolor", selectedSetting.getNavigationColor());
        paramMap.put("scheme", selectedSetting.getScheme());
        paramMap.put("allowusersettings", selectedSetting.getAllowUserSettings());
        paramMap.put("forcedarktheme", selectedSetting.getForceDarkTheme());
        paramMap.put("legacytheme", selectedSetting.getUseLegacyTheme());
        paramMap.put("applicense", selectedSetting.getAppLicense());
        paramMap.put("syncostheme", selectedSetting.getSyncOsTheme());
        paramMap.put("req", req);
        LicenseUtils licenseUtils = new LicenseUtils(this.pluginLicenseManager, this.ao);
        paramMap.put("hasValidLicense", licenseUtils.HasValidLicense());
        paramMap.put("licenseStatus", licenseUtils.getLicenceStatus());
        paramMap.put("licenseData", licenseUtils.GetLicense());
        resp.setContentType("text/html");
        this.templateRenderer.render("/templates/servlet/pages/admin.vm", paramMap, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String remoteUsername = this.userManager.getRemoteUsername(req);
        if (remoteUsername == null) {
            this.redirectToLogin(req, res);
            return;
        }
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        boolean isAdmin = this.permissionManager.isConfluenceAdministrator(currentUser);
        boolean isSysAdmin = this.permissionManager.isSystemAdministrator(currentUser);
        if (!(this.userManager.isSystemAdmin(remoteUsername) || isAdmin || isSysAdmin)) {
            this.redirectToDashboard(req, res);
            return;
        }
        final AoUtils aoUtils = new AoUtils(this.ao);
        final Settings selectedSetting = aoUtils.getDefaultSetting();
        String dynamicString = req.getParameter("dynamic");
        final Boolean dynamic = dynamicString != null && dynamicString.length() > 0;
        String fullimagecolorString = req.getParameter("fullimagecolor");
        final Boolean fullimagecolor = fullimagecolorString != null && fullimagecolorString.length() > 0;
        String allowusersettingsString = req.getParameter("allowusersettings");
        final Boolean allowusersettings = allowusersettingsString != null && allowusersettingsString.length() > 0;
        String forcedarkthemeString = req.getParameter("forcedarktheme");
        final Boolean forcedarktheme = forcedarkthemeString != null && forcedarkthemeString.length() > 0;
        String legacyThemeString = req.getParameter("legacytheme");
        final Boolean legacyTheme = legacyThemeString != null && legacyThemeString.length() > 0;
        String syncOsThemeString = req.getParameter("syncostheme");
        final Boolean syncOsTheme = syncOsThemeString != null && syncOsThemeString.length() > 0;
        final String location = req.getParameter("location");
        final String storedcss = req.getParameter("storedcss");
        final String applicense = req.getParameter("applicense");
        final String scheme = req.getParameter("scheme");
        String linkcolor = req.getParameter("linkcolor");
        String navcolor = req.getParameter("navcolor");
        String prevScheme = selectedSetting.getScheme();
        if (!prevScheme.equals(scheme)) {
            if (scheme.equals("light")) {
                linkcolor = "#B1BEFF";
                navcolor = "#090A0B";
            } else if (scheme.equals("dark")) {
                linkcolor = "#B1BEFF";
                navcolor = "#000000";
            } else {
                linkcolor = "#B1BEFF";
                navcolor = "#252526";
            }
        }
        final String finalLinkcolor = linkcolor;
        final String finalNavcolor = navcolor;
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Settings>(){

            public Settings doInTransaction() {
                selectedSetting.setDisableDynamicAdjustment(dynamic);
                selectedSetting.setLocation(location);
                selectedSetting.setFullImageColor(fullimagecolor);
                selectedSetting.setStoredCss(storedcss);
                selectedSetting.setLinkColor(finalLinkcolor);
                selectedSetting.setNavigationColor(finalNavcolor);
                selectedSetting.setScheme(scheme);
                selectedSetting.setAllowUserSettings(allowusersettings);
                selectedSetting.setForceDarkTheme(forcedarktheme);
                selectedSetting.setUseLegacyTheme(legacyTheme);
                selectedSetting.setSyncOsTheme(syncOsTheme);
                selectedSetting.setAppLicense(applicense.trim());
                selectedSetting.setTStamp(aoUtils.getTimestamp());
                selectedSetting.save();
                return selectedSetting;
            }
        });
        res.sendRedirect(req.getContextPath() + "/plugins/servlet/porzelt/darktheme/admin");
    }

    private void redirectToDashboard(HttpServletRequest request, HttpServletResponse response) throws IOException {
        SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        response.sendRedirect(settingsManager.getGlobalSettings().getBaseUrl());
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

