/*
 * Decompiled with CFR 0.152.
 */
package com.porzelt.confluence.darktheme.contextprovider;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.web.context.StaticHttpContext;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.plugin.web.ContextProvider;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.porzelt.confluence.darktheme.entity.Settings;
import com.porzelt.confluence.darktheme.utils.AoUtils;
import com.porzelt.confluence.darktheme.utils.LicenseUtils;
import java.util.Map;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CssProvider
implements ContextProvider {
    private static final String pluginCookieNameDarkTheme = "com.porzelt.confluence.darktheme.active";
    private final PluginAccessor pluginAccessor;
    private final PluginLicenseManager pluginLicenseManager;
    private final ActiveObjects ao;

    @Autowired
    public CssProvider(@ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport ActiveObjects activeObject) {
        this.pluginAccessor = pluginAccessor;
        this.pluginLicenseManager = pluginLicenseManager;
        this.ao = activeObject;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public Map getContextMap(Map<String, Object> contextMap) {
        LicenseUtils licenseUtils = new LicenseUtils(this.pluginLicenseManager, this.ao);
        if (!licenseUtils.HasValidLicense()) {
            contextMap.put("styleSheetActive", false);
            return contextMap;
        }
        Boolean styleSheetActive = false;
        try {
            HttpServletRequest request = new StaticHttpContext().getRequest();
            if (request != null) {
                Cookie[] cookies;
                for (Cookie currentCookie : cookies = request.getCookies()) {
                    String cookieValue = currentCookie.getValue();
                    if (!currentCookie.getName().equals(pluginCookieNameDarkTheme) || !cookieValue.equals("true")) continue;
                    styleSheetActive = true;
                }
            }
        }
        catch (Exception request) {
            // empty catch block
        }
        AoUtils aoUtils = new AoUtils(this.ao);
        Settings selectedSetting = aoUtils.getUserSetting();
        Settings defaultSetting = aoUtils.getDefaultSetting();
        if (selectedSetting == null || !defaultSetting.getAllowUserSettings().booleanValue()) {
            selectedSetting = defaultSetting;
        }
        try {
            if (defaultSetting.getForceDarkTheme().booleanValue()) {
                styleSheetActive = styleSheetActive == false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        contextMap.put("styleSheetActive", styleSheetActive);
        contextMap.put("customSetting", !selectedSetting.getSettingID().equals("DEFAULT"));
        contextMap.put("dynamicdisable", selectedSetting.getDisableDynamicAdjustment());
        contextMap.put("legacydarktheme", defaultSetting.getUseLegacyTheme());
        contextMap.put("scheme", selectedSetting.getScheme());
        contextMap.put("timestamp", selectedSetting.getTStamp());
        contextMap.put("syncostheme", selectedSetting.getSyncOsTheme());
        SettingsManager settingsManager = (SettingsManager)ContainerManager.getComponent((String)"settingsManager");
        contextMap.put("baseUrl", settingsManager.getGlobalSettings().getBaseUrl());
        return contextMap;
    }
}

