/*
 * Decompiled with CFR 0.152.
 */
package com.porzelt.confluence.darktheme.servlet;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.porzelt.confluence.darktheme.entity.Settings;
import com.porzelt.confluence.darktheme.utils.AoUtils;
import com.porzelt.confluence.darktheme.utils.LicenseUtils;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.java.ao.DBParam;
import net.java.ao.RawEntity;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class DarkThemeUser
extends HttpServlet {
    private final TemplateRenderer templateRenderer;
    private final UserManager userManager;
    private final LoginUriProvider loginUriProvider;
    private final PluginLicenseManager pluginLicenseManager;
    private final ActiveObjects ao;

    @Autowired
    public DarkThemeUser(@ComponentImport TemplateRenderer templateRenderer, @ComponentImport UserManager userManager, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport ActiveObjects activeObject) {
        this.templateRenderer = templateRenderer;
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.pluginLicenseManager = pluginLicenseManager;
        this.ao = activeObject;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, Object> paramMap = new HashMap<String, Object>();
        String username = this.userManager.getRemoteUsername(req);
        if (username == null) {
            this.redirectToLogin(req, resp);
            return;
        }
        AoUtils aoUtils = new AoUtils(this.ao);
        Settings selectedSetting = aoUtils.getUserSetting();
        Settings defaultSetting = aoUtils.getDefaultSetting();
        if (!defaultSetting.getAllowUserSettings().booleanValue()) {
            resp.sendRedirect(req.getContextPath());
            return;
        }
        if (selectedSetting == null) {
            selectedSetting = defaultSetting;
        }
        paramMap.put("dynamicdisable", selectedSetting.getDisableDynamicAdjustment());
        paramMap.put("location", selectedSetting.getLocation());
        paramMap.put("fullimagecolor", selectedSetting.getFullImageColor());
        paramMap.put("storedcss", selectedSetting.getStoredCss());
        paramMap.put("linkcolor", selectedSetting.getLinkColor());
        paramMap.put("navcolor", selectedSetting.getNavigationColor());
        paramMap.put("scheme", selectedSetting.getScheme());
        paramMap.put("syncostheme", selectedSetting.getSyncOsTheme());
        paramMap.put("req", req);
        LicenseUtils licenseUtils = new LicenseUtils(this.pluginLicenseManager, this.ao);
        paramMap.put("hasValidLicense", licenseUtils.HasValidLicense());
        paramMap.put("licenseStatus", licenseUtils.getLicenceStatus());
        paramMap.put("licenseData", licenseUtils.GetLicense());
        resp.setContentType("text/html");
        this.templateRenderer.render("/templates/servlet/pages/user.vm", paramMap, (Writer)resp.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        String remoteUsername = this.userManager.getRemoteUsername(req);
        if (remoteUsername == null) {
            this.redirectToLogin(req, res);
            return;
        }
        final AoUtils aoUtils = new AoUtils(this.ao);
        final Settings selectedSetting = aoUtils.getUserSetting();
        final String username = aoUtils.getUserName();
        String prevScheme = "";
        prevScheme = selectedSetting == null ? "default" : selectedSetting.getScheme();
        String reset = req.getParameter("ResetButtonPressed");
        if (reset != null && reset.length() > 0) {
            if (selectedSetting != null) {
                this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Settings>(){

                    public Settings doInTransaction() {
                        DarkThemeUser.this.ao.delete(new RawEntity[]{selectedSetting});
                        return null;
                    }
                });
            }
            res.sendRedirect(req.getContextPath() + "/plugins/servlet/porzelt/darktheme/user");
            return;
        }
        String dynamicString = req.getParameter("dynamic");
        final Boolean dynamic = dynamicString != null && dynamicString.length() > 0;
        String fullimagecolorString = req.getParameter("fullimagecolor");
        final Boolean fullimagecolor = fullimagecolorString != null && fullimagecolorString.length() > 0;
        String syncOsThemeString = req.getParameter("syncostheme");
        final Boolean syncOsTheme = syncOsThemeString != null && syncOsThemeString.length() > 0;
        final String location = req.getParameter("location");
        final String storedcss = req.getParameter("storedcss");
        final String scheme = req.getParameter("scheme");
        String linkcolor = req.getParameter("linkcolor");
        String navcolor = req.getParameter("navcolor");
        if (!prevScheme.equals(scheme)) {
            if (scheme.equals("light")) {
                linkcolor = "#B1BEFF";
                navcolor = "#090A0B";
            } else if (scheme.equals("dark")) {
                linkcolor = "#B1BEFF";
                navcolor = "#000000";
            } else {
                linkcolor = "#B1BEFF";
                navcolor = "#252526";
            }
        }
        final String finalLinkcolor = linkcolor;
        final String finalNavcolor = navcolor;
        this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Settings>(){

            public Settings doInTransaction() {
                Settings userSetting;
                if (selectedSetting == null) {
                    userSetting = (Settings)DarkThemeUser.this.ao.create(Settings.class, new DBParam[0]);
                    userSetting.setSettingID(username);
                } else {
                    userSetting = selectedSetting;
                }
                userSetting.setDisableDynamicAdjustment(dynamic);
                userSetting.setLocation(location);
                userSetting.setFullImageColor(fullimagecolor);
                userSetting.setStoredCss(storedcss);
                userSetting.setLinkColor(finalLinkcolor);
                userSetting.setNavigationColor(finalNavcolor);
                userSetting.setScheme(scheme);
                userSetting.setSyncOsTheme(syncOsTheme);
                userSetting.setTStamp(aoUtils.getTimestamp());
                userSetting.save();
                return userSetting;
            }
        });
        res.sendRedirect(req.getContextPath() + "/plugins/servlet/porzelt/darktheme/user");
    }

    private void redirectToLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

