/*
 * Decompiled with CFR 0.152.
 */
package com.porzelt.confluence.darktheme.servlet;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.spring.scanner.annotation.component.Scanned;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.porzelt.confluence.darktheme.entity.Settings;
import com.porzelt.confluence.darktheme.utils.AoUtils;
import com.porzelt.confluence.darktheme.utils.LicenseUtils;
import java.awt.Color;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;

@Scanned
public class CssServlet
extends HttpServlet {
    private static final String pluginCookieNameDarkTheme = "com.porzelt.confluence.darktheme.active";
    private final TemplateRenderer templateRenderer;
    private final PluginAccessor pluginAccessor;
    private final PluginLicenseManager pluginLicenseManager;
    private final ActiveObjects ao;

    @Autowired
    public CssServlet(@ComponentImport TemplateRenderer templateRenderer, @ComponentImport PluginAccessor pluginAccessor, @ComponentImport PluginLicenseManager pluginLicenseManager, @ComponentImport ActiveObjects activeObject) {
        this.templateRenderer = templateRenderer;
        this.pluginAccessor = pluginAccessor;
        this.pluginLicenseManager = pluginLicenseManager;
        this.ao = activeObject;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        HashMap<String, Object> contextMap = new HashMap<String, Object>();
        LicenseUtils licenseUtils = new LicenseUtils(this.pluginLicenseManager, this.ao);
        if (!licenseUtils.HasValidLicense()) {
            resp.setContentType("text/css");
            resp.getWriter().write("");
            return;
        }
        Boolean styleSheetActive = false;
        try {
            Cookie[] cookies;
            for (Cookie currentCookie : cookies = req.getCookies()) {
                String cookieValue = currentCookie.getValue();
                if (!currentCookie.getName().equals(pluginCookieNameDarkTheme) || !cookieValue.equals("true")) continue;
                styleSheetActive = true;
            }
        }
        catch (Exception cookies) {
            // empty catch block
        }
        contextMap.put("confluenceMajor", "");
        contextMap.put("confluenceMinor", "");
        AoUtils aoUtils = new AoUtils(this.ao);
        Settings selectedSetting = aoUtils.getUserSetting();
        Settings defaultSetting = aoUtils.getDefaultSetting();
        if (selectedSetting == null || !defaultSetting.getAllowUserSettings().booleanValue()) {
            selectedSetting = defaultSetting;
        }
        try {
            if (defaultSetting.getForceDarkTheme().booleanValue()) {
                styleSheetActive = styleSheetActive == false;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (!styleSheetActive.booleanValue()) {
            resp.setContentType("text/css");
            resp.getWriter().write("");
            return;
        }
        contextMap.put("dynamicdisable", selectedSetting.getDisableDynamicAdjustment());
        contextMap.put("location", selectedSetting.getLocation());
        contextMap.put("fullimagecolor", selectedSetting.getFullImageColor());
        contextMap.put("storedcss", selectedSetting.getStoredCss());
        String linkcolor = selectedSetting.getLinkColor();
        contextMap.put("linkcolor", linkcolor);
        try {
            Integer i = Integer.parseInt(linkcolor.substring(1), 16);
            Color linkcolorObject = new Color(i);
            String linkcolorDarker = "#" + Integer.toHexString(linkcolorObject.darker().getRGB()).substring(2);
            contextMap.put("linkcolorDarker", linkcolorDarker);
        }
        catch (Exception e) {
            contextMap.put("linkcolorDarker", linkcolor);
        }
        contextMap.put("navcolor", selectedSetting.getNavigationColor());
        contextMap.put("scheme", selectedSetting.getScheme());
        Collection plugins = this.pluginAccessor.getEnabledPlugins();
        ArrayList<String> pluginList = new ArrayList<String>();
        for (Plugin plugin : plugins) {
            if (!plugin.isUninstallable()) continue;
            pluginList.add(plugin.getKey());
        }
        contextMap.put("pluginList", pluginList);
        resp.setContentType("text/css");
        resp.setHeader("Cache-Control", "max-age=86400");
        this.templateRenderer.render("/templates/servlet/css/darkthemeMin.vm", contextMap, (Writer)resp.getWriter());
    }
}

