/*
 * Decompiled with CFR 0.152.
 */
package com.porzelt.confluence.darktheme.utils;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.upm.api.util.Option;
import com.porzelt.confluence.darktheme.entity.Settings;
import com.porzelt.confluence.darktheme.utils.AoUtils;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.spec.X509EncodedKeySpec;
import java.text.SimpleDateFormat;
import java.util.Base64;
import java.util.Calendar;
import java.util.Date;
import javax.crypto.Cipher;

public class LicenseUtils {
    private PluginLicenseManager pluginLicenseManager;
    private ActiveObjects ao;

    public LicenseUtils(PluginLicenseManager pluginLicenseManager, ActiveObjects activeObject) {
        this.pluginLicenseManager = pluginLicenseManager;
        this.ao = activeObject;
    }

    public boolean HasValidLicense() {
        try {
            if (this.CheckPrivateLicense()) {
                return true;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Option licenseOption = this.pluginLicenseManager.getLicense();
            if (licenseOption.isDefined()) {
                PluginLicense license = (PluginLicense)licenseOption.get();
                return license != null && license.isValid();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return false;
    }

    public PluginLicense GetLicense() {
        try {
            Option licenseOption = this.pluginLicenseManager.getLicense();
            if (licenseOption.isDefined()) {
                return (PluginLicense)licenseOption.get();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    public int getLicenceStatus() {
        block6: {
            try {
                Option licenseOption = this.pluginLicenseManager.getLicense();
                if (licenseOption.isDefined()) {
                    PluginLicense license = (PluginLicense)licenseOption.get();
                    if (license == null) {
                        return -3;
                    }
                    if (license.getError().isDefined()) {
                        return 1;
                    }
                    if (license.isValid()) {
                        return 0;
                    }
                    break block6;
                }
                return 2;
            }
            catch (Exception e) {
                return -2;
            }
        }
        return -1;
    }

    public boolean CheckPrivateLicense() {
        AoUtils aoUtils = new AoUtils(this.ao);
        Settings selectedSetting = aoUtils.getDefaultSetting();
        String licenseData = selectedSetting.getAppLicense();
        if (licenseData != null && licenseData.length() > 3) {
            try {
                String base64PublicKey = "MIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAjf53QKt8OGlcjTV54Lezi0TRcoz7OaIzF7sWPE486C+Fzkyjx0eNMD6fwoth2yfNfb5mKinBeuHtaEfttWccjHPdMIKE6jjCn7FONb0MHuxKY4PD5Mx7RV3NT2SXxcf+N4LdD3wd8ChQ22VWRsacBFVvrR9+61NwweL2Qd80iLP2DFHIzLKIRJTHJDGVYTgza7bMOrjC0itXhnenEm55EozVnf3kfm/MhQVciHfAbbF4nD7iNUlWVtrWpq+JMdNgt06FXfmDYU9DGj19ScGL8otF87gz4MR57TCeRU6oOMTnEE6MdtEAQk4Y6ltxecFj7kzaVgeb3oXUJcHjyAV6qQIDAQAB";
                KeyFactory keyFactory = KeyFactory.getInstance("RSA");
                byte[] decodedPublicKey = Base64.getDecoder().decode(base64PublicKey);
                PublicKey publicKey = keyFactory.generatePublic(new X509EncodedKeySpec(decodedPublicKey));
                Cipher cipher = Cipher.getInstance("RSA");
                byte[] base64Decoded = Base64.getDecoder().decode(licenseData);
                cipher.init(2, publicKey);
                byte[] decryptedBytes = cipher.doFinal(base64Decoded);
                String decryptedText = new String(decryptedBytes);
                String[] parts = decryptedText.split(":");
                String datePart = parts[0];
                String userPart = parts[1];
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
                Date licensedate = dateFormat.parse(datePart);
                Calendar cal = Calendar.getInstance();
                cal.setTime(licensedate);
                cal.add(5, 1);
                licensedate = cal.getTime();
                Date today = new Date();
                if (today.before(licensedate)) {
                    return true;
                }
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }
}

