/*
 * Decompiled with CFR 0.152.
 */
package com.porzelt.confluence.darktheme.utils;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.porzelt.confluence.darktheme.entity.Settings;
import net.java.ao.DBParam;
import net.java.ao.Query;

public class AoUtils {
    private ActiveObjects ao;

    public AoUtils(ActiveObjects activeObject) {
        this.ao = activeObject;
    }

    public String getUserName() {
        ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser == null) {
            return null;
        }
        return currentUser.getKey().getStringValue();
    }

    public String getTimestamp() {
        return Long.toString(System.currentTimeMillis());
    }

    public Settings getUserSetting() {
        final ConfluenceUser currentUser = AuthenticatedUserThreadLocal.get();
        if (currentUser == null) {
            return null;
        }
        Settings selectedSetting = (Settings)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Settings>(){

            public Settings doInTransaction() {
                int n = 0;
                Settings[] settingsArray = (Settings[])AoUtils.this.ao.find(Settings.class, Query.select().where("SETTING_ID = ?", new Object[]{currentUser.getKey().getStringValue()}).limit(1));
                int n2 = settingsArray.length;
                if (n < n2) {
                    Settings set = settingsArray[n];
                    return set;
                }
                return null;
            }
        });
        return selectedSetting;
    }

    public Settings getDefaultSetting() {
        Settings selectedSetting = (Settings)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Settings>(){

            public Settings doInTransaction() {
                int n = 0;
                Settings[] settingsArray = (Settings[])AoUtils.this.ao.find(Settings.class, Query.select().where("SETTING_ID = 'DEFAULT'", new Object[0]).limit(1));
                int n2 = settingsArray.length;
                if (n < n2) {
                    Settings set = settingsArray[n];
                    return set;
                }
                return null;
            }
        });
        if (selectedSetting == null) {
            selectedSetting = (Settings)this.ao.executeInTransaction((TransactionCallback)new TransactionCallback<Settings>(){

                public Settings doInTransaction() {
                    Settings settingsObject = (Settings)AoUtils.this.ao.create(Settings.class, new DBParam[0]);
                    settingsObject.setSettingID("DEFAULT");
                    settingsObject.setDisableDynamicAdjustment(false);
                    settingsObject.setLocation("top");
                    settingsObject.setFullImageColor(false);
                    settingsObject.setStoredCss("");
                    settingsObject.setLinkColor("#B1BEFF");
                    settingsObject.setNavigationColor("#252526");
                    settingsObject.setScheme("default");
                    settingsObject.setAllowUserSettings(false);
                    settingsObject.setForceDarkTheme(false);
                    settingsObject.setUseLegacyTheme(false);
                    settingsObject.setAppLicense("");
                    settingsObject.setTStamp(AoUtils.this.getTimestamp());
                    settingsObject.save();
                    return settingsObject;
                }
            });
        }
        return selectedSetting;
    }
}

