AJS.toInit(function($) {  

var DTtryFilter = 0;
var DTmaxTry = 25;
var DTfilterClassName = "porzelt_darktheme_filter";
var DTurlBase = AJS.$('meta[name=porzelt-darktheme-base]').attr("content");
var MutationObserverCallCount = 0;

// ////////////////////////////////////////
// Button Click

jQuery(document).on('click', '#darktheme-switch-navigation-link', function(e) {
    e.preventDefault();
    executeDarkThemeButtonClick();
});

jQuery(document).on('click', '#darktheme-menue-profile-link', function(e) {
    e.preventDefault();
    executeDarkThemeButtonClick();
});

AJS.$( window ).ready(function() {
    AJS.$("aui-item-link:contains('"+AJS.$('meta[name=porzelt-darktheme-switch]').attr("content")+"')").first().on('click', 'a', function(e) {
        e.preventDefault();
        executeDarkThemeButtonClick();
    });
});


// ////////////////////////////////////////

var darkthemestyle="";

AJS.$( window ).ready(function() {
    if ( AJS.$('meta[name=porzelt-darktheme-active]').length > 0 ) {
        tagBody();
        if ( AJS.$('meta[name=porzelt-darktheme-dynamic]').length > 0 ) {
            darkthemestyle = AJS.$('meta[name=porzelt-darktheme-scheme]').attr("content");
            if(!window.location.pathname.includes("/porzelt/darktheme")
                && !window.location.pathname.includes("LookAndFeel")) {
                var all = document.getElementsByTagName("*");
                for (var i=0, max=all.length; i < max; i++) {
                    updateColor(all[i]);
                }
            }            
        }
    } else {
        if(getBrightness(AJS.$("nav.aui-header").css('background-color')) > 175){
            AJS.$("a#darktheme-switch-navigation-link").css({'filter':'invert(90%)'});
        }
    }

    AJS.$("a#darktheme-switch-navigation-link").attr('title', AJS.$('meta[name=porzelt-darktheme-switch]').attr("content"));
});

AJS.$( window ).load(function() {
    // OS Theme Sync
    if ( AJS.$('meta[name=porzelt-darktheme-syncostheme]').length > 0 ) {
        // Check to see if Media-Queries are supported - if so set the the theme like the OS theme
        if (window.matchMedia) {
            if(window.matchMedia('(prefers-color-scheme: dark)').matches){
                enableDarkTheme();
            } else {
                disableDarkTheme();
            }
        }
    }

    darkthemestyle = AJS.$('meta[name=porzelt-darktheme-scheme]').attr("content");
   
    if ( AJS.$('meta[name=porzelt-darktheme-active]').length > 0 ) {
        tagBody();
        setTimeout(doIframeInvertCall, 100);
    
        wikiColorFix();

        if ( AJS.$('meta[name=porzelt-darktheme-dynamic]').length > 0 ) {
            if(!window.location.pathname.includes("/porzelt/darktheme")
                && !window.location.pathname.includes("LookAndFeel")) {
                dynamicColorAdjust();
            }
        }
        
        setTimeout(bannerFix, 500);
        setTimeout(bannerFix, 1000);

        // Fix svg images
        AJS.$("svg").each(function (index) { 
            var a = $(this).find("*").toArray();
            for (var i=0, max=a.length; i < max; i++) {
                var color = $(a[i]).attr('fill');
                var brightness = getBrightness(color);
                if(brightness > 125)
                {
                    //$(a[i]).attr('fill', updatedColor);
                    $(a[i]).css({'filter':'invert(90%) hue-rotate(180deg)'});
                }
            };
        });

    } else {
        if(getBrightness(AJS.$("nav.aui-header").css('background-color')) > 175){
            AJS.$("a#darktheme-switch-navigation-link").css({'filter':'invert(90%)'});
        }
    }

    AJS.$("a#darktheme-switch-navigation-link").attr('title', AJS.$('meta[name=porzelt-darktheme-switch]').attr("content"));
});

// undo color invert
function doIframeInvertCall() {
    if(AJS.$("iframe").length > 0) {
    //if(AJS.$("iframe").length > 0 && AJS.$("iframe").contents().find('img:not([usemap]):not([class*="'+DTfilterClassName+'"])').length > 0) {

        if(AJS.$('meta[name=porzelt-darktheme-themegeneration-legacy]').length > 0)
        {
            AJS.$("iframe").contents().find('img:not([usemap]):not([class*="'+DTfilterClassName+'"])').css({'filter':'invert(90%) hue-rotate(180deg)'});
            AJS.$("iframe").contents().find('img:not([usemap]):not([class*="'+DTfilterClassName+'"])').addClass(DTfilterClassName);

        } else if(!AJS.$('meta[name=porzelt-darktheme-themegeneration-legacy]').length > 0 ){
            versionTwoIframeFix();
            setTimeout(versionTwoIframeFix, 250);
        }
        wikiColorFix();
        
        /*
        AJS.$("iframe").contents().find('#tinymce').off("DOMSubtreeModified");
        AJS.$("iframe").contents().find('#tinymce').on("DOMSubtreeModified",function(){
            DTtryFilter = 0;
            wikiColorFix();
        });
        */
    } else {
        if(DTtryFilter < DTmaxTry) {
            setTimeout(doIframeInvertCall, 1000 + (DTtryFilter * DTtryFilter * 25));
            DTtryFilter++;
        }
    }
};

function versionTwoIframeFix() {
    var IframeSelector = 'iframe:not([class*="'+DTfilterClassName+'"]):not([id*="gliffy"])';
    if( AJS.$(IframeSelector).length > 0 ) {
        //wikiColorFix();
        var iframeobject = AJS.$(IframeSelector);
        var iframeobjecthead = iframeobject.contents().find('head');
                
        // fallback stylesheet appender
        iframeobject.on("load", function() {
            try{
                if($(this).contents().find('head').html().indexOf('porzelt/darktheme/css') == -1){
                    $(this).css({'filter':'none'});
                    $(this).contents().find('head').append('<link type="text/css" rel="stylesheet" href="'+DTurlBase+'/plugins/servlet/porzelt/darktheme/css?_=t'+Math.round(Date.now()/(1000*60*60))+'" media="all">');
                    $(this).addClass(DTfilterClassName);
                } 
            } catch(err) { }
        });

        if(iframeobjecthead.length > 0) {
            iframeobject.css({'filter':'none'});
            iframeobjecthead.append('<link type="text/css" rel="stylesheet" href="'+DTurlBase+'/plugins/servlet/porzelt/darktheme/css?_=t'+Math.round(Date.now()/(1000*60*60))+'" media="all">');
            iframeobject.addClass(DTfilterClassName);
        }
    }
}

function wikiColorFix(){
    // wiki color fix + fix dark font
    var allSpan = AJS.$("iframe").contents().find(".wiki-content span");
    if(allSpan.length == 0) {
        allSpan = AJS.$("#main-content").find("span");
    }

    for (var i=0, max=allSpan.length; i < max; i++) {
        var color = $(allSpan[i]).prop('style')["color"];
        //var computedColor = window.getComputedStyle(allSpan[i]).getPropertyValue("color");
        var brightness = getBrightness(color);
        var colorbefore = color;

        if(brightness < 50) {
            color = RGBLinearShade(0.75, color );
        } else if(brightness < 100) {
            color = RGBLinearShade(0.50, color );
        } 
        
        if(colorbefore != color) {
            $(allSpan[i]).css({'color':color});
        }

        $(allSpan[i]).addClass("color");
        $(allSpan[i]).find('*').each(function (index) {
            $(this).addClass("color");
            $(this).css({'color':color});
        });
    }
}

function bannerFix() {
    var dtBannerClass="darktheme_banner_fix";
    var allFooterElements = AJS.$('#footer .footer-body *:not([class*="'+dtBannerClass+'"]):not([id="poweredby"]):not([class*="footer-logo"])');
    bannerFixRunner(allFooterElements);
    allFooterElements = AJS.$('#page .cell *:not([class*="'+dtBannerClass+'"])');
    bannerFixRunner(allFooterElements);
}

function bannerFixRunner(allBannerElements) {
    var dtBannerClass="darktheme_banner_fix";
    try {
        if(allBannerElements.length > 0){
            for (var i=0, bELength=allBannerElements.length; i < bELength; i++) {
                $(allBannerElements[i]).addClass(dtBannerClass);
                for( var j=0, bELengthInner=$(allBannerElements[i])[0].style.length; j<bELengthInner; j++) {
                    var tmpData = $(allBannerElements[i]).prop('style')[$(allBannerElements[i])[0].style[j]];
                    allBannerElements[i].style.setProperty($(allBannerElements[i])[0].style[j], tmpData, "important");
                }
            }
            
            for (var i=0, bELength=allBannerElements.length; i < bELength; i++) {
                var tmppppp = window.getComputedStyle($(allBannerElements[i])[0], "").getPropertyValue("background-color");
                var textColor = calculateTextColor(tmppppp);
                allBannerElements[i].style.setProperty("color", textColor, "important");
            }
        }
    } catch(err) { }
}

function tagBody(){
    if(AJS.$('body.porzelt-darktheme-active').length == 0) {
        AJS.$('body').addClass("porzelt-darktheme-active");
    }
}

function dynamicColorAdjust() {
    var all = document.getElementsByTagName("*");
    for (var i=0, max=all.length; i < max; i++) {
        updateColor(all[i]);
    }

    var domObserver = new MutationObserver(function(mutations, innerObserver) {  
        /*
        // No Need to exclude, as we limit to body
        MutationObserverCallCount++;
        if(MutationObserverCallCount > 1000
            || window.location.pathname.includes("resumedraft.action")
            || window.location.pathname.includes("editpage.action")
            || window.location.pathname.includes("createpage.action")) {
                innerObserver.disconnect();
        }
        */
        for (var i = 0, len = mutations.length; i < len; i++) {
            var mutation = mutations[i];
            try {
                for (var j = 0, lenj = mutation.addedNodes.length; j < lenj; j++) {
                    try {
                        // update node
                        var node = mutation.addedNodes[j];
                        updateColor(node);
                        // update sub items below node
                        var all = node.getElementsByTagName("*");
                        for (var k=0, max=all.length; k < max; k++) {
                            updateColor(all[k]);
                        }
                    } catch(err) { }
                }
            } catch(err) { }
        }
        try {
            if(mutations.length > 0) {
                wikiColorFix();
            }
            if(!AJS.$('meta[name=porzelt-darktheme-themegeneration-legacy]').length > 0 ){
                setTimeout(versionTwoIframeFix, 250);
            }
        } catch(err) { }
    });
    
    //var container = document.documentElement || document.body;
    var container = document.body;
    // attributes       - attribute changes will be observed | on add/remove/change attributes
    // characterdata    - data changes will be observed | on add/remove/change characterData
    // childlist        - target childs will be observed | on add/remove
    // subtree          - target childs will be observed | on attributes/characterData changes if they observed on target
    var domObserverConfig = { attributes: false, childList: true, subtree: true, characterData: false };   
    domObserver.observe(container, domObserverConfig);
}

function updateColor(currentElement) {
    if(
        currentElement.classList.contains('darktheme_no_adjustment') ||
        currentElement.classList.contains('darktheme_banner_fix') ||
        currentElement.classList.contains('porzelt_darktheme_darken')) {
            return;
    }
    try {
        /* Color */
        var color = window.getComputedStyle(currentElement, "").getPropertyValue("background-color");   
        var brightness = getBrightness(color);
        var updatedColor = color;

        if (brightness>225) {
            updatedColor = lowerLinHSL(color);
        } else if (brightness>200) {
            updatedColor = RGBLinearShade(-0.50, color );
        } else if (brightness>125) {
            updatedColor = RGBLinearShade(-0.25, color );
        }

        if(updatedColor != color) {
            currentElement.style.setProperty("background-color", updatedColor, "important");
            currentElement.classList.add("porzelt_darktheme_darken");
        }

        /* Hover */
        var colorHover = window.getComputedStyle(currentElement, ":hover").getPropertyValue("background-color");   
        var brightnessHover = getBrightness(colorHover);
        /* Hover Fallback*/
        if(brightnessHover == 0) {
            colorHover = window.getComputedStyle(currentElement, "hover").getPropertyValue("background-color");   
            brightnessHover = getBrightness(colorHover);    
        }

        if (brightnessHover>190) {
            currentElement.onmouseover = function(){this.style.setProperty("background-color", RGBLinearShade(-0.75, colorHover ), "important");}
            currentElement.onmouseout = function(){this.style.setProperty("background-color", updatedColor, "important");}
        } else if (brightnessHover>125) {
            currentElement.onmouseover = function(){this.style.setProperty("background-color", RGBLinearShade(-0.50, colorHover ), "important");}
            currentElement.onmouseout = function(){this.style.setProperty("background-color", updatedColor, "important");}
        }

        var textColorCurrent = window.getComputedStyle(currentElement, "").getPropertyValue("color");   
        var textColor = calculateTextColor(updatedColor, textColorCurrent);
        currentElement.style.setProperty("color", textColor, "important");

    } catch(err) { }
}

// ////////////////////////////////////////
// Explicit functions for automated color switch depending on OS theme
function enableDarkTheme() {
    var cookieName = "com.porzelt.confluence.darktheme.active"
    var data = getCookie(cookieName);
    if(data.length > 0) {
        if(data == "true")
            return;
    }

    setCookie(cookieName, true, 365);
    location.reload();
}

function disableDarkTheme() {
    var cookieName = "com.porzelt.jira.darktheme.active"
    var data = getCookie(cookieName);
    if(data.length > 0) {
        if(data == "false")
            return;
    }

    setCookie(cookieName, false, 365);
    location.reload();
}

function executeDarkThemeButtonClick() {
    var cookieName = "com.porzelt.confluence.darktheme.active"
    var cookieMode = "true";

    var data = getCookie(cookieName);
    if(data.length > 0) {
        if(data == "true")
            cookieMode = "false";
    }

    setCookie(cookieName, cookieMode, 365);
    location.reload();
}

function setCookie(cname, cvalue, exdays) {
    var d = new Date();
    d.setTime(d.getTime() + (exdays*24*60*60*1000));
    var expires = "expires="+ d.toUTCString();
    document.cookie = cname + "=" + cvalue + ";" + expires + ";path=/";
}

function getCookie(cname) {
    var name = cname + "=";
    var decodedCookie = decodeURIComponent(document.cookie);
    var ca = decodedCookie.split(';');
    for(var i = 0; i <ca.length; i++) {
        var c = ca[i];
        while (c.charAt(0) == ' ') {
            c = c.substring(1);
        }
        if (c.indexOf(name) == 0) {
            return c.substring(name.length, c.length);
        }
    }
    return "";
}

// ////////////////////////////////////////
function lowerLinHSL(color) {
    var hsl = RGBToHSL(color);
    if(hsl == null)
        return;

    return HSLToRGB("hsl(" + hsl[0] + "," + hsl[1] + "%,10%)");
}

function RGBToHSL(rgb) {
    var ex = /^rgb\((((((((1?[1-9]?\d)|10\d|(2[0-4]\d)|25[0-5]),\s?)){2}|((((1?[1-9]?\d)|10\d|(2[0-4]\d)|25[0-5])\s)){2})((1?[1-9]?\d)|10\d|(2[0-4]\d)|25[0-5]))|((((([1-9]?\d(\.\d+)?)|100|(\.\d+))%,\s?){2}|((([1-9]?\d(\.\d+)?)|100|(\.\d+))%\s){2})(([1-9]?\d(\.\d+)?)|100|(\.\d+))%))\)$/i;
    if (ex.test(rgb)) {
        var sep = rgb.indexOf(",") > -1 ? "," : " ";
        rgb = rgb.substr(4).split(")")[0].split(sep);
        
        try{
            for (var R in rgb) {
                var r = rgb[R];
                if (r.indexOf("%") > -1)
                    rgb[R] = Math.round(r.substr(0,r.length - 1) / 100 * 255);
            }
        } catch(err) { }

        var r = rgb[0] / 255,
            g = rgb[1] / 255,
            b = rgb[2] / 255,

            cmin = Math.min(r,g,b),
            cmax = Math.max(r,g,b),
            delta = cmax - cmin,
            h = 0,
            s = 0,
            l = 0;

        if (delta == 0)
            h = 0;
        else if (cmax == r)
            h = ((g - b) / delta) % 6;
        else if (cmax == g)
            h = (b - r) / delta + 2;
        else
            h = (r - g) / delta + 4;

        h = Math.round(h * 60);

        if (h < 0)
            h += 360;

        l = (cmax + cmin) / 2;

        s = delta == 0 ? 0 : delta / (1 - Math.abs(2 * l - 1));

        s = +(s * 100).toFixed(1);
        l = +(l * 100).toFixed(1);
        
        return [h, s, l];
    } else {
        return null;
    }
}

function HSLToRGB(hsl,isPct) {
    var ex = /^hsl\(((((([12]?[1-9]?\d)|[12]0\d|(3[0-5]\d))(\.\d+)?)|(\.\d+))(deg)?|(0|0?\.\d+)turn|(([0-6](\.\d+)?)|(\.\d+))rad)((,\s?(([1-9]?\d(\.\d+)?)|100|(\.\d+))%){2}|(\s(([1-9]?\d(\.\d+)?)|100|(\.\d+))%){2})\)$/i;
    if (ex.test(hsl)) {
        var sep = hsl.indexOf(",") > -1 ? "," : " ";
        hsl = hsl.substr(4).split(")")[0].split(sep);
        isPct = isPct === true;

        var h = hsl[0],
            s = hsl[1].substr(0,hsl[1].length - 1) / 100,
            l = hsl[2].substr(0,hsl[2].length - 1) / 100;

        if (h.indexOf("deg") > -1)
            h = h.substr(0,h.length - 3);
        else if (h.indexOf("rad") > -1)
            h = Math.round(h.substr(0,h.length - 3) / (2 * Math.PI) * 360);
        else if (h.indexOf("turn") > -1)
            h = Math.round(h.substr(0,h.length - 4) * 360);
        if (h >= 360)
            h %= 360;
        
        var c = (1 - Math.abs(2 * l - 1)) * s,
            x = c * (1 - Math.abs((h / 60) % 2 - 1)),
            m = l - c/2,
            r = 0,
            g = 0,
            b = 0;
        
        if (0 <= h && h < 60) {
            r = c; g = x; b = 0;
        } else if (60 <= h && h < 120) {
            r = x; g = c; b = 0;
        } else if (120 <= h && h < 180) {
            r = 0; g = c; b = x;
        } else if (180 <= h && h < 240) {
            r = 0; g = x; b = c;
        } else if (240 <= h && h < 300) {
            r = x; g = 0; b = c;
        } else if (300 <= h && h < 360) {
            r = c; g = 0; b = x;
        }

        r = Math.round((r + m) * 255);
        g = Math.round((g + m) * 255);
        b = Math.round((b + m) * 255);

        if (isPct) {
            r = +(r / 255 * 100).toFixed(1);
            g = +(g / 255 * 100).toFixed(1);
            b = +(b / 255 * 100).toFixed(1);
        }
        return "rgb("+ (isPct ? r + "%," + g + "%," + b + "%" : +r + "," + +g + "," + +b) + ")";
    } else {
        return null;
    }
}

function getBrightness(color) {
    try {
        // Variables for red, green, blue values
        var r, g, b, hsp;
        
        if (color.match(/^rgb/)) {
            color = color.match(/^rgba?\((\d+),\s*(\d+),\s*(\d+)(?:,\s*(\d+(?:\.\d+)?))?\)$/);
            r = color[1];
            g = color[2];
            b = color[3];
        } else {
            color = +("0x" + color.slice(1).replace( 
            color.length < 5 && /./g, '$&$&'));

            r = color >> 16;
            g = color >> 8 & 255;
            b = color & 255;
        }
        
        hsp = Math.sqrt(
            0.299 * (r * r) +
            0.587 * (g * g) +
            0.114 * (b * b)
        );
        return hsp;
    } catch(err) { 
        return 0;
    }
}

function RGBLinearShade (p, col) {
    var colArr = col.split(",");
    var a = colArr[0];
    var b = colArr[1];
    var c = colArr[2];
    var d = colArr[3];

    var P = p < 0;
    var t = P ? 0 : 255 * p;
    var P = P ? 1 + p : 1 - p;

    return "rgb" + (d ? "a(" : "(") + 
        Math.round(parseInt(a[3] == "a" ? a.slice(5) : a.slice(4)) * P + t + getColoradjust("r")) + 
        "," + Math.round(parseInt(b) * P + t + getColoradjust("g")) + 
        "," + Math.round(parseInt(c) * P + t + getColoradjust("b")) + 
        (d ? "," + d : ")");
}

function getColoradjust(type){
    var r,g,b;
    r = g = b = 0;
    if(darkthemestyle == 'light') {
        r = -10;
        g = +0;
        b = +10;
    } else if(darkthemestyle == 'dark') {
        r = -50;
        g = -50;
        b = -50;
    }

    if (type == 'r') return r;
    if (type == 'g') return g;
    if (type == 'b') return b;
    return 0;
}

// ////////////////////////////////////////
function getRGB(c) {
    return parseInt(c, 16) || c
}

function getsRGB(c) {
    return getRGB(c) / 255 <= 0.03928
        ? getRGB(c) / 255 / 12.92
        : Math.pow((getRGB(c) / 255 + 0.055) / 1.055, 2.4)
}

function getLuminance(hexColor) {
    return (
        0.2126 * getsRGB(hexColor.substr(1, 2)) +
        0.7152 * getsRGB(hexColor.substr(3, 2)) +
     0.0722 * getsRGB(hexColor.substr(-2))
    )
}

function getLuminanceFromRGB(rgbValue) {
    var rgbArray = rgbValue.split(', ');
    return (
        0.2126 * getsRGB(rgbArray[0].replace(/\D/g,'')) +
        0.7152 * getsRGB(rgbArray[1].replace(/\D/g,'')) +
     0.0722 * getsRGB(rgbArray[2].replace(/\D/g,''))
    )
}

function getContrast(f, b) {
    var L1 = getLuminanceFromRGB(f)
    var L2 = getLuminanceFromRGB(b)
    return (Math.max(L1, L2) + 0.05) / (Math.min(L1, L2) + 0.05)
}

function calculateTextColor(bgColor, currentTextColor) {
    if (currentTextColor) {
        var currentContrast = getContrast(bgColor, currentTextColor);
        if(currentContrast > 5) return;
    }
    var whiteContrast = getContrast(bgColor, 'rgb(220, 220, 220)');
    var blackContrast = getContrast(bgColor, 'rgb(0, 0, 0)');
 
    return whiteContrast > blackContrast ? '#DCDCDC' : '#000000'
}

});
