/*
 * Decompiled with CFR 0.152.
 */
package com.porzelt.confluence.darktheme.condition;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.plugin.descriptor.web.WebInterfaceContext;
import com.atlassian.confluence.plugin.descriptor.web.conditions.BaseConfluenceCondition;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.porzelt.confluence.darktheme.entity.Settings;
import com.porzelt.confluence.darktheme.utils.AoUtils;
import com.porzelt.confluence.darktheme.utils.LicenseUtils;

public class ShowUserNavCondition
extends BaseConfluenceCondition {
    private final ActiveObjects ao;
    private final PluginLicenseManager pluginLicenseManager;

    public ShowUserNavCondition(ActiveObjects activeObject, PluginLicenseManager pluginLicenseManager) {
        this.ao = activeObject;
        this.pluginLicenseManager = pluginLicenseManager;
    }

    public boolean shouldDisplay(WebInterfaceContext wic) {
        Boolean osSync;
        LicenseUtils licenseUtils = new LicenseUtils(this.pluginLicenseManager);
        if (!licenseUtils.HasValidLicense()) {
            return false;
        }
        AoUtils aoUtils = new AoUtils(this.ao);
        Settings selectedSetting = aoUtils.getUserSetting();
        Settings defaultSetting = aoUtils.getDefaultSetting();
        if (selectedSetting == null || !defaultSetting.getAllowUserSettings().booleanValue()) {
            selectedSetting = defaultSetting;
        }
        if ((osSync = selectedSetting.getSyncOsTheme()) != null && osSync.booleanValue()) {
            return false;
        }
        String location = selectedSetting.getLocation();
        return location != null && location.equals("profile");
    }
}

