/*
 * Decompiled with CFR 0.152.
 */
package com.nolddor.confluence.banner.service.rest;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.nolddor.confluence.banner.bean.BannerSettings;
import com.nolddor.confluence.banner.service.BannerSettingsService;
import com.nolddor.confluence.banner.utils.DateUtils;
import com.nolddor.confluence.banner.utils.LicenseUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import javax.inject.Inject;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/")
@Consumes(value={"application/json"})
@Produces(value={"application/json"})
public class RestAnnouncementBannerService {
    private final BannerSettingsService bannerSettingsService;
    private final LicenseUtils licenseUtils;

    @Inject
    public RestAnnouncementBannerService(BannerSettingsService bannerSettingsService, LicenseUtils licenseUtils) {
        this.bannerSettingsService = bannerSettingsService;
        this.licenseUtils = licenseUtils;
    }

    @GET
    @Path(value="settings")
    @UnrestrictedAccess
    public Response getSettings() {
        boolean isLicenseValid;
        boolean isAfterScheduled;
        BannerSettings settings = this.bannerSettingsService.getBannerSettings();
        ConfluenceUser caller = AuthenticatedUserThreadLocal.get();
        boolean isBannerInactive = "disable".equals(settings.getVisibility());
        boolean isBannerPrivate = "private".equals(settings.getVisibility());
        boolean isBannerExternal = "external".equals(settings.getVisibility());
        if (isBannerInactive || caller == null && isBannerPrivate || caller != null && isBannerExternal) {
            settings.setAnnouncement("");
        }
        DateTimeFormatter formatter = DateUtils.getFormatter();
        Optional<LocalDateTime> startDate = Optional.ofNullable(settings.getStartDate()).map(date -> LocalDateTime.parse(date, formatter));
        Optional<LocalDateTime> endDate = Optional.ofNullable(settings.getEndDate()).map(date -> LocalDateTime.parse(date, formatter));
        LocalDateTime now = LocalDateTime.now();
        boolean isBeforeScheduled = startDate.isPresent() && startDate.get().isAfter(now);
        boolean bl = isAfterScheduled = endDate.isPresent() && endDate.get().isBefore(now);
        if (isBeforeScheduled || isAfterScheduled) {
            settings.setAnnouncement("");
        }
        if (!(isLicenseValid = this.licenseUtils.isValidLicense())) {
            settings.setAnnouncement("");
        }
        return Response.ok((Object)settings).build();
    }
}

