/*
 * Decompiled with CFR 0.152.
 */
package com.nolddor.confluence.banner.service;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.nolddor.confluence.banner.bean.BannerSettings;
import java.util.Optional;
import javax.annotation.Nonnull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BannerSettingsService {
    private final PluginSettings pluginSettings;
    private static final String BASE_STORE_KEY = "banner.settings";
    private static final String ANNOUNCEMENT_STORE_KEY = "banner.settings.announcement";
    private static final String VISIBILITY_STORE_KEY = "banner.settings.visibility";
    private static final String STARTDATE_STORE_KEY = "banner.settings.startdate";
    private static final String ENDDATE_STORE_KEY = "banner.settings.enddate";
    private static final String PRINTABLE_STORE_KEY = "banner.settings.printable";
    private static final String CLOSABLE_STORE_KEY = "banner.settings.closable";
    private static final String CLOSABLE_DURATION_STORE_KEY = "banner.settings.closableDuration";
    private static final String ID_STORE_KEY = "banner.settings.id";
    public static final Integer DEFAULT_CLOSABLE_DURATION = 3;

    @Autowired
    BannerSettingsService(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
    }

    public BannerSettings getBannerSettings() {
        String rawAnnouncement = (String)this.pluginSettings.get(ANNOUNCEMENT_STORE_KEY);
        String rawVisibility = (String)this.pluginSettings.get(VISIBILITY_STORE_KEY);
        String rawPrintable = (String)this.pluginSettings.get(PRINTABLE_STORE_KEY);
        String startDate = (String)this.pluginSettings.get(STARTDATE_STORE_KEY);
        String endDate = (String)this.pluginSettings.get(ENDDATE_STORE_KEY);
        String rawClosable = (String)this.pluginSettings.get(CLOSABLE_STORE_KEY);
        String rawClosableDuration = (String)this.pluginSettings.get(CLOSABLE_DURATION_STORE_KEY);
        String rawBannerId = (String)this.pluginSettings.get(ID_STORE_KEY);
        String id = Optional.ofNullable(rawBannerId).orElse("");
        String announcement = Optional.ofNullable(rawAnnouncement).orElse("");
        String visibility = Optional.ofNullable(rawVisibility).orElse("disable");
        boolean printable = Optional.ofNullable(rawPrintable).map(Boolean::parseBoolean).orElse(true);
        boolean closable = Boolean.parseBoolean(rawClosable);
        Integer closableDuration = Optional.ofNullable(rawClosableDuration).map(Integer::parseInt).orElse(DEFAULT_CLOSABLE_DURATION);
        return BannerSettings.builder().id(id).announcement(announcement).visibility(visibility).startDate(startDate).endDate(endDate).printable(printable).closable(closable).closableDuration(closableDuration).build();
    }

    public void setBannerSettings(@Nonnull BannerSettings banner) {
        this.pluginSettings.put(ID_STORE_KEY, (Object)banner.getId());
        this.pluginSettings.put(ANNOUNCEMENT_STORE_KEY, (Object)banner.getAnnouncement());
        this.pluginSettings.put(VISIBILITY_STORE_KEY, (Object)banner.getVisibility());
        this.pluginSettings.put(STARTDATE_STORE_KEY, (Object)banner.getStartDate());
        this.pluginSettings.put(ENDDATE_STORE_KEY, (Object)banner.getEndDate());
        this.pluginSettings.put(PRINTABLE_STORE_KEY, (Object)Boolean.toString(banner.isPrintable()));
        this.pluginSettings.put(CLOSABLE_STORE_KEY, (Object)Boolean.toString(banner.isClosable()));
        this.pluginSettings.put(CLOSABLE_DURATION_STORE_KEY, (Object)banner.getClosableDuration().toString());
    }
}

