/*
 * Decompiled with CFR 0.152.
 */
package com.nolddor.confluence.banner.bean;

import com.atlassian.confluence.velocity.htmlsafe.HtmlSafe;
import java.util.UUID;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement
public class BannerSettings {
    private String id;
    private String announcement;
    private String visibility;
    private String startDate;
    private String endDate;
    private boolean printable;
    private boolean closable;
    private Integer closableDuration;

    BannerSettings(String id, String announcement, String visibility, String startDate, String endDate, boolean printable, boolean closable, Integer closableDuration) {
        this.id = id;
        this.announcement = announcement;
        this.visibility = visibility;
        this.startDate = startDate;
        this.endDate = endDate;
        this.printable = printable;
        this.closable = closable;
        this.closableDuration = closableDuration;
    }

    @XmlElement
    public String getId() {
        return this.id;
    }

    @HtmlSafe
    @XmlElement
    public String getAnnouncement() {
        return this.announcement;
    }

    @XmlElement
    public String getVisibility() {
        return this.visibility;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public boolean isPrintable() {
        return this.printable;
    }

    public boolean isClosable() {
        return this.closable;
    }

    @XmlElement
    public Integer getClosableDuration() {
        return this.closableDuration;
    }

    public void setId(String uuid) {
        this.id = uuid;
    }

    public void setAnnouncement(String announcement) {
        this.announcement = announcement;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public void setPrintable(boolean printable) {
        this.printable = printable;
    }

    public void setClosable(boolean closable) {
        this.closable = closable;
    }

    public void setClosableDuration(Integer closableDuration) {
        this.closableDuration = closableDuration;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static Builder builder(BannerSettings settings) {
        return new Builder(settings);
    }

    public static class Builder {
        private String id;
        private String announcement;
        private String visibility;
        private String startDate;
        private String endDate;
        private boolean printable;
        private boolean closable;
        private Integer closableDuration;

        private Builder() {
            this.id = UUID.randomUUID().toString();
        }

        private Builder(BannerSettings settings) {
            this.id = settings.id;
            this.announcement = settings.announcement;
            this.visibility = settings.visibility;
            this.startDate = settings.startDate;
            this.endDate = settings.endDate;
            this.printable = settings.printable;
            this.closable = settings.closable;
            this.closableDuration = settings.closableDuration;
        }

        public BannerSettings build() {
            return new BannerSettings(this.id, this.announcement, this.visibility, this.startDate, this.endDate, this.printable, this.closable, this.closableDuration);
        }

        public Builder id(String id) {
            this.id = id;
            return this;
        }

        public Builder announcement(String announcement) {
            this.announcement = announcement;
            return this;
        }

        public Builder visibility(String visibility) {
            this.visibility = visibility;
            return this;
        }

        public Builder startDate(String startDate) {
            this.startDate = startDate;
            return this;
        }

        public Builder endDate(String endDate) {
            this.endDate = endDate;
            return this;
        }

        public Builder printable(boolean printable) {
            this.printable = printable;
            return this;
        }

        public Builder closable(boolean closable) {
            this.closable = closable;
            return this;
        }

        public Builder closableDuration(Integer closableDuration) {
            this.closableDuration = closableDuration;
            return this;
        }
    }
}

