/*
 * Decompiled with CFR 0.152.
 */
package com.nolddor.confluence.banner.service.rest;

import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugins.rest.common.security.AnonymousAllowed;
import com.nolddor.confluence.banner.bean.BannerSettings;
import com.nolddor.confluence.banner.service.BannerSettingsService;
import com.nolddor.confluence.banner.utils.DateUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;

@Path(value="/")
@Consumes(value={"application/json", "application/xml"})
@Produces(value={"application/json", "application/xml"})
public class RestAnnouncementBannerService {
    private final BannerSettingsService bannerSettingsService;

    public RestAnnouncementBannerService(BannerSettingsService bannerSettingsService) {
        this.bannerSettingsService = bannerSettingsService;
    }

    @GET
    @Path(value="settings")
    @AnonymousAllowed
    public Response getSettings() {
        boolean isAfterScheduled;
        BannerSettings settings = this.bannerSettingsService.getBannerSettings();
        ConfluenceUser caller = AuthenticatedUserThreadLocal.get();
        boolean isBannerInactive = "disable".equals(settings.getVisibility());
        boolean isBannerPrivate = "private".equals(settings.getVisibility());
        boolean isBannerExternal = "external".equals(settings.getVisibility());
        if (isBannerInactive || caller == null && isBannerPrivate || caller != null && isBannerExternal) {
            settings.setAnnouncement("");
        }
        DateTimeFormatter formatter = DateUtils.getFormatter();
        Optional<LocalDateTime> startDate = Optional.ofNullable(settings.getStartDate()).map(date -> LocalDateTime.parse(date, formatter));
        Optional<LocalDateTime> endDate = Optional.ofNullable(settings.getEndDate()).map(date -> LocalDateTime.parse(date, formatter));
        LocalDateTime now = LocalDateTime.now();
        boolean isBeforeScheduled = startDate.isPresent() && startDate.get().isAfter(now);
        boolean bl = isAfterScheduled = endDate.isPresent() && endDate.get().isBefore(now);
        if (isBeforeScheduled || isAfterScheduled) {
            settings.setAnnouncement("");
        }
        return Response.ok((Object)settings).build();
    }
}

