/*
 * Decompiled with CFR 0.152.
 */
package com.nolddor.confluence.banner.action;

import com.atlassian.confluence.core.ConfluenceActionSupport;
import com.nolddor.confluence.banner.bean.BannerSettings;
import com.nolddor.confluence.banner.service.BannerSettingsService;
import com.nolddor.confluence.banner.service.BannerVisibilityProvider;
import com.nolddor.confluence.banner.service.audit.BannerAuditService;
import com.nolddor.confluence.banner.utils.DateUtils;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

public class EditAnnouncementBannerAction
extends ConfluenceActionSupport {
    private static final long serialVersionUID = 4522899130068616391L;
    @Autowired
    private transient BannerVisibilityProvider visibilityProvider;
    @Autowired
    private transient BannerSettingsService bannerSettingsService;
    @Autowired
    private transient BannerAuditService bannerAuditService;
    private transient String announcement;
    private transient String visibility;
    private transient String startDate;
    private transient String endDate;
    private transient boolean printableBanner;
    private transient boolean closableBanner;
    private transient String closableDuration;

    public String getAnnouncement() {
        return this.announcement;
    }

    public void setAnnouncement(String announcement) {
        this.announcement = announcement;
    }

    public String getVisibility() {
        return this.visibility;
    }

    public void setVisibility(String visibility) {
        this.visibility = visibility;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = StringUtils.trimToNull((String)startDate);
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = StringUtils.trimToNull((String)endDate);
    }

    public boolean isPrintableBanner() {
        return this.printableBanner;
    }

    public void setPrintableBanner(boolean printable) {
        this.printableBanner = printable;
    }

    public boolean isClosableBanner() {
        return this.closableBanner;
    }

    public void setClosableBanner(boolean closable) {
        this.closableBanner = closable;
    }

    public String getClosableDuration() {
        return this.closableDuration;
    }

    public void setClosableDuration(String closableDuration) {
        this.closableDuration = StringUtils.trimToNull((String)closableDuration);
    }

    public List<String> getBannerVisibilites() {
        return this.visibilityProvider.getBannerVisibilites();
    }

    private BannerSettings getBannerSettings() {
        return BannerSettings.builder().announcement(this.announcement).visibility(this.visibility).startDate(this.startDate).endDate(this.endDate).printable(this.printableBanner).closable(this.closableBanner).closableDuration(Optional.ofNullable(this.closableDuration).map(Integer::parseInt).orElse(null)).build();
    }

    public String doDefault() throws Exception {
        BannerSettings originalSettings = this.bannerSettingsService.getBannerSettings();
        this.announcement = originalSettings.getAnnouncement();
        this.visibility = originalSettings.getVisibility();
        this.startDate = originalSettings.getStartDate();
        this.endDate = originalSettings.getEndDate();
        this.printableBanner = originalSettings.isPrintable();
        this.closableBanner = originalSettings.isClosable();
        this.closableDuration = Optional.ofNullable(originalSettings.getClosableDuration()).map(Object::toString).orElse(null);
        return super.doDefault();
    }

    public void validate() {
        if (this.announcement == null) {
            this.addFieldError("announcement", this.getText("banner.announcement.error"));
        }
        if (!this.getBannerVisibilites().contains(this.visibility)) {
            this.addFieldError("visibility", this.getText("banner.visibility.error"));
        }
        try {
            DateTimeFormatter formatter = DateUtils.getFormatter();
            LocalDateTime start = Optional.ofNullable(this.startDate).map(date -> LocalDateTime.parse(date, formatter)).orElse(null);
            LocalDateTime end = Optional.ofNullable(this.endDate).map(date -> LocalDateTime.parse(date, formatter)).orElse(null);
            if (start != null && end != null && start.isAfter(end)) {
                this.addFieldError("scheduling", this.getText("banner.scheduling.startdate.error"));
            }
        }
        catch (DateTimeParseException e) {
            this.addFieldError("scheduling", this.getText("banner.scheduling.error"));
        }
        if (this.closableDuration == null || !this.closableDuration.matches("^[1-9][0-9]{0,3}$")) {
            if (this.closableBanner) {
                this.addFieldError("closableDuration", this.getText("banner.advanced.option.closable-duration.error"));
            } else {
                this.closableDuration = BannerSettingsService.DEFAULT_CLOSABLE_DURATION.toString();
            }
        }
        if (this.hasFieldErrors()) {
            this.messageHolder.addActionError(this.getText("banner.message.confignotsaved"));
        }
    }

    public String execute() throws Exception {
        BannerSettings newSettings = this.getBannerSettings();
        BannerSettings oldSettings = this.bannerSettingsService.getBannerSettings();
        this.bannerSettingsService.setBannerSettings(newSettings);
        this.bannerAuditService.storeChange(oldSettings, newSettings);
        this.messageHolder.addActionSuccess("banner.message.configsaved", new Object[0]);
        return "success";
    }
}

