/*
 * Decompiled with CFR 0.152.
 */
package com.nolddor.confluence.banner.service.audit;

import com.atlassian.confluence.api.model.audit.AuditRecord;
import com.atlassian.confluence.api.model.people.User;
import com.atlassian.confluence.api.service.audit.AuditService;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.util.RequestCacheThreadLocal;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.google.common.base.Joiner;
import com.nolddor.confluence.banner.bean.BannerSettings;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class BannerAuditService {
    @ComponentImport
    private final AuditService auditService;

    @Autowired
    public BannerAuditService(AuditService auditService) {
        this.auditService = auditService;
    }

    public void storeChange(BannerSettings oldValue, BannerSettings newValue) {
        String category = "Global Administration";
        String summary = "Announcement Banner updated";
        User author = this.getAuthor();
        String remoteAddress = this.getRemoteAddress();
        AuditRecord record = new AuditRecord.Builder().category(category).summary(summary).remoteAddress(remoteAddress).author(author).build();
        this.auditService.storeRecord(record);
    }

    protected User getAuthor() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user != null) {
            return new User(null, user.getName(), user.getFullName(), user.getKey());
        }
        return RequestCacheThreadLocal.getRemoteAddress() == null ? this.systemUser() : this.anonymousUser();
    }

    private User systemUser() {
        return new User(null, "", "System", "");
    }

    private User anonymousUser() {
        return new User(null, "", "Anonymous", "");
    }

    protected String getRemoteAddress() {
        String proxyAddresses = RequestCacheThreadLocal.getXForwardedFor();
        String remoteAddress = RequestCacheThreadLocal.getRemoteAddress();
        if (proxyAddresses == null) {
            return remoteAddress;
        }
        return Joiner.on((char)',').join((Object)proxyAddresses, (Object)remoteAddress, new Object[0]);
    }
}

