/*
 * Decompiled with CFR 0.152.
 */
package com.mohamicorp.confluence.macro.github.upgrade;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.Message;
import com.atlassian.sal.api.upgrade.PluginUpgradeTask;
import com.mohamicorp.confluence.macro.github.model.GithubToken;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import javax.inject.Inject;
import javax.inject.Named;

@Named
@ExportAsService
public class UpgradeTask
implements PluginUpgradeTask {
    private final ActiveObjects ao;

    @Inject
    public UpgradeTask(@ComponentImport ActiveObjects ao) {
        this.ao = ao;
    }

    public int getBuildNumber() {
        return 2;
    }

    public String getShortDescription() {
        return "Converting github tokens to use proper github.com url.";
    }

    public Collection<Message> doUpgrade() throws Exception {
        this.updateGithubTokens();
        return Collections.emptyList();
    }

    public String getPluginKey() {
        return "com.mohamicorp.confluence.macro.github.mohamicorp-github-macros";
    }

    private void updateGithubTokens() {
        this.ao.executeInTransaction(() -> {
            for (GithubToken githubToken : (GithubToken[])this.ao.find(GithubToken.class)) {
                String url = githubToken.getUrl();
                githubToken.setUrl(this.sanitizeUrl(url));
                githubToken.save();
            }
            return null;
        });
    }

    private String sanitizeUrl(String stringUrl) {
        URL url;
        try {
            url = new URL(stringUrl);
        }
        catch (MalformedURLException e) {
            return stringUrl;
        }
        String host = url.getHost();
        if (host.equals("github.com")) {
            return "github.com";
        }
        return stringUrl;
    }
}

