/*
 * Decompiled with CFR 0.152.
 */
package com.mohamicorp.confluence.macro.github.migration;

import com.atlassian.migration.app.AccessScope;
import com.atlassian.migration.app.gateway.AppCloudForgeMigrationGateway;
import com.atlassian.migration.app.gateway.MigrationDetailsV1;
import com.atlassian.migration.app.listener.DiscoverableForgeListener;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mohamicorp.confluence.macro.github.SettingsService;
import com.mohamicorp.confluence.macro.github.model.GithubToken;
import com.mohamicorp.confluence.macro.github.service.TokenEntityService;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@ExportAsService
@Component
public class MigrationListenerComponentImpl
implements DiscoverableForgeListener {
    private static final Logger log = LoggerFactory.getLogger(MigrationListenerComponentImpl.class);
    private final Gson gson = new Gson();
    private final TokenEntityService tokenEntityService;
    private final SettingsService settingsService;

    @Inject
    public MigrationListenerComponentImpl(TokenEntityService tokenEntityService, SettingsService settingsService) {
        this.tokenEntityService = tokenEntityService;
        this.settingsService = settingsService;
    }

    public String getCloudAppKey() {
        log.info("getCloudAppKey : {}", (Object)"com.mohamicorp.confluence.macro.github.mohamicorp-github-macros");
        return "com.mohamicorp.confluence.macro.github.mohamicorp-github-macros";
    }

    public Set<AccessScope> getDataAccessScopes() {
        return Stream.of(AccessScope.APP_DATA_OTHER, AccessScope.PRODUCT_DATA_OTHER, AccessScope.MIGRATION_TRACING_IDENTITY, AccessScope.MIGRATION_TRACING_PRODUCT).collect(Collectors.toCollection(HashSet::new));
    }

    public UUID getForgeAppId() {
        return UUID.fromString("3b42595b-67b2-44c4-96e6-09a22261ef0d");
    }

    public String getForgeEnvironmentName() {
        return "production";
    }

    public void onStartAppMigration(AppCloudForgeMigrationGateway forgeMigrationGateway, MigrationDetailsV1 migrationDetails) {
        log.info("GMFC data migration started. Migration context summary: " + this.gson.toJson((Object)migrationDetails));
        try {
            JsonObject tokensData = new JsonObject();
            tokensData.addProperty("resolvePrivateUrls", Boolean.valueOf(this.settingsService.getResolvePrivateUrls()));
            tokensData.addProperty("globalLines", this.settingsService.getGlobalLimitLines());
            tokensData.addProperty("tokens", this.buildAppDataToMigrate());
            String jsonPayload = new Gson().toJson((JsonElement)tokensData);
            try (OutputStream appDataStream = forgeMigrationGateway.createAppData(forgeMigrationGateway.getTransferId());){
                appDataStream.write(jsonPayload.getBytes());
            }
            forgeMigrationGateway.completeExport();
            log.info("GMFC data migration completed from DC");
        }
        catch (Exception e) {
            String errmsg = e.getMessage() != null ? e.getMessage() : "null or Unknown error";
            log.error("GMFC app data migration Exception: " + errmsg, (Throwable)e);
        }
    }

    public String buildAppDataToMigrate() {
        ArrayList<JsonObject> tokensData = new ArrayList<JsonObject>();
        List<GithubToken> tokens = this.tokenEntityService.getTokens();
        if (tokens != null) {
            for (GithubToken token : tokens) {
                JsonObject tokenData = new JsonObject();
                tokenData.addProperty("tokenName", token.getName());
                tokenData.addProperty("token", token.getToken());
                tokenData.addProperty("githubURL", token.getUrl());
                tokenData.addProperty("tokenId", (Number)token.getID());
                tokensData.add(tokenData);
            }
        }
        return new Gson().toJson(tokensData);
    }
}

