/*
 * Decompiled with CFR 0.152.
 */
package com.mohamicorp.confluence.macro.github.rest;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.user.User;
import com.google.common.collect.ImmutableMap;
import com.mohamicorp.confluence.macro.github.model.GithubToken;
import com.mohamicorp.confluence.macro.github.service.TokenEntityService;
import java.io.IOException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.SocketTimeoutException;
import java.net.URL;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.net.ssl.SSLException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="token")
public class GithubTokenResource {
    private static final Logger log = LoggerFactory.getLogger(GithubTokenResource.class);
    private final TokenEntityService tokenService;
    private static final String GITHUB_COM = "github.com";
    private static final String PROTOCOL_HTTP = "http://";
    private static final String PROTOCOL_HTTPS = "https://";
    static final String TEMPLATE_ERROR_INVALID = "github.macro.config.validation.url.error.invalid";
    static final String TEMPLATE_ERROR_UNKNOWN = "github.macro.config.validation.url.error.unknown";
    static final String TEMPLATE_ERROR_CERT = "github.macro.config.validation.url.error.cert";
    static final String TEMPLATE_ERROR_TIMEOUT = "github.macro.config.validation.url.error.timeout";
    private final ActiveObjects activeObjects;
    private final PermissionManager permissionManager;
    private final I18nResolver i18nResolver;

    @Inject
    public GithubTokenResource(@ComponentImport ActiveObjects activeObjects, @ComponentImport PermissionManager permissionManager, @ComponentImport I18nResolver i18nResolver, TokenEntityService tokenService) {
        this.tokenService = tokenService;
        this.activeObjects = activeObjects;
        this.permissionManager = permissionManager;
        this.i18nResolver = i18nResolver;
    }

    @GET
    @Produces(value={"application/json"})
    public List<GithubTokenDto> getTokens() {
        log.info("Tokens : {}", (Object)this.tokenService.getTokens().size());
        System.out.println("Tokens : " + this.tokenService.getTokens().size());
        ArrayList<GithubTokenDto> tokens = new ArrayList<GithubTokenDto>();
        List<GithubToken> tokenEntityList = this.tokenService.getTokens();
        for (GithubToken githubToken : tokenEntityList) {
            tokens.add(new GithubTokenDto(githubToken.getID(), githubToken.getName(), null, githubToken.getUrl()));
        }
        return tokens;
    }

    @GET
    @Path(value="validate-url")
    @Produces(value={"application/json"})
    public Response validateToken(@QueryParam(value="url") String urlParam) {
        String urlStr = urlParam;
        CharSequence[] protocols = new String[]{PROTOCOL_HTTP, PROTOCOL_HTTPS};
        if (!StringUtils.startsWithAny((CharSequence)urlStr, (CharSequence[])protocols)) {
            urlStr = PROTOCOL_HTTP + urlStr;
        }
        try {
            URL url = new URL(urlStr);
            HttpURLConnection connection = (HttpURLConnection)url.openConnection();
            UrlValidationResponse result = this.checkConnection(connection);
            if (!result.isValid()) {
                log.info("Failed to validate url " + urlStr + ": " + result.getError());
            }
            return Response.ok((Object)result).build();
        }
        catch (IOException e) {
            return Response.ok((Object)new UrlValidationResponse(false, null, this.i18nResolver.getText(TEMPLATE_ERROR_INVALID))).build();
        }
    }

    UrlValidationResponse checkConnection(HttpURLConnection connection) {
        boolean valid = false;
        String suggestedUrl = null;
        String error = null;
        try {
            connection.connect();
            int code = connection.getResponseCode();
            if (code > 299) {
                if (code < 399) {
                    suggestedUrl = connection.getHeaderField("Location");
                } else {
                    error = connection.getResponseMessage();
                }
            } else {
                valid = true;
            }
        }
        catch (UnknownHostException e) {
            error = this.i18nResolver.getText(TEMPLATE_ERROR_UNKNOWN);
        }
        catch (SSLException e) {
            error = this.i18nResolver.getText(TEMPLATE_ERROR_CERT);
        }
        catch (SocketTimeoutException e) {
            error = this.i18nResolver.getText(TEMPLATE_ERROR_TIMEOUT);
        }
        catch (IOException ioe) {
            error = ioe.getMessage();
        }
        return new UrlValidationResponse(valid, suggestedUrl, error);
    }

    @DELETE
    public void deleteToken(@QueryParam(value="id") Integer id) {
        this.enforcePermissions();
        this.activeObjects.executeInTransaction(() -> {
            GithubToken githubToken = (GithubToken)this.activeObjects.get(GithubToken.class, (Object)id);
            this.activeObjects.delete(new RawEntity[]{githubToken});
            return null;
        });
    }

    @PUT
    @Consumes(value={"application/json"})
    public void updateToken(GithubTokenDto dto) throws Exception {
        this.enforcePermissions();
        this.activeObjects.executeInTransaction(() -> {
            GithubToken githubToken = (GithubToken)this.activeObjects.get(GithubToken.class, (Object)dto.getId());
            githubToken.setUrl(dto.getUrl());
            githubToken.setName(dto.getName());
            githubToken.save();
            return null;
        });
    }

    @POST
    @Consumes(value={"application/json"})
    public void addToken(GithubTokenDto dto) throws Exception {
        this.enforcePermissions();
        this.activeObjects.executeInTransaction(() -> {
            GithubToken githubToken = (GithubToken)this.activeObjects.create(GithubToken.class, (Map)new ImmutableMap.Builder().put((Object)"TOKEN", (Object)dto.getToken()).put((Object)"NAME", (Object)dto.getName()).put((Object)"URL", (Object)this.sanitizeUrl(dto.getUrl())).build());
            githubToken.save();
            return null;
        });
    }

    private void enforcePermissions() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            throw new RuntimeException("Invalid permissions");
        }
    }

    private String sanitizeUrl(String stringUrl) {
        URL url;
        try {
            url = new URL(stringUrl);
        }
        catch (MalformedURLException e) {
            return stringUrl;
        }
        String host = url.getHost();
        if (host.equals(GITHUB_COM)) {
            return GITHUB_COM;
        }
        return stringUrl;
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class GithubTokenDto {
        private Integer id;
        private String name;
        private String token;
        private String url;

        public GithubTokenDto() {
        }

        public GithubTokenDto(Integer id, String name, String token, String url) {
            this.id = id;
            this.name = name;
            this.token = token;
            this.url = url;
        }

        public Integer getId() {
            return this.id;
        }

        public String getName() {
            return this.name;
        }

        public String getToken() {
            return this.token;
        }

        public String getUrl() {
            return this.url;
        }

        public void setId(Integer id) {
            this.id = id;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setToken(String token) {
            this.token = token;
        }

        public void setUrl(String url) {
            this.url = url;
        }
    }

    @XmlAccessorType(value=XmlAccessType.FIELD)
    public static class UrlValidationResponse {
        private final boolean valid;
        private final String suggestion;
        private final String error;

        public UrlValidationResponse(boolean valid, String suggestion, String error) {
            this.valid = valid;
            this.suggestion = suggestion;
            this.error = error;
        }

        public boolean isValid() {
            return this.valid;
        }

        public String getError() {
            return this.error;
        }

        public String getSuggestion() {
            return this.suggestion;
        }
    }
}

