/*
 * Decompiled with CFR 0.152.
 */
package com.mohamicorp.confluence.macro.github;

import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;

@Named
public class SettingsService {
    private static final String RESOLVE_PRIVATE_URLS_KEY = "resolve-private-urls";
    private static final String GLOBAL_LIMIT_LINES_KEY = "global-limit-lines";
    private final PluginSettingsFactory pluginSettingsFactory;

    @Inject
    public SettingsService(@ComponentImport PluginSettingsFactory pluginSettingsFactory) {
        this.pluginSettingsFactory = pluginSettingsFactory;
    }

    public boolean getResolvePrivateUrls() {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        Object value = pluginSettings.get(RESOLVE_PRIVATE_URLS_KEY);
        if (value == null) {
            this.setResolvePrivateUrls(true);
            return true;
        }
        return Boolean.parseBoolean((String)value);
    }

    public void setResolvePrivateUrls(boolean resolvePrivateUrls) {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put(RESOLVE_PRIVATE_URLS_KEY, (Object)Boolean.toString(resolvePrivateUrls));
    }

    public String getGlobalLimitLines() {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        String value = (String)pluginSettings.get(GLOBAL_LIMIT_LINES_KEY);
        if (StringUtils.isEmpty((CharSequence)value)) {
            this.setGlobalLimitLines("0");
            return "0";
        }
        return value;
    }

    public void setGlobalLimitLines(String lines) {
        PluginSettings pluginSettings = this.pluginSettingsFactory.createGlobalSettings();
        pluginSettings.put(GLOBAL_LIMIT_LINES_KEY, (Object)lines);
    }
}

