/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

AJS.bind("init.rte", function () {
    var tokenEndPoint = AJS.contextPath()  + "/rest/github-macro/1.0/token";
    
    var MacroJsOverrideForTokenField = function () {};

    MacroJsOverrideForTokenField.prototype.beforeParamsSet = function (params) {
        var $tokenSelect = $("#macro-browser-dialog #macro-param-token");
        var existingTokenParam = params.token;

        if (existingTokenParam) {
            //set temporary value
            $tokenSelect.html('<option value="' + existingTokenParam + '">' + existingTokenParam + '</option>')
        }
        
        AJS.$.ajax({
            url: tokenEndPoint
        }).done(function (response) {
            var options = [];
            AJS.$.each(response, function (index, token) {
                var selected = existingTokenParam && (token.id === parseInt(existingTokenParam)) ? "selected " : "";
                

                options.push('<option ' + selected + 'value="' + token.id + '">' + token.name + '</option>');
            });
            $tokenSelect.html(options.join(''));

        });
        return params;
    }
    
    AJS.MacroBrowser.setMacroJsOverride("github-markdown-macro", new MacroJsOverrideForTokenField());
    AJS.MacroBrowser.setMacroJsOverride("github-issues-macro", new MacroJsOverrideForTokenField());
    AJS.MacroBrowser.setMacroJsOverride("github-file-macro", new MacroJsOverrideForTokenField());
    AJS.MacroBrowser.setMacroJsOverride("github-pullrequest-macro", new MacroJsOverrideForTokenField());
});
