/*
 * Decompiled with CFR 0.152.
 */
package com.mohamicorp.confluence.macro.github.servlet;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.soy.renderer.SoyException;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.user.User;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.mohamicorp.confluence.macro.github.SettingsService;
import java.io.IOException;
import java.net.URI;
import java.util.HashMap;
import javax.inject.Inject;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class ConfigServlet
extends HttpServlet {
    private static final String TEMPLATE_KEY = "com.mohamicorp.confluence.macro.github.mohamicorp-github-macros:config-page";
    private static final String TEMPLATE = "mohamicorp.github.macros.config";
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final LoginUriProvider loginUriProvider;
    private final PermissionManager permissionManager;
    private final PageBuilderService pageBuilderService;
    private final SettingsService settingsService;

    @Inject
    public ConfigServlet(@ComponentImport SoyTemplateRenderer soyTemplateRenderer, @ComponentImport LoginUriProvider loginUriProvider, @ComponentImport PermissionManager permissionManager, @ComponentImport PageBuilderService pageBuilderService, SettingsService settingsService) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.loginUriProvider = loginUriProvider;
        this.permissionManager = permissionManager;
        this.pageBuilderService = pageBuilderService;
        this.settingsService = settingsService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.enforcePermissions(req, resp);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("resolvePrivateUrls", this.settingsService.getResolvePrivateUrls());
        data.put("globalLimitLines", this.settingsService.getGlobalLimitLines());
        resp.setContentType("text/html;charset=UTF-8");
        try {
            this.pageBuilderService.assembler().resources().requireWebResource("com.mohamicorp.confluence.macro.github.mohamicorp-github-macros:config-resources");
            this.soyTemplateRenderer.render((Appendable)resp.getWriter(), TEMPLATE_KEY, TEMPLATE, data);
        }
        catch (SoyException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException) {
                throw (IOException)cause;
            }
            throw new ServletException((Throwable)e);
        }
    }

    private void enforcePermissions(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (user == null) {
            resp.sendRedirect(this.loginUriProvider.getLoginUri(URI.create(req.getRequestURL().toString())).toASCIIString());
            return;
        }
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            resp.sendError(404);
            return;
        }
    }
}

