/*
 * Decompiled with CFR 0.152.
 */
package com.mohamicorp.confluence.macro.github.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.mohamicorp.confluence.macro.github.GithubService;
import com.mohamicorp.confluence.macro.github.LicenseManager;
import com.mohamicorp.confluence.macro.github.macro.GithubMacro;
import java.util.Map;
import javax.inject.Inject;

public class GithubFile
extends GithubMacro {
    private static final String TEMPLATE_KEY = "com.mohamicorp.confluence.macro.github.mohamicorp-github-macros:github-file-macro-template";
    private static final String RESOURCE_KEY = "com.mohamicorp.confluence.macro.github.mohamicorp-github-macros:github-file-resources";
    private static final String TEMPLATE = "mohamicorp.github.macros.file";
    private static final String LINES = "lines";
    private static final String HIDE_LINES = "hideLines";

    @Inject
    public GithubFile(GithubService githubService, LicenseManager licenseManager, @ComponentImport PageBuilderService pageBuilderService, @ComponentImport I18nResolver i18nResolver, @ComponentImport SoyTemplateRenderer soyTemplateRenderer) {
        super(soyTemplateRenderer, pageBuilderService, licenseManager, i18nResolver, githubService);
    }

    @Override
    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        super.execute(parameters, body, conversionContext);
        String user = parameters.get("user");
        String branch = parameters.getOrDefault("branch", "master");
        String repo = parameters.get("repo");
        String path = parameters.get("path");
        String tokenParam = parameters.get("token");
        Integer token = tokenParam == null ? null : Integer.valueOf(Integer.parseInt(tokenParam));
        String lines = parameters.get(LINES);
        boolean hideLines = Boolean.parseBoolean(parameters.get(HIDE_LINES));
        return super.getMacroData(RESOURCE_KEY, TEMPLATE_KEY, TEMPLATE, () -> this.githubService.getFileContext(user, branch, repo, path, token, lines, hideLines));
    }
}

