/*
 * Copyright (c) 2022 Appfire Technologies, LLC.
 * All rights reserved.
 *
 * This software is licensed under the provisions of the "Appfire EULA"
 * (https://appfire.com/eula/) as well as under the provisions of
 * the "Standard EULA" from the "Atlassian Marketplace Terms of Use" as a "Marketplace Product"
 * (http://www.atlassian.com/licensing/marketplace/termsofuse).
 *
 * See the LICENSE file for more details.
 */

AJS.$(function(){
    function doValidation(){
        if (!!$username.val() && !!$token.val()) {
            $submitButton.removeAttr("aria-disabled");
        } else {
            $submitButton.attr("aria-disabled", true);
        }
    }
    
    function loadTokens(){
        AJS.$.ajax({
            url : AJS.contextPath() + "/rest/github-macro/1.0/token.json",
            headers : {
                "X-Atlassian-Token": "no-check"
            }
        }).done(function(response) {
            $tokenTableBody.html(mohamicorp.github.macros.tokenTable({
                tokens : response
            }))
        });
        
    }
    function validateUrl(url, callback){
        AJS.$('#ge-url-error').html('');
        AJS.$.ajax({
            url : AJS.contextPath() + "/rest/github-macro/1.0/token/validate-url.json?url=" + url,
            headers : {
                "X-Atlassian-Token": "no-check"
            }
        }).done(function(response) {
            if (response.valid) {
                callback();
            } else {
                if (response.suggestion) {
                    AJS.$('#ge-url-description').html(AJS.I18n.getText('github.macro.config.validation.url.suggested'));
                    $baseUrl.val(response.suggestion);
                }
                AJS.$('#ge-url-error').html(response.error);
            }
        });
    }
    function persistToken(username, token, baseUrl){
        var data = tokenId ? {
                id : tokenId,
                name : username,
                url : baseUrl
                
            }:{
                name : username,
                token : token,
                url : baseUrl
            };

        AJS.$.ajax({
            type : tokenId?'PUT':'POST',
            contentType: 'application/json',
            url : AJS.contextPath() + "/rest/github-macro/1.0/token",
            headers : {
                "X-Atlassian-Token": "no-check"
            },
            data : JSON.stringify(data)
        }).done(function(){
            AJS.dialog2(dialogId).hide();
            loadTokens();
        });
        
    }
    
    function startEdit(id, name, url){
        $token.parents(".field-group").hide();
        tokenId = id;

        $username.val(name);
        $baseUrl.val(url);

        $submitButton.removeAttr("aria-disabled");
        $submitButton.text(AJS.I18n.getText('github.macro.config.update'));

        AJS.$('#ge-url-description').html(AJS.I18n.getText('github.macro.config.github.url.description'));
        
        AJS.$(dialogId + " .aui-dialog2-header-main").html(AJS.I18n.getText('github.macro.config.start.edit.token'));

        AJS.dialog2(dialogId).show();
    }
    
    function startAdd(){
        $token.parents(".field-group").show();
        tokenId = undefined;
        $username.val("");
        $token.val("");
        $baseUrl.val("");

        $submitButton.attr("aria-disabled", true);
        $submitButton.text(AJS.I18n.getText('github.macro.config.add'));

        AJS.$('#ge-url-description').html(AJS.I18n.getText('github.macro.config.github.url.description'));
        AJS.$('#ge-url-error').html('');

        AJS.$(dialogId + " .aui-dialog2-header-main").html(AJS.I18n.getText('github.macro.config.start.new.token'));

        AJS.dialog2(dialogId).show();
    }
    var dialogId = "#add-token-dialog",
        tokenId,
    
        $username = AJS.$("#username"),
        $token = AJS.$("#token"),
        $baseUrl = AJS.$("#baseUrl"),
        
        $submitButton = AJS.$("#dialog-submit-button"),
        $tokenTableBody = AJS.$("#account-table-github tbody");
        

    AJS.$("#add-token").click(function() {
        startAdd();
    });

    AJS.$("#dialog-close-button").click(function(e) {
        e.preventDefault();
        AJS.dialog2(dialogId).hide();
    });
    
    $username.on("paste keyup", doValidation);
    $token.on("paste keyup", doValidation);
   
    $submitButton.click(function(e) {
        if ($submitButton.attr("aria-disabled")){
            return;
        }
        e.preventDefault();
        
        var username = $username.val(),
            token = $token.val(),
            baseUrl = $baseUrl.val();
            
        if (baseUrl) {
            validateUrl(baseUrl, function(){
                persistToken(username, token, baseUrl);
            });
        } else {
            persistToken(username, token, baseUrl);
        }

    });     
    
    loadTokens();
    
    $tokenTableBody.click(function(e) {
        var $target = AJS.$(e.target);
        if ($target.is('.delete-button')) {
            var id = $target.parent().parent().data('id');
            AJS.$.ajax({
                type : 'DELETE',
                url : AJS.contextPath() + "/rest/github-macro/1.0/token.json?id=" + id,
                headers : {
                    "X-Atlassian-Token": "no-check"
                }
            }).done(function(response) {
                loadTokens();
            });
            
        }
        if ($target.is('.token-name')) {
            e.preventDefault();
            var row = $target.parents("tr"),
                id = row.data('id'),
                name = row.data('name'),
                url = row.data('url');
                
            startEdit(id, name, url)
        }
    });

    AJS.$('#resolve-private-urls').click(function (e) {
        AJS.$.ajax({
            type : e.target.checked ? 'PUT' : 'DELETE',
            url : AJS.contextPath() + "/rest/github-macro/1.0/settings/resolve-private-urls",
            headers : {
                "X-Atlassian-Token": "no-check"
            }
        });
    });
    const VALIDATION_CSS_CLASS = "appfire-field-validation";
    AJS.$('#update-limit-lines').click(function (e) {
        var statusField = '<div id="statusDiv"><span class="statusupdate">Configuration saved!</span></div>';
        $('#statusDiv').remove();
        var limit = AJS.$("#global-limit-lines").val();
        if(limit.length == 0) limit = "0";
        if(isValidNumber(limit)){
            //Add status div on update to indicate update done.
            $(statusField).insertAfter('.linesdiv');
            AJS.$.ajax({
                type : 'PUT' ,
                url : AJS.contextPath() + "/rest/github-macro/1.0/settings/global-limit-lines/"+limit,
                headers : {
                    "X-Atlassian-Token": "no-check"
                }
            });
        }
    });
    
   function isValidNumber(str){
        var field = $('#global-limit-lines');
        field.removeClass(VALIDATION_CSS_CLASS);
        const regex = /^\d+|[- .]\d+/gm;
        var result  = str.match(regex);
        if(result == null || result.length == 0){
            console.log('Invalid input.');
            field.addClass(VALIDATION_CSS_CLASS);
            return false;
        }
        return true;
    
    }//end of function
});
