/*
 * Decompiled with CFR 0.152.
 */
package com.mohamicorp.confluence.macro.github.rest;

import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.user.AuthenticatedUserThreadLocal;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.user.User;
import com.mohamicorp.confluence.macro.github.SettingsService;
import javax.ws.rs.DELETE;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import org.apache.log4j.Logger;

@Path(value="settings")
public class SettingsResource {
    private final PermissionManager permissionManager;
    private final SettingsService settingsService;
    private static final Logger log = Logger.getLogger(SettingsResource.class);

    public SettingsResource(PermissionManager permissionManager, SettingsService settingsService) {
        this.permissionManager = permissionManager;
        this.settingsService = settingsService;
    }

    private void enforcePermissions() {
        ConfluenceUser user = AuthenticatedUserThreadLocal.get();
        if (!this.permissionManager.isConfluenceAdministrator((User)user)) {
            throw new RuntimeException("Invalid permissions");
        }
    }

    @PUT
    @Path(value="resolve-private-urls")
    public void enableResolvePrivateUrls() {
        this.enforcePermissions();
        this.settingsService.setResolvePrivateUrls(true);
    }

    @DELETE
    @Path(value="resolve-private-urls")
    public void disableResolvePrivateUrls() {
        this.enforcePermissions();
        this.settingsService.setResolvePrivateUrls(false);
    }

    @PUT
    @Path(value="global-limit-lines/{limit}")
    public void setGlobalLimitLines(@PathParam(value="limit") String limit) {
        this.enforcePermissions();
        try {
            log.info((Object)("Setting limit " + limit));
            this.settingsService.setGlobalLimitLines(limit);
        }
        catch (NumberFormatException e) {
            log.error((Object)("Error setting limit " + limit + " : " + e.getMessage()));
            this.settingsService.setGlobalLimitLines("0");
        }
    }
}

