/*
 * Decompiled with CFR 0.152.
 */
package com.mohamicorp.confluence.macro.github.macro;

import com.atlassian.confluence.content.render.xhtml.ConversionContext;
import com.atlassian.confluence.macro.Macro;
import com.atlassian.confluence.macro.MacroExecutionException;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.soy.renderer.SoyTemplateRenderer;
import com.atlassian.webresource.api.assembler.PageBuilderService;
import com.google.common.collect.ImmutableMap;
import com.google.gson.JsonSyntaxException;
import com.mohamicorp.confluence.macro.github.GithubService;
import com.mohamicorp.confluence.macro.github.LicenseManager;
import com.mohamicorp.confluence.macro.github.exception.GithubBadResponseException;
import com.mohamicorp.confluence.macro.github.exception.GithubTokenNotFoundException;
import com.mohamicorp.confluence.macro.github.macro.GithubIssueList;
import java.util.Map;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.log4j.Logger;
import org.eclipse.egit.github.core.client.RequestException;

public abstract class GithubMacro
implements Macro {
    private static final String ERROR_TEMPLATE_KEY = "com.mohamicorp.confluence.macro.github.mohamicorp-github-macros:github-macro-errors";
    private static final String ERROR_TEMPLATE = "mohamicorp.github.macros.error";
    private static final String WARNING_TEMPLATE = "mohamicorp.github.macros.inputerror";
    private static final Logger log = Logger.getLogger(GithubIssueList.class);
    final GithubService githubService;
    private final SoyTemplateRenderer soyTemplateRenderer;
    private final LicenseManager licenseManager;
    private final I18nResolver i18nResolver;
    private final PageBuilderService pageBuilderService;

    public GithubMacro(@ComponentImport SoyTemplateRenderer soyTemplateRenderer, @ComponentImport PageBuilderService pageBuilderService, LicenseManager licenseManager, @ComponentImport I18nResolver i18nResolver, GithubService githubService) {
        this.soyTemplateRenderer = soyTemplateRenderer;
        this.pageBuilderService = pageBuilderService;
        this.licenseManager = licenseManager;
        this.i18nResolver = i18nResolver;
        this.githubService = githubService;
    }

    public String execute(Map<String, String> parameters, String body, ConversionContext conversionContext) throws MacroExecutionException {
        if (!this.licenseManager.validLicense()) {
            throw new MacroExecutionException(this.i18nResolver.getText("github.macro.error.license.expired"));
        }
        return null;
    }

    public Macro.BodyType getBodyType() {
        return Macro.BodyType.NONE;
    }

    public Macro.OutputType getOutputType() {
        return Macro.OutputType.BLOCK;
    }

    public String getMacroData(String resourceKey, String templateKey, String template, MacroSupplier<Map<String, Object>> issueFunction) {
        try {
            this.pageBuilderService.assembler().resources().requireWebResource(resourceKey);
            return this.soyTemplateRenderer.render(templateKey, template, issueFunction.accept());
        }
        catch (Exception e) {
            log.error((Object)e.getMessage(), (Throwable)e);
            if (e.getCause() instanceof RequestException) {
                return this.soyTemplateRenderer.render(ERROR_TEMPLATE_KEY, WARNING_TEMPLATE, (Map)ImmutableMap.of((Object)"error", (Object)"Error when communicating with Github. Check your parameters to make sure they're correct.", (Object)"details", (Object)e.getCause().getMessage()));
            }
            if (ExceptionUtils.indexOfThrowable((Throwable)e, JsonSyntaxException.class) != -1) {
                return this.soyTemplateRenderer.render(ERROR_TEMPLATE_KEY, WARNING_TEMPLATE, (Map)ImmutableMap.of((Object)"error", (Object)"Error when communicating with Github. Check that the URL you have set for your Github instance is valid.", (Object)"details", (Object)e.getCause().getMessage()));
            }
            if (e.getCause() != null) {
                return this.soyTemplateRenderer.render(ERROR_TEMPLATE_KEY, ERROR_TEMPLATE, (Map)ImmutableMap.of((Object)"error", (Object)e.getMessage(), (Object)"details", (Object)e.getCause().getMessage(), (Object)"stacktrace", (Object)ExceptionUtils.getStackTrace((Throwable)e)));
            }
            return this.soyTemplateRenderer.render(ERROR_TEMPLATE_KEY, WARNING_TEMPLATE, (Map)ImmutableMap.of((Object)"error", (Object)this.i18nResolver.getText("github.macro.config.validation.url.error.tile"), (Object)"details", (Object)e.getMessage()));
        }
    }

    @FunctionalInterface
    public static interface MacroSupplier<T> {
        public T accept() throws GithubTokenNotFoundException, GithubBadResponseException;
    }
}

