/*
 * Decompiled with CFR 0.152.
 */
package com.mohamicorp.confluence.macro.github;

import java.io.IOException;
import java.net.HttpURLConnection;
import java.util.Arrays;
import java.util.Map;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.client.GitHubResponse;
import org.eclipse.egit.github.core.util.UrlUtils;

public class MohamiGitHubClient
extends GitHubClient {
    private int readTimeout;
    private int connectTimeout;

    public MohamiGitHubClient() {
    }

    public MohamiGitHubClient(String hostname) {
        super(hostname);
    }

    public MohamiGitHubClient(String hostname, int port, String scheme) {
        super(hostname, port, scheme);
    }

    @Override
    protected HttpURLConnection configureRequest(HttpURLConnection request) {
        HttpURLConnection configured = super.configureRequest(request);
        configured.setReadTimeout(this.readTimeout);
        configured.setConnectTimeout(this.connectTimeout);
        return configured;
    }

    void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    @Override
    public GitHubResponse get(GitHubRequest request) throws IOException {
        return super.get(new MultivalueGitHubRequest(request));
    }

    private static class MultivalueGitHubRequest
    extends GitHubRequest {
        MultivalueGitHubRequest(GitHubRequest request) {
            this.setArrayType(request.getArrayType());
            this.setParams(request.getParams());
            this.setUri(request.getUri());
            this.setType(request.getType());
            this.setResponseContentType(request.getResponseContentType());
        }

        @Override
        protected void addParams(StringBuilder uri) {
            Map<String, String> params = this.getParams();
            if (params != null && !params.isEmpty()) {
                for (Map.Entry<String, String> entry : params.entrySet()) {
                    Arrays.stream(entry.getValue().split("\\|")).forEach(value -> UrlUtils.addParam((String)entry.getKey(), value, uri));
                }
            }
        }
    }
}

