/*
 * Decompiled with CFR 0.152.
 */
package com.mohamicorp.confluence.macro.github;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.confluence.setup.settings.SettingsManager;
import com.atlassian.confluence.util.http.ConfluenceHttpParameters;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.message.I18nResolver;
import com.google.gson.JsonParser;
import com.mohamicorp.confluence.macro.github.MohamiGitHubClient;
import com.mohamicorp.confluence.macro.github.SettingsService;
import com.mohamicorp.confluence.macro.github.exception.GithubBadResponseException;
import com.mohamicorp.confluence.macro.github.exception.GithubTokenNotFoundException;
import com.mohamicorp.confluence.macro.github.model.GithubToken;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.validator.routines.UrlValidator;
import org.apache.log4j.Logger;
import org.eclipse.egit.github.core.Issue;
import org.eclipse.egit.github.core.RepositoryContents;
import org.eclipse.egit.github.core.RepositoryId;
import org.eclipse.egit.github.core.client.GitHubClient;
import org.eclipse.egit.github.core.client.GitHubRequest;
import org.eclipse.egit.github.core.service.ContentsService;
import org.eclipse.egit.github.core.service.IssueService;
import org.jsoup.Jsoup;
import org.jsoup.nodes.Document;
import org.jsoup.nodes.Element;
import org.jsoup.select.Elements;

@Named
public class GithubService {
    public static final String TOKEN_PARAM = "token";
    public static final String USER_PARAM = "user";
    public static final String REPO_PARAM = "repo";
    public static final String PATH_PARAM = "path";
    public static final String QUERY_PARAM = "query";
    public static final String BRANCH_PARAM = "branch";
    public static final String REF_PARAM = "ref";
    public static final String MASTER = "master";
    private static final String LINE_RANGE_EXCEEDS_ERROR = "github.macro.config.validation.url.error.linesrange";
    private static final String LINE_FORMAT_INVALID_ERROR = "github.macro.config.validation.url.error.linesformat";
    private static final String ACCESS_TOKEN_NOT_FOUND = "github.macro.config.token.not.error";
    private static final String LINE_SEP = "line.separator";
    private static final String GITHUB_URL = "https://github.com";
    private static final String GITHUB_CONTENT_URL = "https://raw.githubusercontent.com/";
    private static final Pattern FILE_URL_PATTERN = Pattern.compile("https://(?<host>[^/]*)/(?<user>[^/]*)/(?<repo>[^/]*)(?<type>/raw|/blob)?/(?<branch>[^/]*)/(?<path>.*)");
    private static final String FILE_URL_TEMPLATE = "%s/%s/%s/blob/%s/%s";
    private static final String FILE_RAW_URL_TEMPLATE = "%s/%s/%s/%s/%s";
    private static final String ISSUE_QUERY_URL_TEMPLATE = "%s/%s/%s/issues?%s&q=is:issue";
    private static final String PR_QUERY_URL_TEMPLATE = "%s/%s/%s/issues?%s&q=is:pr";
    private static final String NO_LINE_NUMBER_CSS_CLASS = "nohljsln";
    private final ActiveObjects activeObjects;
    private final SettingsManager settingsManager;
    private final SettingsService settingsService;
    private final I18nResolver i18nResolver;
    private static final Logger log = Logger.getLogger(GithubService.class);

    @Inject
    public GithubService(@ComponentImport ActiveObjects activeObjects, @ComponentImport SettingsManager settingsManager, @ComponentImport I18nResolver i18nResolver, SettingsService settingsService) {
        this.activeObjects = activeObjects;
        this.settingsManager = settingsManager;
        this.settingsService = settingsService;
        this.i18nResolver = i18nResolver;
    }

    public Map<String, Object> getMarkdown(String user, String branch, String repo, String path, Integer token) throws GithubTokenNotFoundException, GithubBadResponseException {
        String renderedMarkdown;
        GitHubClient client = this.createClient(token);
        client.setHeaderAccept("application/vnd.github.v3.html+json");
        RepositoryId repository = new RepositoryId(user, repo);
        String id = repository.generateId();
        StringBuilder uri = new StringBuilder("/repos");
        uri.append('/').append(id);
        uri.append("/contents");
        if (path != null && path.length() > 0) {
            if (path.charAt(0) != '/') {
                uri.append('/');
            }
            uri.append(path);
        }
        GitHubRequest request = this.createMarkdownRequest(uri.toString(), branch);
        try {
            renderedMarkdown = IOUtils.toString((InputStream)client.getStream(request), (Charset)StandardCharsets.UTF_8);
        }
        catch (IOException e) {
            log.error((Object)"Error trying to get markdown from Github");
            throw new GithubBadResponseException("Error trying to get markdown from Github", e);
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("body", this.processLinks(client, token, user, repo, path, branch, renderedMarkdown));
        data.put(PATH_PARAM, path);
        return data;
    }

    GitHubRequest createMarkdownRequest(String uri, String branch) {
        GitHubRequest request = new GitHubRequest();
        request.setUri(uri);
        branch = StringUtils.trim((String)branch);
        if (!MASTER.equals(branch)) {
            HashMap<String, String> params = new HashMap<String, String>();
            params.put(REF_PARAM, branch);
            request.setParams(params);
        }
        return request;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, Object> getFileContext(String user, String branch, String repo, String path, Integer token, String linesParam, boolean hideLines) throws GithubTokenNotFoundException, GithubBadResponseException {
        List<RepositoryContents> contents;
        GitHubClient client = this.createClient(token);
        HashMap<String, Object> data = new HashMap<String, Object>();
        ContentsService contentService = new ContentsService(client);
        RepositoryId repository = new RepositoryId(user, repo);
        try {
            contents = contentService.getContents(repository, path, branch);
        }
        catch (IOException e) {
            log.error((Object)"Error trying to get file from Github");
            throw new GithubBadResponseException("Error trying to get file from Github", e);
        }
        RepositoryContents fileEntry = contents.get(0);
        String content = "";
        String linesStartNum = "1";
        log.info((Object)("linesParam =" + linesParam));
        if (StringUtils.isEmpty((String)linesParam)) {
            linesParam = this.settingsService.getGlobalLimitLines();
            if (linesParam.equalsIgnoreCase("0")) {
                linesParam = null;
            }
            log.info((Object)("Lines macro param is empty, so consider global limit lines config " + linesParam));
        }
        if (StringUtils.isNotEmpty((String)linesParam)) {
            if (!this.isLinesParamValid(linesParam)) throw new GithubBadResponseException(this.i18nResolver.getText(LINE_FORMAT_INVALID_ERROR));
            List<Integer> lineIndices = this.getLinesRangeList(linesParam);
            int start_index = lineIndices.get(0);
            int end_index = lineIndices.size() > 1 ? lineIndices.get(1) : 0;
            content = new String(DatatypeConverter.parseBase64Binary((String)fileEntry.getContent()), StandardCharsets.UTF_8);
            List<String> linesList = this.getFileLinesList(content);
            if (start_index <= linesList.size() && lineIndices.size() == 1 && linesParam.contains("-")) {
                linesList = linesList.subList(start_index - 1, linesList.size());
                linesStartNum = String.valueOf(start_index);
            } else if (lineIndices.size() == 1 && !linesParam.contains("-")) {
                linesList = linesList.subList(0, start_index <= linesList.size() ? start_index : linesList.size());
            } else {
                if (start_index >= linesList.size() || lineIndices.size() <= 1) throw new GithubBadResponseException(this.i18nResolver.getText(LINE_RANGE_EXCEEDS_ERROR));
                linesList = linesList.subList(start_index - 1, end_index <= linesList.size() ? end_index : linesList.size());
                linesStartNum = String.valueOf(start_index);
            }
            content = String.join((CharSequence)System.getProperty(LINE_SEP), linesList);
        } else {
            content = new String(DatatypeConverter.parseBase64Binary((String)fileEntry.getContent()), StandardCharsets.UTF_8);
        }
        data.put("content", content);
        data.put("lines_start_num", linesStartNum);
        data.put(PATH_PARAM, fileEntry.getName());
        data.put("linecount", content.split("\n").length);
        data.put("filesize", this.readableFileSize(fileEntry.getSize()));
        data.put("hide_lines", hideLines ? NO_LINE_NUMBER_CSS_CLASS : "");
        data.put("url", this.buildUrl(FILE_URL_TEMPLATE, token, GITHUB_URL, user, repo, branch, path));
        return data;
    }

    public Map<String, Object> getIssuesContext(String user, String repo, String query, Integer token) throws GithubTokenNotFoundException, GithubBadResponseException {
        List<Issue> issues;
        GitHubClient client = this.createClient(token);
        IssueService issueService = new IssueService(client);
        Map<String, String> filterData = this.getParameterMap(query);
        try {
            issues = issueService.getIssues(user, repo, filterData);
        }
        catch (IOException e) {
            log.error((Object)"Bad response from Github when trying to get issues.");
            throw new GithubBadResponseException("Bad response from Github when trying to get issues.", e);
        }
        long open = issues.stream().filter(issue -> "open".equals(issue.getState())).count();
        List realIssues = issues.stream().filter(issue -> issue.getPullRequest() == null).collect(Collectors.toList());
        String queryUrl = this.buildUrl(ISSUE_QUERY_URL_TEMPLATE, token, GITHUB_URL, user, repo, query);
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("open", open);
        data.put("closed", (long)issues.size() - open);
        if (StringUtils.isNotEmpty((String)query)) {
            data.put(QUERY_PARAM, query);
            data.put("query_url", queryUrl);
        }
        data.put("issues", realIssues);
        return data;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Map<String, Object> getPullRequestsContext(String user, String repo, String query, Integer token) throws GithubTokenNotFoundException, GithubBadResponseException {
        List<Issue> pullRequests;
        block8: {
            block7: {
                GitHubClient client = this.createClient(token);
                IssueService issueService = new IssueService(client);
                Map<String, String> params = this.getParameterMap(query);
                String state = params.get("state");
                String[] stateList = new String[]{"merged", "closed,unmerged"};
                if (Arrays.stream(stateList).anyMatch(params.get("state")::equalsIgnoreCase)) {
                    params.put("state", "closed");
                }
                try {
                    pullRequests = issueService.getIssues(user, repo, params);
                }
                catch (IOException e) {
                    log.error((Object)"Bad response from Github when trying to get pull requests.");
                    throw new GithubBadResponseException("Bad response from Github when trying to get pull requests.", e);
                }
                if (state == null) break block7;
                if (!Arrays.stream(stateList).anyMatch(state::equalsIgnoreCase)) break block7;
                if (state.equalsIgnoreCase("merged")) {
                    pullRequests = pullRequests.stream().filter(i -> i.getPullRequest() != null && i.getPullRequest().getMergedAt() != null).collect(Collectors.toList());
                    break block8;
                } else if (state.equalsIgnoreCase("closed,unmerged")) {
                    pullRequests = pullRequests.stream().filter(i -> i.getPullRequest() != null && i.getPullRequest().getMergedAt() == null).collect(Collectors.toList());
                }
                break block8;
            }
            pullRequests = pullRequests.stream().filter(i -> i.getPullRequest() != null).collect(Collectors.toList());
        }
        long open = pullRequests.stream().filter(pullRequest -> "open".equals(pullRequest.getState())).count();
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("open", open);
        data.put("closed", (long)pullRequests.size() - open);
        if (StringUtils.isNotEmpty((String)query)) {
            String queryUrl = this.buildUrl(PR_QUERY_URL_TEMPLATE, token, GITHUB_URL, user, repo, query);
            data.put(QUERY_PARAM, query);
            data.put("query_url", queryUrl);
        }
        data.put("issues", pullRequests);
        return data;
    }

    private String processLink(GitHubClient client, Integer token, String user, String repo, String path, String branch, String src, boolean isImage) {
        String result = src;
        if (src.startsWith("mailto:") || src.startsWith("#")) {
            return result;
        }
        boolean isRelative = !UrlValidator.getInstance().isValid(src);
        try {
            if (isRelative) {
                String defaultUrl = this.buildUrl(isImage ? FILE_RAW_URL_TEMPLATE : FILE_URL_TEMPLATE, token, isImage ? GITHUB_CONTENT_URL : GITHUB_URL, user, repo, branch, path);
                src = StringUtils.removeStart((String)src, (String)"/");
                result = new URI(defaultUrl).resolve(src).toString();
            }
            String ghubURL = this.getGithubUrl(token);
            boolean isURLMatch = StringUtils.startsWithAny((String)result, (String[])new String[]{GITHUB_URL, GITHUB_CONTENT_URL, StringUtils.isEmpty((String)ghubURL) ? GITHUB_URL : ghubURL});
            if (this.settingsService.getResolvePrivateUrls() && token != null && isURLMatch) {
                Matcher matcher;
                if (!isRelative && (matcher = FILE_URL_PATTERN.matcher(src)).matches()) {
                    user = matcher.group(USER_PARAM);
                    repo = matcher.group(REPO_PARAM);
                    branch = matcher.group(BRANCH_PARAM);
                    path = matcher.group(PATH_PARAM);
                }
                String apiUrl = "/repos/" + user + '/' + repo + "/contents" + '/' + path;
                if (isRelative) {
                    apiUrl = new URI(apiUrl).resolve(src).toString();
                }
                GitHubRequest request = this.createMarkdownRequest(apiUrl, branch);
                client.setHeaderAccept("application/vnd.github.v3.text+json");
                String content = IOUtils.toString((InputStream)client.getStream(request), (Charset)StandardCharsets.UTF_8);
                result = JsonParser.parseString(content).getAsJsonObject().get("download_url").getAsString();
            }
        }
        catch (Exception e) {
            log.debug((Object)String.format("Failed to resolve link %s: %s", src, e.getMessage()));
        }
        return result;
    }

    private String processLinks(GitHubClient client, Integer token, String user, String repo, String path, String branch, String renderedMarkdown) {
        Document doc = Jsoup.parse(renderedMarkdown);
        HashMap<String, String> relativeUrlMap = new HashMap<String, String>();
        Elements imgs = doc.select("img");
        for (Element img : imgs) {
            String src = img.attr("src");
            relativeUrlMap.computeIfAbsent(src, download_url -> this.processLink(client, token, user, repo, path, branch, src, true));
            img.attr("src", (String)relativeUrlMap.get(src));
        }
        Elements aTags = doc.select("a");
        for (Element a : aTags) {
            a.attr("target", "_parent");
            String href = a.attr("href");
            relativeUrlMap.computeIfAbsent(href, download_url -> this.processLink(client, token, user, repo, path, branch, href, false));
            if (href.equals(relativeUrlMap.get(href))) continue;
            a.attr("href", (String)relativeUrlMap.get(href));
            a.attr("target", "_blank");
        }
        return doc.html();
    }

    private String buildUrl(String template, Integer token, String githubUrl, String ... args) {
        GithubToken githubToken;
        if (token != null && !StringUtils.isEmpty((String)(githubToken = (GithubToken)this.activeObjects.get(GithubToken.class, (Object)token)).getUrl())) {
            githubUrl = githubToken.getUrl();
        }
        ArrayList<String> params = new ArrayList<String>();
        params.add(githubUrl);
        params.addAll(Arrays.asList(args));
        return String.format(template, params.toArray());
    }

    private GitHubClient createClient(Integer token) throws GithubTokenNotFoundException {
        MohamiGitHubClient client;
        if (token == null) {
            client = new MohamiGitHubClient();
        } else {
            GithubToken githubToken = (GithubToken)this.activeObjects.get(GithubToken.class, (Object)token);
            if (githubToken == null) {
                throw new GithubTokenNotFoundException("Access token " + token + " not found");
            }
            String githubUrl = githubToken.getUrl();
            if (StringUtils.isNotEmpty((String)githubUrl) && !githubUrl.equals("github.com")) {
                URL url;
                try {
                    url = new URL(githubUrl);
                }
                catch (MalformedURLException e) {
                    log.error((Object)"URL is malformed. This shouldn't happen so we're going to fail right here.");
                    throw new RuntimeException("URL is malformed. This shouldn't happen so we're going to fail right here.");
                }
                client = new MohamiGitHubClient(url.getHost(), url.getPort(), url.getProtocol());
            } else {
                client = new MohamiGitHubClient();
            }
            client.setOAuth2Token(githubToken.getToken());
        }
        ConfluenceHttpParameters confluenceHttpParameters = this.settingsManager.getGlobalSettings().getConfluenceHttpParameters();
        client.setConnectTimeout(confluenceHttpParameters.getConnectionTimeout());
        client.setReadTimeout(confluenceHttpParameters.getSocketTimeout());
        return client;
    }

    private Map<String, String> getParameterMap(String query) {
        String[] paramsAndValues;
        if (StringUtils.isEmpty((String)query)) {
            return Collections.emptyMap();
        }
        HashMap<String, String> result = new HashMap<String, String>();
        for (String paramAndValue : paramsAndValues = query.split("&")) {
            String[] pair = paramAndValue.split("=");
            if (pair.length != 2) continue;
            result.merge(pair[0], pair[1], (v1, v2) -> v1 + "|" + v2);
        }
        return result;
    }

    private String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    private boolean isLinesParamValid(String linesParam) {
        Pattern paramPattern = Pattern.compile("^\\d+|[- .]\\d+");
        Predicate<String> predicate = paramPattern.asPredicate();
        return predicate.test(linesParam);
    }

    private List<Integer> getLinesRangeList(String linesParam) {
        return Arrays.asList(linesParam.split("-")).stream().map(Integer::valueOf).collect(Collectors.toList());
    }

    private List<String> getFileLinesList(String content) {
        Pattern pattern = Pattern.compile("\\R");
        Stream<String> lines = pattern.splitAsStream(content);
        return lines.collect(Collectors.toList());
    }

    private String getGithubUrl(Integer token) throws GithubTokenNotFoundException {
        GithubToken githubToken = (GithubToken)this.activeObjects.get(GithubToken.class, (Object)token);
        if (githubToken == null) {
            throw new GithubTokenNotFoundException(this.i18nResolver.getText(ACCESS_TOKEN_NOT_FOUND));
        }
        return githubToken.getUrl();
    }
}

