/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.ognl;

import java.beans.BeanInfo;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import ognl.ClassResolver;
import ognl.Ognl;
import ognl.OgnlContext;
import ognl.OgnlException;
import ognl.OgnlRuntime;
import ognl.SimpleNode;
import ognl.TypeConverter;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.conversion.impl.XWorkConverter;
import org.apache.struts2.inject.Container;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.ognl.BeanInfoCacheFactory;
import org.apache.struts2.ognl.ExpressionCacheFactory;
import org.apache.struts2.ognl.OgnlCache;
import org.apache.struts2.ognl.OgnlGuard;
import org.apache.struts2.ognl.OgnlTypeConverterWrapper;
import org.apache.struts2.ognl.SecurityMemberAccess;
import org.apache.struts2.ognl.accessor.RootAccessor;
import org.apache.struts2.util.CompoundRoot;
import org.apache.struts2.util.reflection.ReflectionException;

public class OgnlUtil {
    private static final Logger LOG = LogManager.getLogger(OgnlUtil.class);
    private final OgnlCache<String, Object> expressionCache;
    private final OgnlCache<Class<?>, BeanInfo> beanInfoCache;
    private TypeConverter defaultConverter;
    private final OgnlGuard ognlGuard;
    private boolean devMode;
    private boolean enableExpressionCache = true;
    private boolean enableEvalExpression;
    private Container container;

    @Inject
    public OgnlUtil(@Inject ExpressionCacheFactory<String, Object> ognlExpressionCacheFactory, @Inject BeanInfoCacheFactory<Class<?>, BeanInfo> ognlBeanInfoCacheFactory, @Inject OgnlGuard ognlGuard) {
        this.expressionCache = Objects.requireNonNull(ognlExpressionCacheFactory).buildOgnlCache();
        this.beanInfoCache = Objects.requireNonNull(ognlBeanInfoCacheFactory).buildOgnlCache();
        this.ognlGuard = Objects.requireNonNull(ognlGuard);
    }

    @Inject
    protected void setXWorkConverter(XWorkConverter conv) {
        this.defaultConverter = new OgnlTypeConverterWrapper(conv);
    }

    @Inject(value="struts.devMode")
    protected void setDevMode(String mode) {
        this.devMode = BooleanUtils.toBoolean((String)mode);
    }

    @Inject(value="struts.ognl.enableExpressionCache", required=false)
    protected void setEnableExpressionCache(String cache) {
        this.enableExpressionCache = BooleanUtils.toBoolean((String)cache);
    }

    @Inject(value="struts.ognl.enableEvalExpression", required=false)
    protected void setEnableEvalExpression(String evalExpression) {
        this.enableEvalExpression = BooleanUtils.toBoolean((String)evalExpression);
        if (this.enableEvalExpression) {
            LOG.warn("Enabling OGNL expression evaluation may introduce security risks (see http://struts.apache.org/release/2.3.x/docs/s2-013.html for further details)");
        }
    }

    @Inject
    protected void setContainer(Container container) {
        this.container = container;
    }

    @Inject(value="struts.ognl.expressionMaxLength", required=false)
    protected void applyExpressionMaxLength(String maxLength) {
        try {
            if (maxLength == null || maxLength.isEmpty()) {
                Ognl.applyExpressionMaxLength(null);
                LOG.warn("OGNL Expression Max Length disabled.");
            } else {
                Ognl.applyExpressionMaxLength(Integer.parseInt(maxLength));
                LOG.debug("OGNL Expression Max Length enabled with {}.", (Object)maxLength);
            }
        }
        catch (Exception ex) {
            LOG.error("Unable to set OGNL Expression Max Length {}.", (Object)maxLength);
            throw ex;
        }
    }

    public static void clearRuntimeCache() {
        OgnlRuntime.clearCache();
    }

    public void clearExpressionCache() {
        this.expressionCache.clear();
    }

    public int expressionCacheSize() {
        return this.expressionCache.size();
    }

    public void clearBeanInfoCache() {
        this.beanInfoCache.clear();
    }

    public int beanInfoCacheSize() {
        return this.beanInfoCache.size();
    }

    public void setProperties(Map<String, ?> props, Object o, Map<String, Object> context) {
        this.setProperties(props, o, context, false);
    }

    public void setProperties(Map<String, ?> props, Object o, Map<String, Object> context, boolean throwPropertyExceptions) throws ReflectionException {
        if (props == null) {
            return;
        }
        Object oldRoot = Ognl.getRoot(context);
        Ognl.setRoot(context, o);
        for (Map.Entry<String, ?> entry : props.entrySet()) {
            String expression = entry.getKey();
            this.internalSetProperty(expression, entry.getValue(), o, context, throwPropertyExceptions);
        }
        Ognl.setRoot(context, oldRoot);
    }

    public void setProperties(Map<String, ?> properties, Object o) {
        this.setProperties(properties, o, false);
    }

    public void setProperties(Map<String, ?> properties, Object o, boolean throwPropertyExceptions) {
        Map<String, Object> context = this.createDefaultContext(o);
        this.setProperties(properties, o, context, throwPropertyExceptions);
    }

    public void setProperty(String name, Object value, Object o, Map<String, Object> context) {
        this.setProperty(name, value, o, context, false);
    }

    public void setProperty(String name, Object value, Object o, Map<String, Object> context, boolean throwPropertyExceptions) {
        Object oldRoot = Ognl.getRoot(context);
        Ognl.setRoot(context, o);
        this.internalSetProperty(name, value, o, context, throwPropertyExceptions);
        Ognl.setRoot(context, oldRoot);
    }

    public Object getRealTarget(String property, Map<String, Object> context, Object root) throws OgnlException {
        if ("top".equals(property)) {
            return root;
        }
        if (root instanceof CompoundRoot) {
            CompoundRoot cr = (CompoundRoot)root;
            try {
                for (Object target : cr) {
                    if (!OgnlRuntime.hasSetProperty((OgnlContext)context, target, property) && !OgnlRuntime.hasGetProperty((OgnlContext)context, target, property) && OgnlRuntime.getIndexedPropertyType((OgnlContext)context, target.getClass(), property) == OgnlRuntime.INDEXED_PROPERTY_NONE) continue;
                    return target;
                }
            }
            catch (IntrospectionException ex) {
                throw new ReflectionException("Cannot figure out real target class", ex);
            }
            return null;
        }
        return root;
    }

    public void setValue(String name, Map<String, Object> context, Object root, Object value) throws OgnlException {
        this.ognlSet(name, context, root, value, context, this::checkEvalExpression, this::checkArithmeticExpression);
    }

    private boolean isEvalExpression(Object tree, Map<String, Object> context) throws OgnlException {
        if (tree instanceof SimpleNode) {
            SimpleNode node = (SimpleNode)tree;
            OgnlContext ognlContext = null;
            if (context instanceof OgnlContext) {
                ognlContext = (OgnlContext)context;
            }
            return node.isEvalChain(ognlContext) || node.isSequence(ognlContext);
        }
        return false;
    }

    private boolean isArithmeticExpression(Object tree, Map<String, Object> context) throws OgnlException {
        if (tree instanceof SimpleNode) {
            SimpleNode node = (SimpleNode)tree;
            OgnlContext ognlContext = null;
            if (context instanceof OgnlContext) {
                ognlContext = (OgnlContext)context;
            }
            return node.isOperation(ognlContext);
        }
        return false;
    }

    private boolean isSimpleMethod(Object tree, Map<String, Object> context) throws OgnlException {
        if (tree instanceof SimpleNode) {
            SimpleNode node = (SimpleNode)tree;
            OgnlContext ognlContext = null;
            if (context instanceof OgnlContext) {
                ognlContext = (OgnlContext)context;
            }
            return node.isSimpleMethod(ognlContext) && !node.isChain(ognlContext);
        }
        return false;
    }

    public Object getValue(String name, Map<String, Object> context, Object root) throws OgnlException {
        return this.getValue(name, context, root, null);
    }

    public Object callMethod(String name, Map<String, Object> context, Object root) throws OgnlException {
        return this.ognlGet(name, context, root, null, context, this::checkSimpleMethod);
    }

    public Object getValue(String name, Map<String, Object> context, Object root, Class<?> resultType) throws OgnlException {
        return this.ognlGet(name, context, root, resultType, context, this::checkEnableEvalExpression);
    }

    public Object compile(String expression) throws OgnlException {
        return this.compile(expression, null);
    }

    private void ognlSet(String expr, Map<String, Object> context, Object root, Object value, Map<String, Object> checkContext, TreeValidator ... treeValidators) throws OgnlException {
        Object tree = this.toTree(expr);
        for (TreeValidator validator : treeValidators) {
            validator.validate(tree, checkContext);
        }
        Ognl.setValue(tree, context, root, value);
    }

    private <T> T ognlGet(String expr, Map<String, Object> context, Object root, Class<T> resultType, Map<String, Object> checkContext, TreeValidator ... treeValidators) throws OgnlException {
        Object tree = this.toTree(expr);
        for (TreeValidator validator : treeValidators) {
            validator.validate(tree, checkContext);
        }
        return (T)Ognl.getValue(tree, context, root, resultType);
    }

    private Object toTree(String expr) throws OgnlException {
        Object tree = null;
        if (this.enableExpressionCache) {
            tree = this.expressionCache.get(expr);
        }
        if (tree instanceof OgnlException) {
            this.clearStackTraceAndRethrow(tree);
        }
        if (tree == null) {
            try {
                tree = this.ognlGuard.parseExpression(expr);
            }
            catch (OgnlException e) {
                tree = e;
            }
            if (this.enableExpressionCache) {
                this.expressionCache.put(expr, tree);
            }
            if (tree instanceof OgnlException) {
                throw (OgnlException)tree;
            }
        }
        if ("_ognl_guard_blocked".equals(tree)) {
            throw new OgnlException("Expression blocked by OgnlGuard: " + expr);
        }
        return tree;
    }

    private void clearStackTraceAndRethrow(Object ognlException) throws OgnlException {
        OgnlException e = (OgnlException)ognlException;
        e.setStackTrace(new StackTraceElement[0]);
        if (e.getCause() != null) {
            e.getCause().setStackTrace(new StackTraceElement[0]);
        }
        throw e;
    }

    public Object compile(String expression, Map<String, Object> context) throws OgnlException {
        Object tree = this.toTree(expression);
        this.checkEnableEvalExpression(tree, context);
        return tree;
    }

    private void checkEnableEvalExpression(Object tree, Map<String, Object> context) throws OgnlException {
        if (!this.enableEvalExpression && this.isEvalExpression(tree, context)) {
            throw new OgnlException("Eval expressions/chained expressions have been disabled!");
        }
    }

    private void checkSimpleMethod(Object tree, Map<String, Object> context) throws OgnlException {
        if (!this.isSimpleMethod(tree, context)) {
            throw new OgnlException("It isn't a simple method which can be called!");
        }
    }

    private void checkEvalExpression(Object tree, Map<String, Object> context) throws OgnlException {
        if (this.isEvalExpression(tree, context)) {
            throw new OgnlException("Eval expression/chained expressions cannot be used as parameter name");
        }
    }

    private void checkArithmeticExpression(Object tree, Map<String, Object> context) throws OgnlException {
        if (this.isArithmeticExpression(tree, context)) {
            throw new OgnlException("Arithmetic expressions cannot be used as parameter name");
        }
    }

    public void copy(Object from, Object to, Map<String, Object> context, Collection<String> exclusions, Collection<String> inclusions) {
        this.copy(from, to, context, exclusions, inclusions, null);
    }

    public void copy(Object from, Object to, Map<String, Object> context, Collection<String> exclusions, Collection<String> inclusions, Class<?> editable) {
        PropertyDescriptor[] toPds;
        PropertyDescriptor[] fromPds;
        if (from == null || to == null) {
            LOG.warn("Skipping attempt to copy from, or to, a null source.", (Throwable)new RuntimeException());
            return;
        }
        Map<String, Object> contextFrom = this.createDefaultContext(from);
        Map<String, Object> contextTo = this.createDefaultContext(to);
        try {
            fromPds = this.getPropertyDescriptors(from);
            toPds = editable != null ? this.getPropertyDescriptors(editable) : this.getPropertyDescriptors(to);
        }
        catch (IntrospectionException e) {
            LOG.error("An error occurred", (Throwable)e);
            return;
        }
        HashMap<String, PropertyDescriptor> toPdHash = new HashMap<String, PropertyDescriptor>();
        for (PropertyDescriptor toPd : toPds) {
            toPdHash.put(toPd.getName(), toPd);
        }
        for (PropertyDescriptor fromPd : fromPds) {
            PropertyDescriptor toPd;
            if (fromPd.getReadMethod() == null || exclusions != null && exclusions.contains(fromPd.getName()) || inclusions != null && !inclusions.contains(fromPd.getName()) || (toPd = (PropertyDescriptor)toPdHash.get(fromPd.getName())) == null || toPd.getWriteMethod() == null) continue;
            try {
                Object value = this.ognlGet(fromPd.getName(), contextFrom, from, null, context, this::checkEnableEvalExpression);
                this.ognlSet(fromPd.getName(), contextTo, to, value, context, new TreeValidator[0]);
            }
            catch (OgnlException e) {
                LOG.debug("Got OGNL exception", (Throwable)e);
            }
        }
    }

    public void copy(Object from, Object to, Map<String, Object> context) {
        this.copy(from, to, context, null, null);
    }

    public PropertyDescriptor[] getPropertyDescriptors(Object source) throws IntrospectionException {
        BeanInfo beanInfo = this.getBeanInfo(source);
        return beanInfo.getPropertyDescriptors();
    }

    public PropertyDescriptor[] getPropertyDescriptors(Class<?> clazz) throws IntrospectionException {
        BeanInfo beanInfo = this.getBeanInfo(clazz);
        return beanInfo.getPropertyDescriptors();
    }

    public Map<String, Object> getBeanMap(Object source) throws IntrospectionException, OgnlException {
        PropertyDescriptor[] propertyDescriptors;
        HashMap<String, Object> beanMap = new HashMap<String, Object>();
        Map<String, Object> sourceMap = this.createDefaultContext(source);
        for (PropertyDescriptor propertyDescriptor : propertyDescriptors = this.getPropertyDescriptors(source)) {
            String propertyName = propertyDescriptor.getDisplayName();
            Method readMethod = propertyDescriptor.getReadMethod();
            if (readMethod != null) {
                Object value = this.ognlGet(propertyName, sourceMap, source, null, null, this::checkEnableEvalExpression);
                beanMap.put(propertyName, value);
                continue;
            }
            beanMap.put(propertyName, "There is no read method for " + propertyName);
        }
        return beanMap;
    }

    public BeanInfo getBeanInfo(Object from) throws IntrospectionException {
        return this.getBeanInfo(from.getClass());
    }

    public BeanInfo getBeanInfo(Class<?> clazz) throws IntrospectionException {
        try {
            return this.beanInfoCache.computeIfAbsent(clazz, k -> {
                try {
                    return Introspector.getBeanInfo(k, Object.class);
                }
                catch (IntrospectionException e) {
                    throw new IllegalArgumentException(e);
                }
            });
        }
        catch (IllegalArgumentException e) {
            Throwable throwable = e.getCause();
            if (throwable instanceof IntrospectionException) {
                IntrospectionException innerEx = (IntrospectionException)throwable;
                throw innerEx;
            }
            throw e;
        }
    }

    void internalSetProperty(String name, Object value, Object o, Map<String, Object> context, boolean throwPropertyExceptions) throws ReflectionException {
        block4: {
            try {
                this.setValue(name, context, o, value);
            }
            catch (OgnlException e) {
                Throwable exception;
                Throwable reason = e.getReason();
                if (reason instanceof SecurityException) {
                    LOG.error("Could not evaluate this expression due to security constraints: [{}]", (Object)name, (Object)e);
                }
                String msg = "Caught OgnlException while setting property '" + name + "' on type '" + o.getClass().getName() + "'.";
                Throwable throwable = exception = reason == null ? e : reason;
                if (throwPropertyExceptions) {
                    throw new ReflectionException(msg, exception);
                }
                if (!this.devMode) break block4;
                LOG.warn(msg, exception);
            }
        }
    }

    protected Map<String, Object> createDefaultContext(Object root) {
        return this.createDefaultContext(root, null);
    }

    protected Map<String, Object> createDefaultContext(Object root, ClassResolver resolver) {
        if (resolver == null && (resolver = (ClassResolver)this.container.getInstance(RootAccessor.class)) == null) {
            throw new IllegalStateException("Cannot find ClassResolver");
        }
        return Ognl.createDefaultContext(root, this.container.getInstance(SecurityMemberAccess.class), resolver, this.defaultConverter);
    }

    @FunctionalInterface
    private static interface TreeValidator {
        public void validate(Object var1, Map<String, Object> var2) throws OgnlException;
    }
}

