/*
 * Decompiled with CFR 0.152.
 */
package org.apache.struts2.interceptor;

import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.struts2.ActionInvocation;
import org.apache.struts2.config.entities.ExceptionMappingConfig;
import org.apache.struts2.dispatcher.HttpParameters;
import org.apache.struts2.inject.Inject;
import org.apache.struts2.interceptor.AbstractInterceptor;
import org.apache.struts2.interceptor.ExceptionHolder;
import org.apache.struts2.ognl.ThreadAllowlist;

public class ExceptionMappingInterceptor
extends AbstractInterceptor {
    private static final Logger LOG = LogManager.getLogger(ExceptionMappingInterceptor.class);
    private transient ThreadAllowlist threadAllowlist;
    protected Logger categoryLogger;
    protected boolean logEnabled = false;
    protected String logCategory;
    protected String logLevel;

    @Inject
    public void setThreadAllowlist(ThreadAllowlist threadAllowlist) {
        this.threadAllowlist = threadAllowlist;
    }

    public boolean isLogEnabled() {
        return this.logEnabled;
    }

    public void setLogEnabled(boolean logEnabled) {
        this.logEnabled = logEnabled;
    }

    public String getLogCategory() {
        return this.logCategory;
    }

    public void setLogCategory(String logCategory) {
        this.logCategory = logCategory;
    }

    public String getLogLevel() {
        return this.logLevel;
    }

    public void setLogLevel(String logLevel) {
        this.logLevel = logLevel;
    }

    @Override
    public String intercept(ActionInvocation invocation) throws Exception {
        String result;
        try {
            result = invocation.invoke();
        }
        catch (Exception e) {
            List<ExceptionMappingConfig> exceptionMappings;
            ExceptionMappingConfig mappingConfig;
            if (this.isLogEnabled()) {
                this.handleLogging(e);
            }
            if ((mappingConfig = this.findMappingFromExceptions(exceptionMappings = invocation.getProxy().getConfig().getExceptionMappings(), e)) != null && mappingConfig.getResult() != null) {
                Map<String, String> mappingParams = mappingConfig.getParams();
                HttpParameters parameters = HttpParameters.create(mappingParams).build();
                invocation.getInvocationContext().withParameters(parameters);
                result = mappingConfig.getResult();
                ExceptionHolder holder = new ExceptionHolder(e);
                this.threadAllowlist.allowClassHierarchy(ExceptionHolder.class);
                this.threadAllowlist.allowClassHierarchy(e.getClass());
                this.publishException(invocation, holder);
            }
            throw e;
        }
        return result;
    }

    protected void handleLogging(Exception e) {
        if (this.logCategory != null) {
            if (this.categoryLogger == null) {
                this.categoryLogger = LogManager.getLogger(this.logCategory);
            }
            this.doLog(this.categoryLogger, e);
        } else {
            this.doLog(LOG, e);
        }
    }

    protected void doLog(Logger logger, Exception e) {
        if (this.logLevel == null) {
            logger.debug(e.getMessage(), (Throwable)e);
            return;
        }
        Level level = Level.getLevel(this.logLevel);
        if (level == null) {
            throw new IllegalArgumentException("LogLevel [" + this.logLevel + "] is not supported");
        }
        logger.log(level, e.getMessage(), (Throwable)e);
    }

    protected ExceptionMappingConfig findMappingFromExceptions(List<ExceptionMappingConfig> exceptionMappings, Throwable t2) {
        ExceptionMappingConfig config = null;
        if (exceptionMappings != null) {
            int deepest = Integer.MAX_VALUE;
            for (ExceptionMappingConfig exceptionMapping : exceptionMappings) {
                int depth = this.getDepth(exceptionMapping.getExceptionClassName(), t2);
                if (depth < 0 || depth >= deepest) continue;
                deepest = depth;
                config = exceptionMapping;
            }
        }
        return config;
    }

    public int getDepth(String exceptionMapping, Throwable t2) {
        return this.getDepth(exceptionMapping, t2.getClass(), 0);
    }

    private int getDepth(String exceptionMapping, Class<?> exceptionClass, int depth) {
        if (exceptionClass.getName().contains(exceptionMapping)) {
            return depth;
        }
        if (exceptionClass.equals(Throwable.class)) {
            return -1;
        }
        return this.getDepth(exceptionMapping, exceptionClass.getSuperclass(), depth + 1);
    }

    protected void publishException(ActionInvocation invocation, ExceptionHolder exceptionHolder) {
        invocation.getStack().push(exceptionHolder);
    }
}

