/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.utility;

import com.atlassian.confluence.license.LicenseService;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginInfo;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.ConfluenceUser;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.directory.RemoteDirectory;
import com.atlassian.crowd.directory.loader.DirectoryInstanceLoader;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.NullRestriction;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.extras.api.confluence.ConfluenceLicense;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.spring.container.ContainerManager;
import com.atlassian.upm.api.license.PluginLicenseManager;
import com.atlassian.upm.api.license.entity.PluginLicense;
import com.atlassian.user.User;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.utility.ADUserDirectoryHelper;
import com.miniorange.usermanagement.confluence.utility.CrowdDirectoryHelper;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
public class ConfluenceUserManagementUtility {
    private static Logger LOGGER = LoggerFactory.getLogger(ConfluenceUserManagementUtility.class);
    private CrowdService crowdService;
    private PluginLicenseManager pluginLicenseManager;
    private LoginManager loginManager;
    private UserAccessor userAccessor;
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler userManagementPluginHandler;
    private DirectoryManager directoryManager;
    private LicenseService licenseService;
    private PermissionManager permissionManager;
    private CrowdDirectoryService crowdDirectoryService;
    private ADUserDirectoryHelper directoryHelper;
    private CrowdDirectoryHelper crowdDirectoryHelper;

    public ConfluenceUserManagementUtility(CrowdService crowdService, PluginLicenseManager pluginLicenseManager, LoginManager loginManager, UserAccessor userAccessor, UserManagementPluginHandler userManagementPluginHandler, UserManagementPluginSettings settings, DirectoryManager directoryManager, LicenseService licenseService, PermissionManager permissionManager, CrowdDirectoryService crowdDirectoryService, ADUserDirectoryHelper directoryHelper, CrowdDirectoryHelper crowdDirectoryHelper) {
        this.crowdService = crowdService;
        this.pluginLicenseManager = pluginLicenseManager;
        this.loginManager = loginManager;
        this.userAccessor = userAccessor;
        this.settings = settings;
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.directoryManager = directoryManager;
        this.licenseService = licenseService;
        this.permissionManager = permissionManager;
        this.crowdDirectoryService = crowdDirectoryService;
        this.directoryHelper = directoryHelper;
        this.crowdDirectoryHelper = crowdDirectoryHelper;
    }

    public List<com.atlassian.crowd.embedded.api.User> getUserFromConfluenceUsingUsername(String usernameSearchKeyword, String userSearchFilter, List<String> groupSearchList, String directory) {
        LOGGER.debug("getUserFromConfluenceUsingUsername");
        ArrayList availableUser = new ArrayList();
        Object activeUser = null;
        Object inactiveUser = null;
        ArrayList<List> userLists = new ArrayList<List>();
        ArrayList usersList = new ArrayList();
        List userSearchFilterList = new ArrayList();
        ArrayList<com.atlassian.crowd.embedded.api.User> finalUserList = new ArrayList<com.atlassian.crowd.embedded.api.User>();
        String groupSearchKey = "";
        MembershipQuery queryForGroup = null;
        EntityQuery query = null;
        if (groupSearchList.size() > 0) {
            for (int i = 0; i < groupSearchList.size(); ++i) {
                groupSearchKey = groupSearchList.get(i);
                if (!StringUtils.isNotBlank((CharSequence)groupSearchKey)) continue;
                queryForGroup = QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).childrenOf(EntityDescriptor.group()).withNames(new String[]{groupSearchKey}).returningAtMost(-1);
                userLists.add((List)this.crowdService.search((Query)queryForGroup));
            }
            if (userLists.size() > 0) {
                usersList.addAll((Collection)userLists.get(0));
                ListIterator iter = userLists.listIterator(0);
                while (iter.hasNext()) {
                    usersList.retainAll((Collection)iter.next());
                }
            }
            finalUserList = usersList;
        }
        query = !userSearchFilter.equals("AllUsers") ? (userSearchFilter.equals("ActiveUsers") ? QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.ACTIVE).containing((Object)true), Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)usernameSearchKeyword)})})).returningAtMost(-1) : QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.ACTIVE).containing((Object)false), Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)usernameSearchKeyword)})})).returningAtMost(-1)) : QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)usernameSearchKeyword), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)usernameSearchKeyword)})).returningAtMost(-1);
        userSearchFilterList = (List)this.crowdService.search((Query)query);
        if (!finalUserList.isEmpty()) {
            finalUserList.retainAll(userSearchFilterList);
        } else if (groupSearchList.isEmpty()) {
            finalUserList = userSearchFilterList;
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)"All", (CharSequence)directory)) {
            try {
                List directoryUsers = new ArrayList();
                DirectoryInstanceLoader directoryLoader = (DirectoryInstanceLoader)ContainerManager.getComponent((String)"directoryInstanceLoader");
                List allDirectories = this.directoryManager.findAllDirectories();
                for (int i = 0; i < allDirectories.size(); ++i) {
                    String dirName = ((Directory)allDirectories.get(i)).getName();
                    if (!StringUtils.equalsIgnoreCase((CharSequence)dirName, (CharSequence)directory)) continue;
                    RemoteDirectory dir = directoryLoader.getDirectory(this.directoryManager.findDirectoryByName(dirName));
                    EntityQuery query1 = QueryBuilder.queryFor(com.atlassian.crowd.embedded.api.User.class, (EntityDescriptor)EntityDescriptor.user()).returningAtMost(-1);
                    directoryUsers = dir.searchUsers(query1);
                }
                finalUserList.retainAll(directoryUsers);
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while querying based on directory" + String.valueOf(e));
            }
        }
        Collections.sort(finalUserList);
        return finalUserList;
    }

    public List<List<com.atlassian.crowd.embedded.api.User>> fetchUsersWithLastLoginFilter(List<com.atlassian.crowd.embedded.api.User> usernameList) {
        ArrayList<List<com.atlassian.crowd.embedded.api.User>> resultList = new ArrayList<List<com.atlassian.crowd.embedded.api.User>>();
        List userListToReturnNull = Collections.synchronizedList(new ArrayList());
        ConcurrentHashMap<Long, com.atlassian.crowd.embedded.api.User> userMapWithLastLogin = new ConcurrentHashMap<Long, com.atlassian.crowd.embedded.api.User>();
        int batchSize = 2000;
        int numBatches = (int)Math.ceil((double)usernameList.size() / (double)batchSize);
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<CompletableFuture<Void>> allDirectoryUsers = new ArrayList<CompletableFuture<Void>>();
        for (int j = 0; j < numBatches; ++j) {
            int start = j * batchSize;
            int end = Math.min((j + 1) * batchSize, usernameList.size());
            List<com.atlassian.crowd.embedded.api.User> batch = usernameList.subList(start, end);
            CompletableFuture<Void> directoryUsers = CompletableFuture.runAsync(() -> {
                HashMap<Long, com.atlassian.crowd.embedded.api.User> tempUserMap = new HashMap<Long, com.atlassian.crowd.embedded.api.User>();
                for (com.atlassian.crowd.embedded.api.User user : batch) {
                    LoginInfo loginInfo = this.loginManager.getLoginInfo((User)this.userAccessor.getUserByName(user.getName()));
                    if (loginInfo.getLastSuccessfulLoginDate() == null) {
                        userListToReturnNull.add(user);
                        continue;
                    }
                    long loginTime = loginInfo.getLastSuccessfulLoginDate().getTime();
                    tempUserMap.put(loginTime, user);
                }
                userMapWithLastLogin.putAll(tempUserMap);
            }, executorService);
            allDirectoryUsers.add(directoryUsers);
        }
        CompletableFuture.allOf(allDirectoryUsers.toArray(new CompletableFuture[0])).join();
        resultList.add(userMapWithLastLogin != null ? this.sortUsersByLastLogin(userMapWithLastLogin) : null);
        resultList.add(userListToReturnNull);
        executorService.shutdown();
        return resultList;
    }

    public List<com.atlassian.crowd.embedded.api.User> sortUsersByLastLogin(Map<Long, com.atlassian.crowd.embedded.api.User> userListWithLastLogin) {
        TreeMap sortedMap = new TreeMap(Collections.reverseOrder());
        sortedMap.putAll(userListWithLastLogin);
        ArrayList<com.atlassian.crowd.embedded.api.User> userListToReturn = new ArrayList<com.atlassian.crowd.embedded.api.User>(sortedMap.size());
        for (com.atlassian.crowd.embedded.api.User user : sortedMap.values()) {
            userListToReturn.add(user);
        }
        return userListToReturn;
    }

    public String getCurrentIpAddress(HttpServletRequest request) {
        String remoteAddr = "";
        if (request != null && (StringUtils.isBlank((CharSequence)(remoteAddr = request.getHeader("X-FORWARDED-FOR"))) || StringUtils.isEmpty((CharSequence)remoteAddr))) {
            remoteAddr = request.getRemoteAddr();
        }
        return remoteAddr;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void removeGroupFromExternalDirectoryUser(com.atlassian.crowd.embedded.api.User currentUser, Boolean autoRemove, Directory directory, List<String> groupsToRemove, HttpServletResponse response, String ip) {
        boolean isAdmin;
        Set operation = directory.getAllowedOperations();
        String userName = currentUser.getName();
        ConfluenceUser user = this.userAccessor.getUserByName(userName);
        boolean bl = isAdmin = this.permissionManager.isSystemAdministrator((User)user) || this.permissionManager.isConfluenceAdministrator((User)user);
        if (!isAdmin) {
            if (directory.getType() == DirectoryType.CROWD && !operation.contains(OperationType.UPDATE_USER)) {
                if (!this.settings.getEnableCrowdROUser().booleanValue() || !autoRemove.booleanValue()) return;
                List userGroups = this.userAccessor.getGroupNames((User)this.userAccessor.getUserByName(userName));
                for (String group : groupsToRemove) {
                    if (!userGroups.contains(group)) continue;
                    this.crowdDirectoryHelper.handleCrowdUserOperation(currentUser, group, directory, ip, "removeFromGroup");
                }
                return;
            } else if (directory.getType() == DirectoryType.CONNECTOR && directory.getImplementationClass().contains("MicrosoftActiveDirectory") && !operation.contains(OperationType.UPDATE_USER) && autoRemove.booleanValue()) {
                this.directoryHelper.handleLdapUserOperation(userName, groupsToRemove, ip, "removeFromGroup");
                return;
            } else {
                try {
                    this.removeUserFromGroups(userName, autoRemove, groupsToRemove, response, ip);
                    return;
                }
                catch (IOException e) {
                    LOGGER.error(e.getMessage());
                }
            }
            return;
        } else {
            LOGGER.error("Could not remove the group from user '" + userName + "' as the user has admin privileges.");
            try {
                if (autoRemove.booleanValue()) return;
                this.sendErrorResponse("Error_User_Is_Admin", 500, response);
                return;
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while sending the response: ", (Throwable)e);
            }
        }
    }

    public void addGroupFromExternalDirectoryUser(com.atlassian.crowd.embedded.api.User currentUser, Directory directory, List<String> groupsToAdd, String ip, Boolean isAutomation) {
        Set operation = directory.getAllowedOperations();
        if (directory.getType() == DirectoryType.CROWD && !operation.contains(OperationType.UPDATE_USER) && isAutomation.booleanValue()) {
            for (String group : groupsToAdd) {
                this.crowdDirectoryHelper.handleCrowdUserOperation(currentUser, group, directory, ip, "addToGroup");
            }
        } else if (directory.getType() == DirectoryType.CONNECTOR && directory.getImplementationClass().contains("MicrosoftActiveDirectory") && !operation.contains(OperationType.UPDATE_USER)) {
            if (isAutomation.booleanValue()) {
                this.directoryHelper.handleLdapUserOperation(currentUser.getName(), groupsToAdd, ip, "addToGroup");
            } else {
                this.directoryHelper.handleLdapUserOperation(currentUser.getName(), groupsToAdd, ip, "enableUser");
            }
        } else {
            for (String group : groupsToAdd) {
                try {
                    this.directoryManager.addUserToGroup(currentUser.getDirectoryId(), currentUser.getName(), group);
                    this.userManagementPluginHandler.storeAuditLogs(currentUser.getName(), ip, "Added to Group", "Added User to Groups: " + group, "Success");
                }
                catch (Exception e) {
                    this.userManagementPluginHandler.storeAuditLogs(currentUser.getName(), ip, "Added to Group", "Failed to add group membership for: " + group, "Error");
                    LOGGER.error("Unable to add user '" + currentUser.getName() + "' to group '" + group + "' due to: " + String.valueOf(e));
                }
            }
        }
    }

    public boolean isUserFromReadOnlyExternalDirectory(String username) {
        com.atlassian.crowd.embedded.api.User currentUser = this.crowdService.getUser(username);
        if (currentUser == null) {
            return false;
        }
        Directory directory = this.crowdDirectoryService.findDirectoryById(currentUser.getDirectoryId());
        return directory.getType() != DirectoryType.INTERNAL && !directory.getAllowedOperations().contains(OperationType.UPDATE_USER);
    }

    public void removeUserFromGroups(String username, Boolean autoRemove, List<String> groupsToRemove, HttpServletResponse response, String ip) throws IOException {
        block4: {
            long userDir = this.crowdService.getUser(username).getDirectoryId();
            try {
                for (String groupToRemove : groupsToRemove) {
                    this.directoryManager.removeUserFromGroup(userDir, username, groupToRemove);
                    LOGGER.debug("User :" + username + "  is successfully removed from group : " + groupToRemove);
                }
            }
            catch (Exception e) {
                LOGGER.error("Issue while remove user: " + username + "from group : " + e.getMessage());
                if (autoRemove.booleanValue()) break block4;
                this.sendErrorResponse("Error", 500, response);
            }
        }
        if (!groupsToRemove.isEmpty()) {
            String UserInGroup = groupsToRemove.toString();
            this.userManagementPluginHandler.storeAuditLogs(username, ip, "Removed from Group", "Removed User from Groups: " + UserInGroup.replaceAll("[\\[\\]]", ""), "Success");
        }
    }

    public void sendErrorResponse(String errorMessages, int statusCode, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(statusCode);
        resp.getOutputStream().write(errorMessages.getBytes());
        resp.getOutputStream().close();
    }

    public void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes(StandardCharsets.UTF_8));
            resp.getOutputStream().close();
        }
    }

    public List<String> getAllGroups(String groupRegexPattern) {
        String startWith = "";
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)startWith)).returningAtMost(-1);
        ArrayList<String> existingGroups = new ArrayList<String>();
        Iterable groups = this.crowdService.search((Query)query);
        for (Group groupObject : groups) {
            if (!StringUtils.containsIgnoreCase((CharSequence)groupObject.getName(), (CharSequence)groupRegexPattern.trim())) continue;
            existingGroups.add(groupObject.getName().trim());
        }
        return existingGroups;
    }

    public List<String> getSelectedDetailsForPagination(List<String> detailsList, Integer groupsPerPage, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int i = startIndex.intValue(); i < startIndex + groupsPerPage && i <= endIndex && i < detailsList.size(); ++i) {
            selectedDetailsPagination.add(detailsList.get(i));
        }
        Collections.sort(selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    public List<com.atlassian.crowd.embedded.api.User> filterUsers(List<com.atlassian.crowd.embedded.api.User> usernameList, boolean isDateFilter, String startDateFilter, String endDateFilter, boolean onlyLicensedUsers, List<String> excludeGroupFilterList) {
        long endDateMillis;
        long startDateMillis;
        LOGGER.debug("Filtering users based on date, licensed status, and excluding groups");
        HashSet licensedUsers = new HashSet(this.userAccessor.getUserNamesWithConfluenceAccess());
        HashSet<String> excludeGroupSet = new HashSet<String>(excludeGroupFilterList);
        String startDate = startDateFilter + " 00:00:00";
        String endDate = endDateFilter + " 23:59:59";
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            startDateMillis = sdf.parse(startDate).getTime();
            endDateMillis = sdf.parse(endDate).getTime();
        }
        catch (ParseException e) {
            LOGGER.error("Error while parsing dates: startDate=" + startDate + ", endDate=" + endDate + ": " + String.valueOf(e));
            throw new RuntimeException(e);
        }
        long finalStartDateMillis = startDateMillis;
        long finalEndDateMillis = endDateMillis;
        List<com.atlassian.crowd.embedded.api.User> targetedUser = usernameList.parallelStream().filter(user -> {
            HashSet userGroups;
            if (onlyLicensedUsers && !licensedUsers.contains(user.getName())) {
                return false;
            }
            if (!excludeGroupSet.isEmpty() && !Collections.disjoint(userGroups = new HashSet(this.userAccessor.getGroupNamesForUserName(user.getName())), excludeGroupSet)) {
                return false;
            }
            if (!isDateFilter) {
                return true;
            }
            LoginInfo loginInfo = this.loginManager.getLoginInfo((User)this.userAccessor.getUserByName(user.getName()));
            if (loginInfo.getLastSuccessfulLoginDate() != null) {
                long lastLoginTime = loginInfo.getLastSuccessfulLoginDate().getTime();
                return lastLoginTime >= finalStartDateMillis && lastLoginTime <= finalEndDateMillis;
            }
            return false;
        }).collect(Collectors.toList());
        return targetedUser;
    }

    public int getMaxUsers() {
        int t2 = 0;
        try {
            if (this.pluginLicenseManager.getLicense().isDefined()) {
                t2 = (Integer)((PluginLicense)this.pluginLicenseManager.getLicense().get()).getEdition().get();
            }
        }
        catch (Exception e) {
            return -1;
        }
        return t2;
    }

    public Boolean isValidEvaluationLicense() {
        return ((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid();
    }

    public Boolean isEvaluationLicense() {
        if (this.isLicenseDefined().booleanValue()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            LOGGER.debug("pluginLicense.isEvaluation() :- " + pluginLicense.isEvaluation());
            return pluginLicense.isEvaluation();
        }
        return Boolean.FALSE;
    }

    public Boolean isSubscriptionLicense() {
        if (this.isLicenseDefined().booleanValue()) {
            PluginLicense pluginLicense = (PluginLicense)this.pluginLicenseManager.getLicense().get();
            LOGGER.debug("pluginLicense.isSubscription() :- " + pluginLicense.isSubscription());
            if (pluginLicense.isSubscription()) {
                return pluginLicense.isSubscription();
            }
            if (!pluginLicense.isEvaluation() || this.isLicenseValid().booleanValue()) {
                return Boolean.TRUE;
            }
            return Boolean.FALSE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLicenseDefined() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public Boolean isLicenseValid() {
        if (this.pluginLicenseManager.getLicense().isDefined()) {
            if (!((PluginLicense)this.pluginLicenseManager.getLicense().get()).isValid() || ((PluginLicense)this.pluginLicenseManager.getLicense().get()).getError().isDefined()) {
                return Boolean.FALSE;
            }
            return Boolean.TRUE;
        }
        return Boolean.TRUE;
    }

    public int getLicensedUserTier() {
        try {
            ConfluenceLicense license = this.licenseService.retrieve();
            int userTier = license.getMaximumNumberOfUsers();
            LOGGER.debug("userTier is :- " + userTier);
            return userTier;
        }
        catch (Exception e) {
            LOGGER.error("Error occured", (Throwable)e);
            return 0;
        }
    }

    public Directory getInternalDirectory() {
        EntityQuery query = QueryBuilder.queryFor(Directory.class, (EntityDescriptor)EntityDescriptor.directory(), (SearchRestriction)NullRestriction.INSTANCE, (int)0, (int)Integer.MAX_VALUE);
        List allDirectories = this.directoryManager.searchDirectories(query);
        for (Directory dir : allDirectories) {
            if (dir.getType() != DirectoryType.INTERNAL) continue;
            LOGGER.debug("Internal Confluence Directory : " + dir.getName());
            return dir;
        }
        return null;
    }

    @Generated
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Generated
    public PluginLicenseManager getPluginLicenseManager() {
        return this.pluginLicenseManager;
    }

    @Generated
    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public UserManagementPluginHandler getUserManagementPluginHandler() {
        return this.userManagementPluginHandler;
    }

    @Generated
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Generated
    public LicenseService getLicenseService() {
        return this.licenseService;
    }

    @Generated
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Generated
    public CrowdDirectoryService getCrowdDirectoryService() {
        return this.crowdDirectoryService;
    }

    @Generated
    public ADUserDirectoryHelper getDirectoryHelper() {
        return this.directoryHelper;
    }

    @Generated
    public CrowdDirectoryHelper getCrowdDirectoryHelper() {
        return this.crowdDirectoryHelper;
    }

    @Generated
    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Generated
    public void setPluginLicenseManager(PluginLicenseManager pluginLicenseManager) {
        this.pluginLicenseManager = pluginLicenseManager;
    }

    @Generated
    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setUserManagementPluginHandler(UserManagementPluginHandler userManagementPluginHandler) {
        this.userManagementPluginHandler = userManagementPluginHandler;
    }

    @Generated
    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Generated
    public void setLicenseService(LicenseService licenseService) {
        this.licenseService = licenseService;
    }

    @Generated
    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Generated
    public void setCrowdDirectoryService(CrowdDirectoryService crowdDirectoryService) {
        this.crowdDirectoryService = crowdDirectoryService;
    }

    @Generated
    public void setDirectoryHelper(ADUserDirectoryHelper directoryHelper) {
        this.directoryHelper = directoryHelper;
    }

    @Generated
    public void setCrowdDirectoryHelper(CrowdDirectoryHelper crowdDirectoryHelper) {
        this.crowdDirectoryHelper = crowdDirectoryHelper;
    }
}

