/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.confluence.security.PermissionManager;
import com.atlassian.confluence.security.login.LoginManager;
import com.atlassian.confluence.user.UserAccessor;
import com.atlassian.crowd.embedded.api.CrowdDirectoryService;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.DirectoryType;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.FailedAuthenticationException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.json.jsonorg.JSONObject;
import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginHandler;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import com.miniorange.usermanagement.confluence.utility.ADUserDirectoryHelper;
import com.miniorange.usermanagement.confluence.utility.ConfluenceUserManagementUtility;
import com.miniorange.usermanagement.confluence.utility.CrowdDirectoryHelper;
import com.miniorange.usermanagement.confluence.wrapper.CachedBodyHttpServletRequestWrapper;
import com.miniorange.usermanagement.confluence.wrapper.RestReadingServletRequest;
import java.io.BufferedReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.annotation.WebFilter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ConfluenceComponent
@UnrestrictedAccess
@WebFilter(value={"/*"})
public class MoLoginFilter
implements Filter {
    private static Logger LOGGER = LoggerFactory.getLogger(MoLoginFilter.class);
    private UserManagementPluginSettings settings;
    private UserAccessor userAccessor;
    private ConfluenceUserManagementUtility usermanagementutils;
    private UserManagementPluginHandler pluginHandler;
    private CrowdService crowdService;
    private CrowdDirectoryService crowdDirectoryService;
    private UserDeactivaterScheduler userDeactivaterScheduler;
    private DirectoryManager directoryManager;
    private LoginManager loginManager;
    private ADUserDirectoryHelper directoryHelper;
    private CrowdDirectoryHelper crowdDirectoryHelper;
    private PermissionManager permissionManager;
    private Boolean wasInactive = false;
    private Boolean isAdDirReadOnly = false;
    private Boolean isCrowdDirReadOnly = false;
    private InetAddress ip = null;

    public MoLoginFilter(ConfluenceUserManagementUtility usermanagementutils, UserManagementPluginSettings settings, UserAccessor userAccessor, UserManagementPluginHandler pluginHandler, CrowdService crowdService, CrowdDirectoryService crowdDirectoryService, UserDeactivaterScheduler userDeactivaterScheduler, DirectoryManager directoryManager, LoginManager loginManager, ADUserDirectoryHelper directoryHelper, CrowdDirectoryHelper crowdDirectoryHelper, PermissionManager permissionManager) {
        this.settings = settings;
        this.userAccessor = userAccessor;
        this.usermanagementutils = usermanagementutils;
        this.pluginHandler = pluginHandler;
        this.crowdService = crowdService;
        this.crowdDirectoryService = crowdDirectoryService;
        this.userDeactivaterScheduler = userDeactivaterScheduler;
        this.directoryManager = directoryManager;
        this.loginManager = loginManager;
        this.directoryHelper = directoryHelper;
        this.crowdDirectoryHelper = crowdDirectoryHelper;
        this.permissionManager = permissionManager;
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        block19: {
            try {
                HttpServletRequest req = (HttpServletRequest)request;
                HttpServletResponse resp = (HttpServletResponse)response;
                String requestUrl = req.getRequestURL().toString();
                LOGGER.debug("Login filter has been invoked from the request URL: " + requestUrl);
                if (!this.usermanagementutils.isLicenseValid().booleanValue()) {
                    LOGGER.error("Invalid License.");
                    chain.doFilter(request, response);
                    return;
                }
                if (requestUrl.contains("/dologin.action")) {
                    if (this.settings.getReActivateUser().booleanValue() || this.settings.getAddGroupsToActiveUsers().booleanValue() || this.settings.getRemoveGroupsFromInactive().booleanValue() || this.settings.getRuleBaseGroupMapping().booleanValue()) {
                        String pwd;
                        String username = req.getParameter("os_username");
                        if (!this.isUserAuthenticated(username, pwd = req.getParameter("os_password")).booleanValue()) {
                            chain.doFilter(request, response);
                            return;
                        }
                        this.handleUserAction(username, pwd);
                    }
                    chain.doFilter(request, response);
                    return;
                }
                if (requestUrl.contains("/rest/tsv/1.0/authenticate")) {
                    HttpServletRequestWrapper wrappedRequest;
                    try {
                        wrappedRequest = new RestReadingServletRequest((HttpServletRequest)request);
                        wrappedRequest = new CachedBodyHttpServletRequestWrapper((HttpServletRequest)wrappedRequest);
                    }
                    catch (Exception e) {
                        chain.doFilter(request, response);
                        return;
                    }
                    if (this.settings.getReActivateUser().booleanValue() || this.settings.getAddGroupsToActiveUsers().booleanValue() || this.settings.getRemoveGroupsFromInactive().booleanValue() || this.settings.getRuleBaseGroupMapping().booleanValue()) {
                        String pwd;
                        StringBuilder requestBody = new StringBuilder();
                        try (BufferedReader reader = wrappedRequest.getReader();){
                            String line;
                            while ((line = reader.readLine()) != null) {
                                requestBody.append(line);
                            }
                        }
                        JSONObject jsonBody = new JSONObject(requestBody.toString());
                        String username = jsonBody.getString("username");
                        if (!this.isUserAuthenticated(username, pwd = jsonBody.getString("password")).booleanValue()) {
                            chain.doFilter((ServletRequest)wrappedRequest, response);
                            return;
                        }
                        this.handleUserAction(username, pwd);
                    }
                    chain.doFilter((ServletRequest)wrappedRequest, response);
                    break block19;
                }
                chain.doFilter(request, response);
            }
            catch (Exception e) {
                LOGGER.error("Error occurred while login: ", (Throwable)e);
                if (response.isCommitted()) break block19;
                chain.doFilter(request, response);
            }
        }
    }

    public void handleUserAction(String username, String pwd) throws UnknownHostException {
        block24: {
            InetAddress ip = InetAddress.getLocalHost();
            long userDir = this.crowdService.getUser(username).getDirectoryId();
            com.atlassian.crowd.model.user.User user = null;
            try {
                LOGGER.debug("User: " + username + " & User's Directory: " + this.directoryManager.findDirectoryById(userDir).getName());
                user = this.directoryManager.findUserByName(userDir, username);
                UserTemplate userTemplate = new UserTemplate((User)user);
                Directory directory = this.directoryManager.findDirectoryById(userDir);
                if (this.settings.getReActivateUser().booleanValue() && !userTemplate.isActive()) {
                    if ((this.isCrowdDirReadOnly.booleanValue() || this.isAdDirReadOnly.booleanValue()) && this.settings.getEnableReadOnlyDirAutoActivate().booleanValue()) {
                        if (this.settings.getRestrictLoginUsersGroups().booleanValue() && this.isUserInRestrictedGroups(username)) {
                            LOGGER.debug("User " + username + " is from external directory and belongs to restricted groups and will not be reactivated");
                            this.pluginHandler.storeAuditLogs(username, ip.getHostAddress(), "User Reactivation Blocked", "User belongs to restricted groups and reactivation is blocked", "Blocked");
                            return;
                        }
                        if (this.isAdDirReadOnly.booleanValue()) {
                            boolean isUserEnabled = this.directoryHelper.handleLdapUserOperation(username, Collections.emptyList(), ip.getHostAddress(), "enableUser");
                            this.pluginHandler.storeAuditLogs(username, ip.getHostAddress(), "User Reactivated", isUserEnabled ? "Deactivated user activated on successful authentication." : "Failed to activate user.", isUserEnabled ? "Success" : "Error");
                        } else {
                            this.crowdDirectoryHelper.handleCrowdUserOperation((User)user, "", directory, ip.getHostAddress(), "enableUser");
                        }
                    } else {
                        if (this.settings.getRestrictLoginUsersGroups().booleanValue() && this.isUserInRestrictedGroups(username)) {
                            LOGGER.debug("User " + username + " belongs to restricted groups and will not be reactivated");
                            this.pluginHandler.storeAuditLogs(username, ip.getHostAddress(), "User Reactivation Blocked", "User belongs to restricted groups and reactivation is blocked", "Blocked");
                            return;
                        }
                        userTemplate.setActive(true);
                        this.directoryManager.updateUser(userTemplate.getDirectoryId(), userTemplate);
                        LOGGER.debug(username + " has been successfully reactivated.");
                        this.pluginHandler.storeAuditLogs(username, ip.getHostAddress(), "User Reactivated", "Deactivated user activate on successful authentication", "Success");
                    }
                    if (this.settings.getAddGroupsToInactive().booleanValue()) {
                        List groupsToAdd = (List)this.settings.getAddGroups();
                        if ((this.isCrowdDirReadOnly.booleanValue() || this.isAdDirReadOnly.booleanValue()) && this.settings.getEnableReadOnlyDirAutoActivate().booleanValue() || directory.getType() == DirectoryType.INTERNAL) {
                            try {
                                this.usermanagementutils.addGroupFromExternalDirectoryUser((User)userTemplate, directory, groupsToAdd, ip.getHostAddress(), true);
                            }
                            catch (Exception e) {
                                LOGGER.error("Exception while adding group: " + String.valueOf(groupsToAdd) + " to user: " + userTemplate.getName(), (Throwable)e);
                            }
                        }
                        LOGGER.debug("Groups have been added to the user after reactivation: " + String.valueOf(groupsToAdd));
                    }
                    if (this.settings.getRemoveGroupsFromInactive().booleanValue() && ((this.isCrowdDirReadOnly.booleanValue() || this.isAdDirReadOnly.booleanValue()) && this.settings.getEnableReadOnlyDirAutoActivate().booleanValue() || directory.getType() == DirectoryType.INTERNAL)) {
                        this.removeGroups(username, directory);
                    }
                    break block24;
                }
                if (!this.settings.getAddGroupsToActiveUsers().booleanValue() && !this.settings.getRemoveGroupsFromInactive().booleanValue() && !this.settings.getRuleBaseGroupMapping().booleanValue() || !userTemplate.isActive()) break block24;
                if (this.settings.getAddGroupsToActiveUsers().booleanValue() && ((this.isCrowdDirReadOnly.booleanValue() || this.isAdDirReadOnly.booleanValue()) && this.settings.getEnableReadOnlyDirAutoActivate().booleanValue() || directory.getType() == DirectoryType.INTERNAL)) {
                    List groupsToAdd = (List)this.settings.getGroupsAssignToActiveUser();
                    try {
                        this.usermanagementutils.addGroupFromExternalDirectoryUser((User)userTemplate, directory, groupsToAdd, ip.getHostAddress(), true);
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception while adding group: " + String.valueOf(groupsToAdd) + " to user: " + userTemplate.getName(), (Throwable)e);
                    }
                    this.pluginHandler.storeAuditLogs(username, ip.getHostAddress(), "Groups Assigned to Active Users", "Groups Assigned to users on successful authentication", "Success");
                }
                if (this.settings.getRemoveGroupsFromInactive().booleanValue()) {
                    if ((this.isCrowdDirReadOnly.booleanValue() || this.isAdDirReadOnly.booleanValue()) && this.settings.getEnableReadOnlyDirAutoActivate().booleanValue() || directory.getType() == DirectoryType.INTERNAL) {
                        this.removeGroups(username, directory);
                    }
                    LOGGER.debug("Groups removed from active user: " + username);
                }
                if (this.settings.getRuleBaseGroupMapping().booleanValue()) {
                    Map<String, List<String>> groupMapping = this.settings.getGroupMapping();
                    List userGroups = this.userAccessor.getGroupNamesForUserName(username);
                    if ((this.isCrowdDirReadOnly.booleanValue() || this.isAdDirReadOnly.booleanValue()) && this.settings.getEnableFloatingLicenseForRODir().booleanValue() || directory.getType() == DirectoryType.INTERNAL) {
                        for (String userGroup : userGroups) {
                            List<String> groupsToAdd;
                            if (!groupMapping.containsKey(userGroup) || (groupsToAdd = groupMapping.get(userGroup)) == null || groupsToAdd.isEmpty()) continue;
                            LOGGER.debug("Found a mapping for user group [" + userGroup + "]. Adding new groups: " + String.valueOf(groupsToAdd));
                            try {
                                this.usermanagementutils.addGroupFromExternalDirectoryUser((User)userTemplate, directory, groupsToAdd, ip.getHostAddress(), true);
                                LOGGER.debug("Successfully added groups [" + String.valueOf(groupsToAdd) + "] to user [" + username + "].");
                            }
                            catch (Exception e) {
                                LOGGER.error("Exception while adding groups [" + String.valueOf(groupsToAdd) + "] to user [" + username + "].", (Throwable)e);
                            }
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("An issue occurred while fetching user details: ", (Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Boolean isUserAuthenticated(String username, String pwd) {
        if (StringUtils.isBlank((CharSequence)username)) return false;
        if (StringUtils.isBlank((CharSequence)pwd)) {
            return false;
        }
        try {
            User userInfo = this.crowdService.getUser(username);
            if (userInfo == null) {
                LOGGER.error("User not found: " + username);
                return false;
            }
            com.atlassian.crowd.model.user.User user = null;
            try {
                user = this.directoryManager.findUserByName(userInfo.getDirectoryId(), username);
            }
            catch (Exception e) {
                LOGGER.error("Failed to find user " + username + " in directory " + userInfo.getDirectoryId() + " due to: " + String.valueOf(e));
                return false;
            }
            if (user == null) {
                LOGGER.error("User not found in directory: " + username);
                return false;
            }
            Directory userDirectory = null;
            try {
                userDirectory = this.directoryManager.findDirectoryById(user.getDirectoryId());
            }
            catch (DirectoryNotFoundException e) {
                LOGGER.debug("Directory not found for userId {} in directory {}", new Object[]{user.getName(), user.getDirectoryId(), e});
                return false;
            }
            Set operation = userDirectory.getAllowedOperations();
            this.ip = InetAddress.getLocalHost();
            this.isAdDirReadOnly = userDirectory.getType() == DirectoryType.CONNECTOR && userDirectory.getImplementationClass().contains("MicrosoftActiveDirectory") && !operation.contains(OperationType.UPDATE_USER) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.isCrowdDirReadOnly = userDirectory.getType() == DirectoryType.CROWD && !operation.contains(OperationType.UPDATE_USER) ? Boolean.valueOf(true) : Boolean.valueOf(false);
            this.wasInactive = !user.isActive();
            UserTemplate userTemplate = null;
            if (this.wasInactive.booleanValue()) {
                if (!this.settings.getReActivateUser().booleanValue()) {
                    LOGGER.warn("User " + username + " is inactive and reactivation is disabled.");
                    return false;
                }
                if (this.isAdDirReadOnly.booleanValue()) {
                    this.directoryHelper.handleLdapUserOperation(username, new ArrayList<String>(), this.ip.getHostAddress(), "enableUser");
                } else if (this.isCrowdDirReadOnly.booleanValue()) {
                    this.crowdDirectoryHelper.handleCrowdUserOperation((User)user, "", userDirectory, this.ip.getHostAddress(), "enableUser");
                } else {
                    userTemplate = new UserTemplate((User)user);
                    userTemplate.setActive(true);
                    try {
                        this.directoryManager.updateUser(userTemplate.getDirectoryId(), userTemplate);
                    }
                    catch (Exception e) {
                        throw new RuntimeException(e);
                    }
                }
            }
            if (this.isAdDirReadOnly.booleanValue()) {
                Boolean isUserAuthenticate222 = this.directoryHelper.authenticateRawLdap(username, pwd);
                if (this.wasInactive == false) return isUserAuthenticate222;
                this.directoryHelper.handleLdapUserOperation(username, new ArrayList<String>(), this.ip.getHostAddress(), "disableUser");
                return isUserAuthenticate222;
            }
            try {
                this.crowdService.authenticate(username, pwd);
                Boolean isUserAuthenticate222 = true;
                return isUserAuthenticate222;
            }
            catch (FailedAuthenticationException e) {
                LOGGER.warn("Invalid credentials for user: " + username);
                Boolean bl = false;
                return bl;
            }
            finally {
                if (this.wasInactive.booleanValue()) {
                    if (this.isCrowdDirReadOnly.booleanValue()) {
                        this.crowdDirectoryHelper.handleCrowdUserOperation((User)user, "", userDirectory, this.ip.getHostAddress(), "disableUser");
                    } else {
                        userTemplate.setActive(false);
                        try {
                            this.directoryManager.updateUser(userTemplate.getDirectoryId(), userTemplate);
                        }
                        catch (Exception e4) {
                            throw new RuntimeException(e4);
                        }
                    }
                }
            }
        }
        catch (Exception e3) {
            LOGGER.error("Error authenticating user: " + username, (Throwable)e3);
            return false;
        }
    }

    public void removeGroups(String username, Directory directory) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException, UnknownHostException {
        InetAddress ip = InetAddress.getLocalHost();
        com.atlassian.crowd.model.user.User user = null;
        long userDir = this.crowdService.getUser(username).getDirectoryId();
        user = this.directoryManager.findUserByName(userDir, username);
        UserTemplate userTemplate = new UserTemplate((User)user);
        List groupsToRemove = (List)this.settings.getRemoveGroups();
        try {
            this.usermanagementutils.removeGroupFromExternalDirectoryUser((User)userTemplate, true, directory, groupsToRemove, null, ip.getHostAddress());
        }
        catch (Exception e) {
            LOGGER.error("Exception while removing group: " + String.valueOf(groupsToRemove) + " to user: " + userTemplate.getName(), (Throwable)e);
        }
        LOGGER.debug("Groups have been removed from the user: " + String.valueOf(groupsToRemove));
    }

    private boolean isUserInRestrictedGroups(String username) {
        try {
            if (!this.settings.getRestrictLoginUsersGroups().booleanValue()) {
                return false;
            }
            List<String> restrictedGroups = this.settings.getRestrictLoginUsersGroupsList();
            if (restrictedGroups == null || restrictedGroups.isEmpty()) {
                return false;
            }
            List userGroups = this.userAccessor.getGroupNamesForUserName(username);
            if (userGroups == null || userGroups.isEmpty()) {
                return false;
            }
            for (String restrictedGroup : restrictedGroups) {
                if (!userGroups.contains(restrictedGroup)) continue;
                LOGGER.debug("User " + username + " belongs to restricted group: " + restrictedGroup);
                return true;
            }
            return false;
        }
        catch (Exception e) {
            LOGGER.error("Error checking if user " + username + " belongs to restricted groups", (Throwable)e);
            return false;
        }
    }

    public void destroy() {
    }

    @Generated
    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    @Generated
    public UserAccessor getUserAccessor() {
        return this.userAccessor;
    }

    @Generated
    public ConfluenceUserManagementUtility getUsermanagementutils() {
        return this.usermanagementutils;
    }

    @Generated
    public UserManagementPluginHandler getPluginHandler() {
        return this.pluginHandler;
    }

    @Generated
    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    @Generated
    public CrowdDirectoryService getCrowdDirectoryService() {
        return this.crowdDirectoryService;
    }

    @Generated
    public UserDeactivaterScheduler getUserDeactivaterScheduler() {
        return this.userDeactivaterScheduler;
    }

    @Generated
    public DirectoryManager getDirectoryManager() {
        return this.directoryManager;
    }

    @Generated
    public LoginManager getLoginManager() {
        return this.loginManager;
    }

    @Generated
    public ADUserDirectoryHelper getDirectoryHelper() {
        return this.directoryHelper;
    }

    @Generated
    public CrowdDirectoryHelper getCrowdDirectoryHelper() {
        return this.crowdDirectoryHelper;
    }

    @Generated
    public PermissionManager getPermissionManager() {
        return this.permissionManager;
    }

    @Generated
    public Boolean getWasInactive() {
        return this.wasInactive;
    }

    @Generated
    public Boolean getIsAdDirReadOnly() {
        return this.isAdDirReadOnly;
    }

    @Generated
    public Boolean getIsCrowdDirReadOnly() {
        return this.isCrowdDirReadOnly;
    }

    @Generated
    public InetAddress getIp() {
        return this.ip;
    }

    @Generated
    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    @Generated
    public void setUserAccessor(UserAccessor userAccessor) {
        this.userAccessor = userAccessor;
    }

    @Generated
    public void setUsermanagementutils(ConfluenceUserManagementUtility usermanagementutils) {
        this.usermanagementutils = usermanagementutils;
    }

    @Generated
    public void setPluginHandler(UserManagementPluginHandler pluginHandler) {
        this.pluginHandler = pluginHandler;
    }

    @Generated
    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }

    @Generated
    public void setCrowdDirectoryService(CrowdDirectoryService crowdDirectoryService) {
        this.crowdDirectoryService = crowdDirectoryService;
    }

    @Generated
    public void setUserDeactivaterScheduler(UserDeactivaterScheduler userDeactivaterScheduler) {
        this.userDeactivaterScheduler = userDeactivaterScheduler;
    }

    @Generated
    public void setDirectoryManager(DirectoryManager directoryManager) {
        this.directoryManager = directoryManager;
    }

    @Generated
    public void setLoginManager(LoginManager loginManager) {
        this.loginManager = loginManager;
    }

    @Generated
    public void setDirectoryHelper(ADUserDirectoryHelper directoryHelper) {
        this.directoryHelper = directoryHelper;
    }

    @Generated
    public void setCrowdDirectoryHelper(CrowdDirectoryHelper crowdDirectoryHelper) {
        this.crowdDirectoryHelper = crowdDirectoryHelper;
    }

    @Generated
    public void setPermissionManager(PermissionManager permissionManager) {
        this.permissionManager = permissionManager;
    }

    @Generated
    public void setWasInactive(Boolean wasInactive) {
        this.wasInactive = wasInactive;
    }

    @Generated
    public void setIsAdDirReadOnly(Boolean isAdDirReadOnly) {
        this.isAdDirReadOnly = isAdDirReadOnly;
    }

    @Generated
    public void setIsCrowdDirReadOnly(Boolean isCrowdDirReadOnly) {
        this.isCrowdDirReadOnly = isCrowdDirReadOnly;
    }

    @Generated
    public void setIp(InetAddress ip) {
        this.ip = ip;
    }
}

