/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.confluence.migration;

import com.atlassian.plugin.spring.scanner.annotation.component.ConfluenceComponent;
import com.atlassian.plugin.spring.scanner.annotation.export.ExportAsService;
import com.miniorange.usermanagement.confluence.common.UserManagementPluginSettings;
import com.miniorange.usermanagement.confluence.scheduler.UserDeactivaterScheduler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.stereotype.Component;

@Component
@ExportAsService
@ConfluenceComponent
public class UserDeactivateMigration
implements InitializingBean,
DisposableBean {
    private static final Log LOGGER = LogFactory.getLog(UserDeactivateMigration.class);
    private final UserManagementPluginSettings pluginSettings;
    private final UserDeactivaterScheduler userDeactivaterScheduler;

    public UserDeactivateMigration(UserManagementPluginSettings pluginSettings, UserDeactivaterScheduler userDeactivaterScheduler) {
        this.pluginSettings = pluginSettings;
        this.userDeactivaterScheduler = userDeactivaterScheduler;
    }

    public void afterPropertiesSet() throws Exception {
        LOGGER.debug("User Deactivate Migration is running...");
        if (!this.pluginSettings.isUserDeactivateMigrationEnabled().booleanValue()) {
            LOGGER.debug("Starting migration of user deactivate settings");
            try {
                if (this.pluginSettings.getEnableAutoRemoveFromGroup().booleanValue() || this.pluginSettings.getAutoDeActivateUsers().booleanValue()) {
                    LOGGER.debug("Migrating Revoke Access settings: revokeDays=" + this.pluginSettings.getRevokeDays() + ", numberOfDays=" + this.pluginSettings.getNumberOfDays());
                    this.pluginSettings.setRevokeDays(this.pluginSettings.getNumberOfDays());
                    this.pluginSettings.setExcludeRevokeGroups(this.pluginSettings.getEnableExcludeGroups());
                    Object excludeGroups = this.pluginSettings.getExcludeGroups();
                    if (excludeGroups instanceof ArrayList) {
                        this.pluginSettings.setExcludeRevokeGroupsArray((ArrayList)excludeGroups);
                    } else {
                        this.pluginSettings.setExcludeRevokeGroupsArray(new ArrayList<String>());
                    }
                    this.pluginSettings.setRevokeDirectoryFilter(this.pluginSettings.getEnableDirectoryFilter());
                    Object directoryFilterList = this.pluginSettings.getDirectoryFilterList();
                    if (directoryFilterList instanceof ArrayList) {
                        this.pluginSettings.setRevokeDirectoryArray((ArrayList)directoryFilterList);
                    } else {
                        this.pluginSettings.setRevokeDirectoryArray(new ArrayList<String>());
                    }
                    this.pluginSettings.setRevokeNeverLoggedIn(this.pluginSettings.getAutoDeactivateNeverLoggedInUser());
                    this.pluginSettings.setRevokeNeverLoggedInDays(this.pluginSettings.getNumberofDaysAfterUserCreation());
                    this.pluginSettings.setRevokeCrowdReadOnly(this.pluginSettings.getEnableCrowdROUser());
                    LOGGER.debug("Revoke Access settings migration completed");
                } else {
                    LOGGER.debug("Skipping Revoke Access migration: Auto-remove and auto-deactivate not enabled");
                }
                if (this.pluginSettings.getRuleBaseGroupMapping().booleanValue()) {
                    List groupConditionList = (List)this.pluginSettings.getGroupCondition();
                    List addGroupBaseOnRuleList = (List)this.pluginSettings.getAddGroupBaseOnRule();
                    HashMap<String, List<String>> groupMapping = new HashMap<String, List<String>>();
                    if (groupConditionList != null && !groupConditionList.isEmpty() && addGroupBaseOnRuleList != null && !addGroupBaseOnRuleList.isEmpty()) {
                        for (int i = 0; i < groupConditionList.size(); ++i) {
                            String condition = (String)groupConditionList.get(i);
                            groupMapping.put(condition, new ArrayList(addGroupBaseOnRuleList));
                        }
                        this.pluginSettings.setGroupMapping(groupMapping);
                        LOGGER.info("Floating License settings migrated: groupMapping size=" + groupMapping.size());
                    } else {
                        Map<String, List<String>> existingGroupMapping = this.pluginSettings.getGroupMapping();
                        if (existingGroupMapping == null || existingGroupMapping.isEmpty()) {
                            this.pluginSettings.setGroupMapping(new HashMap<String, List<String>>());
                        }
                        LOGGER.debug("No valid Floating License data to migrate");
                    }
                } else {
                    Map<String, List<String>> existingGroupMapping = this.pluginSettings.getGroupMapping();
                    if (existingGroupMapping == null || existingGroupMapping.isEmpty()) {
                        this.pluginSettings.setGroupMapping(new HashMap<String, List<String>>());
                    }
                    LOGGER.debug("Skipping Floating License migration: ruleBaseGroupMapping not enabled");
                }
                this.pluginSettings.setGroupDays(this.pluginSettings.getNumberOfDays());
                LOGGER.debug("Migrated group days: inactiveUsersGroupsDays=" + this.pluginSettings.getNumberOfDays());
                long schedulerDays = this.pluginSettings.getScheduler_days();
                long schedulerTimeHour = this.pluginSettings.getCustomSchedulerTimeHour();
                long schedulerTimeMinute = this.pluginSettings.getCustomSchedulerTimeMinute();
                LOGGER.debug("Migrating scheduler settings: days=" + schedulerDays + ", hour=" + schedulerTimeHour + ", minute=" + schedulerTimeMinute);
                if (this.pluginSettings.getAutoDeActivateUsers().booleanValue() || this.pluginSettings.getEnableAutoRemoveFromGroup().booleanValue() || this.pluginSettings.getEnableAutoAddGroupToUser().booleanValue()) {
                    this.pluginSettings.setPreviousSchedulerFlag(true);
                    this.userDeactivaterScheduler.schedule();
                    LOGGER.info("Scheduler settings migrated and scheduled");
                } else {
                    this.userDeactivaterScheduler.unschedule();
                    LOGGER.info("Scheduler settings migrated and unscheduled");
                }
                this.pluginSettings.setUserDeactivateMigrationEnabled(true);
                LOGGER.info("User deactivate migration completed successfully");
            }
            catch (Exception e) {
                LOGGER.error("User deactivate migration failed: " + e.getMessage(), e);
                throw e;
            }
        } else {
            LOGGER.debug("Skipping migration: already performed");
        }
    }

    public void destroy() throws Exception {
    }

    public String toString() {
        return "UserDeactivateMigration{}";
    }
}

